/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import org.netbeans.api.languages.ASTEvaluator;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.features.ColorsManager;
import org.netbeans.modules.languages.features.SemanticHighlightsLayer;

public class ColorsASTEvaluator
extends ASTEvaluator {
    private static Map<Document, WeakReference<ColorsASTEvaluator>> cache = new WeakHashMap<Document, WeakReference<ColorsASTEvaluator>>();
    private Document document;

    static void register(Document document) {
        if (ColorsASTEvaluator.get(document) != null) {
            return;
        }
        cache.put(document, new WeakReference<ColorsASTEvaluator>(new ColorsASTEvaluator(document)));
    }

    static void unregister(Document document) {
        ColorsASTEvaluator evaluator = ColorsASTEvaluator.get(document);
        if (evaluator != null) {
            ParserManager.get(document).removeASTEvaluator(evaluator);
        }
        cache.remove(document);
    }

    static ColorsASTEvaluator get(Document document) {
        WeakReference<ColorsASTEvaluator> weakReference = cache.get(document);
        if (weakReference == null) {
            return null;
        }
        return (ColorsASTEvaluator)weakReference.get();
    }

    private ColorsASTEvaluator(Document document) {
        this.document = document;
        ParserManager.get(document).addASTEvaluator(this);
    }

    @Override
    public String getFeatureName() {
        return "COLOR";
    }

    @Override
    public void beforeEvaluation(ParserManager.State state, ASTNode root) {
        if (state == ParserManager.State.PARSING) {
            return;
        }
    }

    @Override
    public void afterEvaluation(ParserManager.State state, ASTNode root) {
    }

    @Override
    public void evaluate(ParserManager.State state, List<ASTItem> path, Feature feature) {
        if (state == ParserManager.State.PARSING) {
            return;
        }
        SimpleAttributeSet attributeSet = null;
        ASTItem leaf = path.get(path.size() - 1);
        SyntaxContext context = SyntaxContext.create(this.document, ASTPath.create(path));
        if (feature.getBoolean("condition", context, true)) {
            attributeSet = ColorsManager.createColoring(feature, null);
            SemanticHighlightsLayer.addHighlight(this.document, leaf.getOffset(), leaf.getEndOffset(), attributeSet);
        }
    }
}

