import { getFoldableComposition } from './Foldable2v';
import { getFunctorComposition } from './Functor';
export function getTraversableComposition(F, G) {
    return Object.assign({}, getFunctorComposition(F, G), getFoldableComposition(F, G), { traverse: H => {
            const traverseF = F.traverse(H);
            const traverseG = G.traverse(H);
            return (fga, f) => traverseF(fga, ga => traverseG(ga, f));
        }, sequence: H => {
            const sequenceF = F.sequence(H);
            const sequenceG = G.sequence(H);
            return fgha => sequenceF(F.map(fgha, sequenceG));
        } });
}
