/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.cli.core;

import java.util.Scanner;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;

public class CLIStreamListener
implements IStreamListener {
    private static final String ERROR_PREFIX = "Error:";
    private static final String WIN_ERROR_PATTERN = "is not recognized as an internal or external command";
    private StringBuffer errorMessage = new StringBuffer();
    private final StringBuffer message = new StringBuffer();

    public void streamAppended(String text, IStreamMonitor monitor) {
        Scanner scanner = new Scanner(text);
        boolean error = false;
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if ((line = line.trim()).startsWith(ERROR_PREFIX)) {
                error = true;
                this.errorMessage = this.errorMessage.append(line.substring(ERROR_PREFIX.length(), line.length()));
                continue;
            }
            if (line.contains(WIN_ERROR_PATTERN)) {
                error = true;
                this.errorMessage = this.errorMessage.append(line);
                continue;
            }
            if (error) {
                this.errorMessage.append(System.lineSeparator());
                this.errorMessage.append(line);
                continue;
            }
            this.message.append(line);
            this.message.append(System.lineSeparator());
        }
        scanner.close();
    }

    public String getErrorMessage() {
        return this.errorMessage.toString();
    }

    public String getMessage() {
        return this.message.toString();
    }
}

