/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsSerializableProvider;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.internal.qt.core.QtIncludePaths;
import org.eclipse.core.resources.IResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QtIncludePathsProvider
extends LanguageSettingsSerializableProvider {
    private final Map<String, QtIncludePaths> qtInstallHeaders = new HashMap<String, QtIncludePaths>();
    private static final String ENVVAR_QMAKE = "QMAKE";
    private static final String ELEMENT_QMAKE = "qmake";

    public boolean equals(Object obj) {
        if (!(obj instanceof QtIncludePathsProvider)) {
            return super.equals(obj);
        }
        QtIncludePathsProvider other = (QtIncludePathsProvider)((Object)obj);
        if (this.qtInstallHeaders == null) {
            return other.qtInstallHeaders == null;
        }
        return this.qtInstallHeaders.equals(other.qtInstallHeaders);
    }

    public int hashCode() {
        return this.qtInstallHeaders == null ? 0 : this.qtInstallHeaders.hashCode();
    }

    public void loadEntries(Element providerNode) {
        super.loadEntries(providerNode);
        NodeList children = providerNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            QtIncludePaths qtIncludePaths;
            Node child = children.item(i);
            if (ELEMENT_QMAKE.equals(child.getNodeName()) && (qtIncludePaths = QtIncludePaths.loadFrom(child)) != null && qtIncludePaths.isValid()) {
                this.qtInstallHeaders.put(qtIncludePaths.getQMakePath(), qtIncludePaths);
            }
            ++i;
        }
    }

    public void serializeEntries(Element parent) {
        Document document = parent instanceof Document ? (Document)((Object)parent) : parent.getOwnerDocument();
        for (QtIncludePaths qtIncludePaths : this.qtInstallHeaders.values()) {
            Element child = document.createElement(ELEMENT_QMAKE);
            qtIncludePaths.serialize(child);
            parent.appendChild(child);
        }
    }

    public synchronized List<ICLanguageSettingEntry> getSettingEntries(ICConfigurationDescription configDesc, IResource rc, String languageId) {
        if (!this.getLanguageScope().contains(languageId)) {
            return null;
        }
        IEnvironmentVariable qmake_var = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariable(ENVVAR_QMAKE, configDesc, true);
        if (qmake_var == null) {
            return null;
        }
        String qmake = qmake_var.getValue();
        if (qmake == null) {
            return null;
        }
        QtIncludePaths paths = this.qtInstallHeaders.get(qmake);
        if (paths == null) {
            paths = new QtIncludePaths(qmake);
            this.qtInstallHeaders.put(qmake, paths);
        }
        return paths.getSettingEntries(configDesc, null, languageId);
    }
}

