/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *  strict-local
 * @format
 */
'use strict';

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _inheritsLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/inheritsLoose"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _taggedTemplateLiteral2 = _interopRequireDefault(require("./taggedTemplateLiteral"));

function _templateObject2() {
  var data = (0, _taggedTemplateLiteral2["default"])(["\n    fragment ReactRelayFragmentContainerFlowtest_Bar_viewer on Viewer {\n      actor {\n        id\n      }\n    }\n  "]);

  _templateObject2 = function _templateObject2() {
    return data;
  };

  return data;
}

function _templateObject() {
  var data = (0, _taggedTemplateLiteral2["default"])(["\n    fragment ReactRelayFragmentContainerFlowtest_Foo_viewer on Viewer {\n      actor {\n        id\n      }\n    }\n  "]);

  _templateObject = function _templateObject() {
    return data;
  };

  return data;
}

var React = require("react");

var _require = require("./ReactRelayPublic"),
    graphql = _require.graphql,
    createFragmentContainer = _require.createFragmentContainer;
/**
 * Verifies that normal prop type checking, as well as the methods proxying Relay does, is
 * type-checked correctly on Relay components.
 */


var FooComponent = function FooComponent(_ref) {
  var requiredProp = _ref.requiredProp;
  return React.createElement("div", null, requiredProp);
}; // Note that we must reassign to a new identifier to make sure flow doesn't propogate types without
// the relay type definition doing the work.


var Foo = createFragmentContainer(FooComponent, graphql(_templateObject()));

var BarComponent =
/*#__PURE__*/
function (_React$Component) {
  (0, _inheritsLoose2["default"])(BarComponent, _React$Component);

  function BarComponent() {
    return _React$Component.apply(this, arguments) || this;
  }

  var _proto = BarComponent.prototype;

  _proto.getNum = function getNum() {
    return 42;
  };

  _proto.render = function render() {
    var reqLen = this.props.requiredProp.length;
    var optionalProp = this.props.optionalProp;
    /** $FlowExpectedError: `optionalProp` might be null **/

    var optionalFoo = this.props.optionalProp.foo;
    /** $FlowExpectedError: there is no prop `missingProp` **/

    var missing = this.props.missingProp;
    var defLen = this.props.defaultProp.length; // always a valid string, so no error

    return React.createElement("div", null, reqLen && optionalProp && optionalFoo && missing && defLen);
  };

  return BarComponent;
}(React.Component);

(0, _defineProperty2["default"])(BarComponent, "defaultProps", {
  defaultProp: 'default'
});
var Bar = createFragmentContainer(BarComponent, graphql(_templateObject2()));
module.exports = {
  checkMissingPropOnFunctionalComponent: function checkMissingPropOnFunctionalComponent() {
    /** $FlowExpectedError: Foo missing `requiredProp` **/
    return React.createElement(Foo, null);
  },
  checkMinimalPropsOnFunctionalComponent: function checkMinimalPropsOnFunctionalComponent() {
    // Fine, no expected errors
    return React.createElement(Foo, {
      requiredProp: "foo"
    });
  },
  checkMissingPropOnClassComponent: function checkMissingPropOnClassComponent() {
    /** $FlowExpectedError: Bar missing `requiredProp` **/
    return React.createElement(Bar, null);
  },
  checkMinimalPropsOnClassComponent: function checkMinimalPropsOnClassComponent() {
    // All is well
    return React.createElement(Bar, {
      requiredProp: "foo"
    });
  },
  checkWrongPropType: function checkWrongPropType() {
    /** $FlowExpectedError: Bar wrong `requiredProp` type, should be string **/
    return React.createElement(Bar, {
      requiredProp: 17
    });
  },
  checkWrongOptionalType: function checkWrongOptionalType() {
    /** $FlowExpectedError: Bar wrong `optionalProp` type, should be `{foo: string}` **/
    return React.createElement(Bar, {
      optionalProp: "wrongType",
      requiredProp: "foo"
    });
  },
  checkNullOptionalType: function checkNullOptionalType() {
    /** $FlowExpectedError: Bar `optionalProp` must be omitted or truthy, not null **/
    return React.createElement(Bar, {
      optionalProp: null,
      requiredProp: "foo"
    });
  },
  checkWrongDefaultPropType: function checkWrongDefaultPropType() {
    /** $FlowExpectedError: Bar wrong `defaultProp` type, should be string **/
    return React.createElement(Bar, {
      defaultProp: false,
      requiredProp: "foo"
    });
  },
  checkAllPossibleProps: function checkAllPossibleProps() {
    // All is well
    return React.createElement(Bar, {
      defaultProp: "bar",
      optionalProp: {
        foo: 42
      },
      requiredProp: "foo"
    });
  },
  checkMinimalPropSpread: function checkMinimalPropSpread() {
    // All is well
    var props = {
      requiredProp: 'foo'
    };
    return React.createElement(Bar, props);
  },
  checkMissingPropSpread: function checkMissingPropSpread() {
    var props = {
      defaultProp: 'foo'
    };
    /** $FlowExpectedError: Bar missing `requiredProp` with spread **/

    return React.createElement(Bar, props);
  },
  checkStaticsAndMethodsProxying: function checkStaticsAndMethodsProxying() {
    var ProxyChecker =
    /*#__PURE__*/
    function (_React$PureComponent) {
      (0, _inheritsLoose2["default"])(ProxyChecker, _React$PureComponent);

      function ProxyChecker() {
        return _React$PureComponent.apply(this, arguments) || this;
      }

      var _proto2 = ProxyChecker.prototype;

      _proto2.getString = function getString() {
        var ok = this._barRef ? this._barRef.getNum() : 'default'; // legit

        /** $FlowExpectedError: Bar does not have `missingMethod` **/

        var bad = this._barRef ? this._barRef.missingMethod() : 'default';
        /** $FlowExpectedError: Bar `getNum` gives number, but `getString` assumes string  **/

        return bad ? 'not good' : ok;
      };

      _proto2.render = function render() {
        var _this = this;

        return React.createElement(Bar, {
          componentRef: function componentRef(ref) {
            _this._barRef = ref;
          },
          requiredProp: "bar"
        });
      };

      return ProxyChecker;
    }(React.PureComponent);

    return React.createElement(ProxyChecker, null);
  }
};