"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _propTypes2 = require("../prop-types");

var _commitDetailContainer = _interopRequireDefault(require("../containers/commit-detail-container"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CommitDetailItem extends _react["default"].Component {
  static buildURI(workingDirectory, sha) {
    return `atom-github://commit-detail?workdir=${encodeURIComponent(workingDirectory)}&sha=${encodeURIComponent(sha)}`;
  }

  constructor(props) {
    super(props);

    _defineProperty(this, "destroy", () => {
      /* istanbul ignore else */
      if (!this.isDestroyed) {
        this.emitter.emit('did-destroy');
        this.isDestroyed = true;
      }
    });

    this.emitter = new _eventKit.Emitter();
    this.isDestroyed = false;
    this.hasTerminatedPendingState = false;
    this.shouldFocus = true;
    this.refInitialFocus = new _refHolder["default"]();
    this.refEditor = new _refHolder["default"]();
    this.refEditor.observe(editor => {
      if (editor.isAlive()) {
        this.emitter.emit('did-change-embedded-text-editor', editor);
      }
    });
  }

  terminatePendingState() {
    if (!this.hasTerminatedPendingState) {
      this.emitter.emit('did-terminate-pending-state');
      this.hasTerminatedPendingState = true;
    }
  }

  onDidTerminatePendingState(callback) {
    return this.emitter.on('did-terminate-pending-state', callback);
  }

  onDidDestroy(callback) {
    return this.emitter.on('did-destroy', callback);
  }

  render() {
    const repository = this.props.workdirContextPool.getContext(this.props.workingDirectory).getRepository();
    return _react["default"].createElement(_commitDetailContainer["default"], _extends({
      itemType: this.constructor,
      repository: repository
    }, this.props, {
      destroy: this.destroy,
      refEditor: this.refEditor,
      refInitialFocus: this.refInitialFocus
    }));
  }

  getTitle() {
    return `Commit: ${this.props.sha}`;
  }

  getIconName() {
    return 'git-commit';
  }

  observeEmbeddedTextEditor(cb) {
    this.refEditor.map(editor => editor.isAlive() && cb(editor));
    return this.emitter.on('did-change-embedded-text-editor', cb);
  }

  getWorkingDirectory() {
    return this.props.workingDirectory;
  }

  getSha() {
    return this.props.sha;
  }

  serialize() {
    return {
      deserializer: 'CommitDetailStub',
      uri: CommitDetailItem.buildURI(this.props.workingDirectory, this.props.sha)
    };
  }

  preventFocus() {
    this.shouldFocus = false;
  }

  focus() {
    this.refInitialFocus.getPromise().then(focusable => {
      if (!this.shouldFocus) {
        return;
      }

      focusable.focus();
    });
  }

}

exports["default"] = CommitDetailItem;

_defineProperty(CommitDetailItem, "propTypes", {
  workdirContextPool: _propTypes2.WorkdirContextPoolPropType.isRequired,
  workingDirectory: _propTypes["default"].string.isRequired,
  sha: _propTypes["default"].string.isRequired
});

_defineProperty(CommitDetailItem, "uriPattern", 'atom-github://commit-detail?workdir={workingDirectory}&sha={sha}');
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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