/*
 * Decompiled with CFR 0.152.
 */
package org.openide.modules;

import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public abstract class InstalledFileLocator {
    private static final InstalledFileLocator DEFAULT = new InstalledFileLocator(){

        @Override
        public File locate(String string, String string2, boolean bl) {
            InstalledFileLocator[] installedFileLocatorArray = InstalledFileLocator.getInstances();
            for (int i = 0; i < installedFileLocatorArray.length; ++i) {
                File file = installedFileLocatorArray[i].locate(string, string2, bl);
                if (file == null) continue;
                return file;
            }
            return null;
        }

        @Override
        public Set<File> locateAll(String string, String string2, boolean bl) {
            Set<File> set = null;
            for (InstalledFileLocator installedFileLocator : InstalledFileLocator.getInstances()) {
                Set<File> set2 = installedFileLocator.locateAll(string, string2, bl);
                if (set2.isEmpty()) continue;
                if (set == null) {
                    set = set2;
                    continue;
                }
                set = new LinkedHashSet<File>(set);
                set.addAll(set2);
            }
            return set != null ? set : Collections.emptySet();
        }
    };
    private static InstalledFileLocator[] instances = null;
    private static Lookup.Result<InstalledFileLocator> result = null;
    private static final Object LOCK = new String(InstalledFileLocator.class.getName());

    protected InstalledFileLocator() {
    }

    public abstract File locate(String var1, String var2, boolean var3);

    public Set<File> locateAll(String string, String string2, boolean bl) {
        File file = this.locate(string, string2, bl);
        return file != null ? Collections.singleton(file) : Collections.emptySet();
    }

    public static InstalledFileLocator getDefault() {
        return DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InstalledFileLocator[] getInstances() {
        Lookup.Result result = LOCK;
        synchronized (result) {
            if (instances != null) {
                return instances;
            }
        }
        Object object = LOCK;
        synchronized (object) {
            result = InstalledFileLocator.result;
        }
        if (result == null) {
            result = Lookup.getDefault().lookupResult(InstalledFileLocator.class);
            result.addLookupListener(new LookupListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resultChanged(LookupEvent lookupEvent) {
                    Object object = LOCK;
                    synchronized (object) {
                        InstalledFileLocator.access$202(null);
                    }
                }
            });
            object = LOCK;
            synchronized (object) {
                InstalledFileLocator.result = result;
            }
        }
        object = result.allInstances();
        Object object2 = LOCK;
        synchronized (object2) {
            instances = object.toArray(new InstalledFileLocator[object.size()]);
            return instances;
        }
    }

    static /* synthetic */ InstalledFileLocator[] access$202(InstalledFileLocator[] installedFileLocatorArray) {
        instances = installedFileLocatorArray;
        return installedFileLocatorArray;
    }
}

