/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.layout.region;

import com.sun.javafx.css.Size;
import com.sun.javafx.css.SizeUnits;
import com.sun.javafx.css.StyleConverterImpl;
import javafx.css.ParsedValue;
import javafx.scene.layout.BorderWidths;
import javafx.scene.text.Font;

public class BorderImageWidthConverter
extends StyleConverterImpl<ParsedValue[], BorderWidths> {
    private static final BorderImageWidthConverter CONVERTER_INSTANCE = new BorderImageWidthConverter();

    public static BorderImageWidthConverter getInstance() {
        return CONVERTER_INSTANCE;
    }

    private BorderImageWidthConverter() {
    }

    @Override
    public BorderWidths convert(ParsedValue<ParsedValue[], BorderWidths> value, Font font) {
        Size size;
        ParsedValue[] sides = value.getValue();
        assert (sides.length == 4);
        double top = 1.0;
        double right = 1.0;
        double bottom = 1.0;
        double left = 1.0;
        boolean topPercent = false;
        boolean rightPercent = false;
        boolean bottomPercent = false;
        boolean leftPercent = false;
        ParsedValue val = sides[0];
        if ("auto".equals(val.getValue())) {
            top = -1.0;
        } else {
            size = (Size)val.convert(font);
            top = size.pixels(font);
            topPercent = size.getUnits() == SizeUnits.PERCENT;
        }
        val = sides[1];
        if ("auto".equals(val.getValue())) {
            right = -1.0;
        } else {
            size = (Size)val.convert(font);
            right = size.pixels(font);
            rightPercent = size.getUnits() == SizeUnits.PERCENT;
        }
        val = sides[2];
        if ("auto".equals(val.getValue())) {
            bottom = -1.0;
        } else {
            size = (Size)val.convert(font);
            bottom = size.pixels(font);
            bottomPercent = size.getUnits() == SizeUnits.PERCENT;
        }
        val = sides[3];
        if ("auto".equals(val.getValue())) {
            left = -1.0;
        } else {
            size = (Size)val.convert(font);
            left = size.pixels(font);
            leftPercent = size.getUnits() == SizeUnits.PERCENT;
        }
        return new BorderWidths(top, right, bottom, left, topPercent, rightPercent, bottomPercent, leftPercent);
    }

    public String toString() {
        return "BorderImageWidthConverter";
    }
}

