/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax.im;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import processing.app.syntax.JEditTextArea;

public class CompositionTextPainter {
    private TextLayout composedTextLayout;
    private int composedBeginCaretPosition = 0;
    private JEditTextArea textArea;
    private boolean caretColorFlag;
    private TextHitInfo caret;

    public CompositionTextPainter(JEditTextArea textArea) {
        this.textArea = textArea;
        this.composedTextLayout = null;
    }

    public boolean hasComposedTextLayout() {
        return this.composedTextLayout != null;
    }

    public void setComposedTextLayout(TextLayout composedTextLayout, int composedStartCaretPosition) {
        this.composedTextLayout = composedTextLayout;
        this.composedBeginCaretPosition = composedStartCaretPosition;
    }

    public void invalidateComposedTextLayout(int composedEndCaretPosition) {
        this.composedTextLayout = null;
        this.composedBeginCaretPosition = composedEndCaretPosition;
    }

    public void draw(Graphics gfx, Color fillBackGroundColor) {
        if (this.composedTextLayout != null) {
            Point composedLoc = this.getCaretLocation();
            this.composedTextLayout.draw((Graphics2D)gfx, composedLoc.x, composedLoc.y);
            if (this.caret != null) {
                int caretLocation = Math.round(this.composedTextLayout.getCaretInfo(this.caret)[0]);
                Rectangle rect = new Rectangle(composedLoc.x + caretLocation, composedLoc.y - (int)this.composedTextLayout.getAscent(), 1, (int)this.composedTextLayout.getAscent() + (int)this.composedTextLayout.getDescent());
                Color c = gfx.getColor();
                if (this.caretColorFlag) {
                    this.caretColorFlag = false;
                    gfx.setColor(Color.WHITE);
                } else {
                    this.caretColorFlag = true;
                    gfx.setColor(Color.BLACK);
                }
                gfx.fillRect(rect.x, rect.y, rect.width, rect.height);
                gfx.setColor(c);
            }
        }
    }

    private Point getCaretLocation() {
        int line = this.textArea.getCaretLine();
        int offsetX = this.composedBeginCaretPosition - this.textArea.getLineStartOffset(line);
        return new Point(this.textArea.offsetToX(line, offsetX), this.textArea.lineToY(line + 1));
    }

    public void setCaret(TextHitInfo caret) {
        this.caret = caret;
    }
}

