/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.io.SeekableSource;
import org.sejda.io.SeekableSources;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.exception.TaskWrongPasswordException;
import org.sejda.model.input.PdfFileSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.input.PdfStreamSource;
import org.sejda.model.input.PdfURLSource;
import org.sejda.sambox.input.PDFParser;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.encryption.InvalidPasswordException;

public class DefaultPdfSourceOpener
implements PdfSourceOpener<PDDocumentHandler> {
    private static final String WRONG_PWD_MESSAGE = "Unable to open '%s' due to a wrong password.";
    private static final String ERROR_MESSAGE = "An error occurred opening the source: %s.";

    public PDDocumentHandler open(PdfURLSource source) throws TaskIOException {
        try {
            PDDocument document = PDFParser.parse((SeekableSource)SeekableSources.onTempFileSeekableSourceFrom((InputStream)source.getSource().openStream()), (String)source.getPassword());
            return new PDDocumentHandler(document);
        }
        catch (InvalidPasswordException ipe) {
            throw new TaskWrongPasswordException(String.format(WRONG_PWD_MESSAGE, source.getSource()), (Throwable)ipe);
        }
        catch (IOException e) {
            throw new TaskIOException(String.format(ERROR_MESSAGE, source), (Throwable)e);
        }
    }

    public PDDocumentHandler open(PdfFileSource source) throws TaskIOException {
        try {
            PDDocument document = PDFParser.parse((SeekableSource)SeekableSources.seekableSourceFrom((File)source.getSource()), (String)source.getPassword());
            return new PDDocumentHandler(document);
        }
        catch (InvalidPasswordException ipe) {
            throw new TaskWrongPasswordException(String.format(WRONG_PWD_MESSAGE, source.getSource().getName()), (Throwable)ipe);
        }
        catch (IOException e) {
            throw new TaskIOException(String.format(ERROR_MESSAGE, source), (Throwable)e);
        }
    }

    public PDDocumentHandler open(PdfStreamSource source) throws TaskIOException {
        try {
            PDDocument document = PDFParser.parse((SeekableSource)SeekableSources.onTempFileSeekableSourceFrom((InputStream)source.getSource()), (String)source.getPassword());
            return new PDDocumentHandler(document);
        }
        catch (InvalidPasswordException ipe) {
            throw new TaskWrongPasswordException(String.format(WRONG_PWD_MESSAGE, source.getSource()), (Throwable)ipe);
        }
        catch (IOException e) {
            throw new TaskIOException(String.format(ERROR_MESSAGE, source), (Throwable)e);
        }
    }
}

