/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.split;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TitledPane;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.builder.Builder;
import org.pdfsam.context.UserContext;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.ModuleCategory;
import org.pdfsam.module.ModuleDescriptor;
import org.pdfsam.module.ModuleDescriptorBuilder;
import org.pdfsam.module.ModuleInputOutputType;
import org.pdfsam.module.ModulePriority;
import org.pdfsam.split.SplitOptionsPane;
import org.pdfsam.support.params.AbstractPdfOutputParametersBuilder;
import org.pdfsam.support.params.MultipleOutputTaskParametersBuilder;
import org.pdfsam.support.params.SinglePdfSourceMultipleOutputParametersBuilder;
import org.pdfsam.support.params.SinglePdfSourceTaskParametersBuilder;
import org.pdfsam.ui.commons.ClearModuleEvent;
import org.pdfsam.ui.io.BrowsableField;
import org.pdfsam.ui.io.BrowsableOutputDirectoryField;
import org.pdfsam.ui.io.PdfDestinationPane;
import org.pdfsam.ui.module.BaseTaskExecutionModule;
import org.pdfsam.ui.module.Footer;
import org.pdfsam.ui.module.OpenButton;
import org.pdfsam.ui.module.RunButton;
import org.pdfsam.ui.prefix.PrefixPane;
import org.pdfsam.ui.selection.single.TaskParametersBuilderSingleSelectionPane;
import org.pdfsam.ui.support.Views;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.eventstudio.annotation.EventStation;
import org.sejda.injector.Auto;
import org.sejda.injector.Components;
import org.sejda.injector.Provides;
import org.sejda.model.parameter.AbstractSplitByPageParameters;
import org.sejda.model.prefix.Prefix;

@Auto
public class SplitModule
extends BaseTaskExecutionModule {
    private static final String MODULE_ID = "split.simple";
    private TaskParametersBuilderSingleSelectionPane selectionPane;
    private BrowsableOutputDirectoryField destinationDirectoryField;
    private PdfDestinationPane destinationPane;
    private SplitOptionsPane splitOptions = new SplitOptionsPane();
    private PrefixPane prefix = new PrefixPane();
    private ModuleDescriptor descriptor = ModuleDescriptorBuilder.builder().category(ModuleCategory.SPLIT).inputTypes(new ModuleInputOutputType[]{ModuleInputOutputType.SINGLE_PDF}).name(DefaultI18nContext.getInstance().i18n("Split")).description(DefaultI18nContext.getInstance().i18n("Split a PDF document at the given page numbers.")).priority(ModulePriority.HIGH.getPriority()).supportURL("http://www.pdfsam.org/pdf-split").build();

    @Inject
    public SplitModule(@Named(value="split.simplefield") BrowsableOutputDirectoryField destinationDirectoryField, @Named(value="split.simplepane") PdfDestinationPane destinationPane, @Named(value="split.simplefooter") Footer footer) {
        super(footer);
        this.destinationDirectoryField = destinationDirectoryField;
        this.destinationPane = destinationPane;
        this.selectionPane = new TaskParametersBuilderSingleSelectionPane(this.id());
        this.selectionPane.setPromptText(DefaultI18nContext.getInstance().i18n("Select or drag and drop the PDF you want to split"));
        this.selectionPane.addOnLoaded(d -> this.splitOptions.setMaxPages((Integer)d.pages().getValue()));
        this.initModuleSettingsPanel(this.settingPanel());
    }

    public ModuleDescriptor descriptor() {
        return this.descriptor;
    }

    public void onSaveWorkspace(Map<String, String> data) {
        this.selectionPane.saveStateTo(data);
        this.splitOptions.saveStateTo(data);
        this.destinationDirectoryField.saveStateTo(data);
        this.destinationPane.saveStateTo(data);
        this.prefix.saveStateTo(data);
    }

    public void onLoadWorkspace(Map<String, String> data) {
        this.selectionPane.restoreStateFrom(data);
        this.splitOptions.restoreStateFrom(data);
        this.destinationDirectoryField.restoreStateFrom(data);
        this.destinationPane.restoreStateFrom(data);
        this.prefix.restoreStateFrom(data);
    }

    protected Builder<? extends AbstractSplitByPageParameters> getBuilder(Consumer<String> onError) {
        Optional<SinglePdfSourceMultipleOutputParametersBuilder<? extends AbstractSplitByPageParameters>> builder = Optional.ofNullable(this.splitOptions.getBuilder(onError));
        builder.ifPresent(b -> {
            this.selectionPane.apply((SinglePdfSourceTaskParametersBuilder)b, onError);
            this.destinationDirectoryField.apply((MultipleOutputTaskParametersBuilder)b, onError);
            this.destinationPane.apply((AbstractPdfOutputParametersBuilder)b, onError);
            this.prefix.apply((MultipleOutputTaskParametersBuilder)b, onError);
        });
        return builder.orElse(null);
    }

    private VBox settingPanel() {
        VBox pane = new VBox();
        pane.setAlignment(Pos.TOP_CENTER);
        TitledPane prefixTitled = Views.titledPane((String)DefaultI18nContext.getInstance().i18n("File names settings"), (Node)this.prefix);
        this.prefix.addMenuItemFor(new Prefix[]{Prefix.CURRENTPAGE});
        this.prefix.addMenuItemFor(new Prefix[]{Prefix.FILENUMBER});
        this.prefix.addMenuItemFor(new String[]{"[TOTAL_FILESNUMBER]"});
        pane.getChildren().addAll((Object[])new Node[]{this.selectionPane, Views.titledPane((String)DefaultI18nContext.getInstance().i18n("Split settings"), (Node)this.splitOptions), Views.titledPane((String)DefaultI18nContext.getInstance().i18n("Output settings"), (Node)this.destinationPane), prefixTitled});
        return pane;
    }

    @EventListener
    public void onClearModule(ClearModuleEvent e) {
        if (e.clearEverything) {
            this.splitOptions.resetView();
            this.prefix.resetView();
            this.destinationPane.resetView();
        }
    }

    @EventStation
    public String id() {
        return MODULE_ID;
    }

    public Node graphic() {
        return new ImageView("split.png");
    }

    @Components(value={SplitModule.class})
    public static class ModuleConfig {
        @Provides
        @Named(value="split.simplefield")
        public BrowsableOutputDirectoryField destinationDirectoryField() {
            return new BrowsableOutputDirectoryField();
        }

        @Provides
        @Named(value="split.simplepane")
        public PdfDestinationPane destinationPane(@Named(value="split.simplefield") BrowsableOutputDirectoryField outputField, UserContext userContext) {
            PdfDestinationPane panel = new PdfDestinationPane((BrowsableField)outputField, SplitModule.MODULE_ID, userContext, new PdfDestinationPane.DestinationPanelFields[]{PdfDestinationPane.DestinationPanelFields.DISCARD_BOOKMARKS});
            panel.enableSameAsSourceItem();
            return panel;
        }

        @Provides
        @Named(value="split.simplefooter")
        public Footer footer(RunButton runButton, @Named(value="split.simpleopenButton") OpenButton openButton) {
            return new Footer(runButton, openButton, SplitModule.MODULE_ID);
        }

        @Provides
        @Named(value="split.simpleopenButton")
        public OpenButton openButton() {
            return new OpenButton(SplitModule.MODULE_ID, ModuleInputOutputType.MULTIPLE_PDF);
        }
    }
}

