/*
 * Decompiled with CFR 0.152.
 */
package javajs.img;

import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import javajs.img.ImageEncoder;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.T3;

public class GifEncoder
extends ImageEncoder {
    private Map<String, Object> params;
    private P3[] palette;
    private int backgroundColor;
    private boolean interlaced;
    private boolean addHeader = true;
    private boolean addImage = true;
    private boolean addTrailer = true;
    private boolean isTransparent;
    private boolean floydSteinberg = true;
    private boolean capturing;
    private boolean looping;
    private int delayTime100ths = -1;
    private int bitsPerPixel = 1;
    private int byteCount;
    private static M3 xyz2rgb;
    private static M3 rgb2xyz;
    private int initCodeSize;
    private int curpt;
    private static final int EOF = -1;
    private static final int[] INTERLACE_PARAMS;
    private static final int BITS = 12;
    private static final int HSIZE = 5003;
    private int nBits;
    private int maxbits = 12;
    private int maxcode;
    private int maxmaxcode = 4096;
    private int[] htab = new int[5003];
    private int[] codetab = new int[5003];
    private int hsize = 5003;
    private int freeEnt = 0;
    private boolean clearFlag = false;
    private int clearCode;
    private int EOFCode;
    private int countDown;
    private int pass = 0;
    private int curx;
    private int cury;
    private int curAccum = 0;
    private int curBits = 0;
    private int[] masks;
    private int bufPt;
    private final byte[] buf;

    static {
        rgb2xyz = M3.newA9(new float[]{0.4124f, 0.3576f, 0.1805f, 0.2126f, 0.7152f, 0.0722f, 0.0193f, 0.1192f, 0.9505f});
        xyz2rgb = M3.newA9(new float[]{3.2406f, -1.5372f, -0.4986f, -0.9689f, 1.8758f, 0.0415f, 0.0557f, -0.204f, 1.057f});
        int[] nArray = new int[8];
        nArray[0] = 8;
        nArray[1] = 8;
        nArray[2] = 4;
        nArray[3] = 2;
        nArray[4] = 4;
        nArray[5] = 2;
        nArray[6] = 1;
        INTERLACE_PARAMS = nArray;
    }

    public GifEncoder() {
        int[] nArray = new int[17];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 7;
        nArray[4] = 15;
        nArray[5] = 31;
        nArray[6] = 63;
        nArray[7] = 127;
        nArray[8] = 255;
        nArray[9] = 511;
        nArray[10] = 1023;
        nArray[11] = 2047;
        nArray[12] = 4095;
        nArray[13] = 8191;
        nArray[14] = 16383;
        nArray[15] = Short.MAX_VALUE;
        nArray[16] = 65535;
        this.masks = nArray;
        this.buf = new byte[256];
    }

    @Override
    protected void setParams(Map<String, Object> map) {
        this.params = map;
        Integer n = (Integer)map.get("transparentColor");
        if (n == null) {
            n = (Integer)map.get("backgroundColor");
            if (n != null) {
                this.backgroundColor = n;
            }
        } else {
            this.backgroundColor = n;
            this.isTransparent = true;
        }
        boolean bl = this.interlaced = Boolean.TRUE == map.get("interlaced");
        if (map.containsKey("captureRootExt") || !map.containsKey("captureMode")) {
            return;
        }
        this.interlaced = false;
        this.capturing = true;
        try {
            this.byteCount = (Integer)map.get("captureByteCount");
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch ("maec".indexOf(((String)map.get("captureMode")).substring(0, 1))) {
            case 0: {
                map.put("captureMode", "add");
                this.addImage = false;
                this.addTrailer = false;
                break;
            }
            case 1: {
                this.addHeader = false;
                this.addTrailer = false;
                Integer n2 = (Integer)map.get("captureDelayMS");
                if (n2 == null) {
                    int n3 = Math.abs((Integer)map.get("captureFps"));
                    this.delayTime100ths = n3 == 0 ? 0 : 100 / n3;
                } else {
                    this.delayTime100ths = n2 / 10;
                    map.remove("captureDelayMS");
                }
                this.looping = Boolean.FALSE != map.get("captureLooping");
                break;
            }
            case 2: {
                this.addHeader = false;
                this.addImage = false;
                break;
            }
            case 3: {
                this.addHeader = false;
                this.addImage = false;
                this.out.cancel();
            }
        }
    }

    @Override
    protected void generate() throws IOException {
        if (this.addHeader) {
            this.writeHeader();
        }
        this.addHeader = false;
        if (this.addImage) {
            this.createPalette();
            this.writeGraphicControlExtension();
            if (this.delayTime100ths >= 0 && this.looping) {
                this.writeNetscapeLoopExtension();
            }
            this.writeImage();
        }
    }

    @Override
    protected void close() {
        if (this.addTrailer) {
            this.writeTrailer();
        } else {
            this.doClose = false;
        }
        if (this.capturing) {
            this.params.put("captureByteCount", this.byteCount);
        }
    }

    private void createPalette() {
        Serializable serializable;
        Lst<ColorItem> lst = new Lst<ColorItem>();
        Hashtable<Integer, ColorItem> hashtable = new Hashtable<Integer, ColorItem>();
        int n = 0;
        int n2 = this.pixels.length;
        while (n < n2) {
            int n3 = this.pixels[n];
            Integer n4 = n3;
            serializable = (ColorItem)hashtable.get(n4);
            if (serializable == null) {
                serializable = new ColorItem(n3, n3 == this.backgroundColor);
                hashtable.put(n4, (ColorItem)serializable);
                lst.addLast((ColorItem)serializable);
            }
            ++n;
        }
        n = lst.size();
        System.out.println("GIF total image colors: " + n);
        hashtable = null;
        Lst<ColorCell> lst2 = this.quantizeColors(lst);
        n = lst2.size();
        System.out.println("GIF final color count: " + n);
        Hashtable<Integer, ColorCell> hashtable2 = new Hashtable<Integer, ColorCell>();
        this.bitsPerPixel = n <= 2 ? 1 : (n <= 4 ? 2 : (n <= 16 ? 4 : 8));
        this.palette = new P3[1 << this.bitsPerPixel];
        int n5 = 0;
        while (n5 < n) {
            serializable = (ColorCell)lst2.get(n5);
            this.palette[n5] = ((ColorCell)serializable).setColor();
            hashtable2.put(CU.colorPtToFFRGB(this.palette[n5]), (ColorCell)serializable);
            ++n5;
        }
        this.pixels = this.indexPixels(lst2, hashtable2);
    }

    private Lst<ColorCell> quantizeColors(Lst<ColorItem> lst) {
        Serializable serializable;
        int n = lst.size();
        Lst<ColorCell> lst2 = new Lst<ColorCell>();
        ColorCell colorCell = new ColorCell(0);
        colorCell.addLast(new ColorItem(this.backgroundColor, true));
        lst2.addLast(colorCell);
        colorCell = new ColorCell(1);
        if (n > 256) {
            lst2.addLast(colorCell);
        }
        int n2 = 0;
        while (n2 < n) {
            serializable = (ColorItem)lst.get(n2);
            if (!serializable.isBackground) {
                colorCell.addLast(serializable);
                if (n <= 256) {
                    lst2.addLast(colorCell);
                    colorCell = new ColorCell(lst2.size());
                }
            }
            ++n2;
        }
        lst.clear();
        if (n > 256) {
            while ((n = lst2.size()) < 256) {
                float f = 0.0f;
                serializable = null;
                int n3 = n;
                while (--n3 >= 1) {
                    ColorCell colorCell2 = (ColorCell)lst2.get(n3);
                    float f2 = colorCell2.getVolume(false);
                    if (!(f2 > f)) continue;
                    f = f2;
                    serializable = colorCell2;
                }
                if (serializable == null || !((ColorCell)serializable).splitCell(lst2)) break;
            }
        }
        return lst2;
    }

    private int[] indexPixels(Lst<ColorCell> lst, Map<Integer, ColorCell> map) {
        int n = this.width + 2;
        P3[] p3Array = new P3[n];
        int[] nArray = new int[this.pixels.length];
        P3 p3 = new P3();
        Hashtable<Integer, ColorCell> hashtable = new Hashtable<Integer, ColorCell>();
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.height) {
            boolean bl = n2 != this.height - 1;
            int n4 = 0;
            while (n4 < this.width) {
                if (this.pixels[n3] != this.backgroundColor) {
                    int n5;
                    P3 p32;
                    P3 p33 = p3Array[n3 % n];
                    if (p33 == null || p33.x == Float.MAX_VALUE) {
                        p32 = null;
                        n5 = this.pixels[n3];
                    } else {
                        p32 = this.toLABnorm(this.pixels[n3]);
                        p3 = p33;
                        p3.x = this.clamp(p3.x, -75.0f, 75.0f);
                        p3.y = this.clamp(p3.y, -75.0f, 75.0f);
                        p3.z = this.clamp(p3.z, -75.0f, 75.0f);
                        p32.add(p3);
                        n5 = CU.colorPtToFFRGB(this.toRGB(p32));
                    }
                    Integer n6 = n5;
                    ColorCell colorCell = map.get(n6);
                    if (colorCell == null) {
                        p32 = this.toLABnorm(n5);
                        colorCell = (ColorCell)hashtable.get(n6);
                        if (colorCell == null) {
                            float f = Float.MAX_VALUE;
                            int n7 = lst.size();
                            while (--n7 >= 1) {
                                ColorCell colorCell2 = (ColorCell)lst.get(n7);
                                p3.sub2(p32, colorCell2.center);
                                float f2 = p3.lengthSquared();
                                if (!(f2 < f)) continue;
                                f = f2;
                                colorCell = colorCell2;
                            }
                            hashtable.put(n6, colorCell);
                        }
                        if (this.floydSteinberg) {
                            boolean bl2;
                            p3.sub2(p32, colorCell.center);
                            boolean bl3 = bl2 = n4 < this.width - 1;
                            if (bl2) {
                                this.addError(p3, 7, p3Array, n3 + 1, n);
                            }
                            if (bl) {
                                if (n4 > 0) {
                                    this.addError(p3, 3, p3Array, n3 + this.width - 1, n);
                                }
                                this.addError(p3, 5, p3Array, n3 + this.width, n);
                                if (bl2) {
                                    this.addError(p3, 1, p3Array, n3 + this.width + 1, n);
                                }
                            }
                        }
                        p3.x = Float.MAX_VALUE;
                    }
                    nArray[n3] = colorCell.index;
                }
                ++n4;
                ++n3;
            }
            ++n2;
        }
        return nArray;
    }

    private void addError(P3 p3, int n, P3[] p3Array, int n2, int n3) {
        if (this.pixels[n2] == this.backgroundColor) {
            return;
        }
        P3 p32 = p3Array[n2 %= n3];
        if (p32 == null) {
            p32 = p3Array[n2] = new P3();
        } else if (p32.x == Float.MAX_VALUE) {
            p32.set(0.0f, 0.0f, 0.0f);
        }
        p32.scaleAdd2((float)n / 16.0f, p3, p32);
    }

    protected P3 toLABnorm(int n) {
        P3 p3 = CU.colorPtFromInt(n, null);
        this.rgbToXyz(p3, p3);
        this.xyzToLab(p3, p3);
        p3.y = (p3.y + 86.185f) / 184.439f * 100.0f;
        p3.z = (p3.z + 107.863f) / 202.345f * 100.0f;
        return p3;
    }

    protected P3 toRGB(P3 p3) {
        P3 p32 = P3.newP(p3);
        p32.y = p32.y / 100.0f * 184.439f - 86.185f;
        p32.z = p32.z / 100.0f * 202.345f - 107.863f;
        this.labToXyz(p32, p32);
        return this.xyzToRgb(p32, p32);
    }

    public P3 rgbToXyz(P3 p3, P3 p32) {
        if (p32 == null) {
            p32 = new P3();
        }
        p32.x = this.sxyz(p3.x);
        p32.y = this.sxyz(p3.y);
        p32.z = this.sxyz(p3.z);
        rgb2xyz.rotate(p32);
        return p32;
    }

    private float sxyz(float f) {
        return (float)((double)(f /= 255.0f) <= 0.04045 ? (double)f / 12.92 : Math.pow(((double)f + 0.055) / 1.055, 2.4)) * 100.0f;
    }

    public P3 xyzToRgb(P3 p3, P3 p32) {
        if (p32 == null) {
            p32 = new P3();
        }
        p32.setT(p3);
        p32.scale(0.01f);
        xyz2rgb.rotate(p32);
        p32.x = this.clamp(this.srgb(p32.x), 0.0f, 255.0f);
        p32.y = this.clamp(this.srgb(p32.y), 0.0f, 255.0f);
        p32.z = this.clamp(this.srgb(p32.z), 0.0f, 255.0f);
        return p32;
    }

    private float srgb(float f) {
        return (float)(f > 0.0031308f ? 1.055 * Math.pow(f, 0.4166666666666667) - 0.055 : (double)f * 12.92) * 255.0f;
    }

    public P3 xyzToLab(P3 p3, P3 p32) {
        if (p32 == null) {
            p32 = new P3();
        }
        float f = this.flab(p3.x / 95.0429f);
        float f2 = this.flab(p3.y / 100.0f);
        float f3 = this.flab(p3.z / 108.89f);
        p32.x = 116.0f * f2 - 16.0f;
        p32.y = 500.0f * (f - f2);
        p32.z = 200.0f * (f2 - f3);
        return p32;
    }

    private float flab(float f) {
        return (float)((double)f > 0.00885645168 ? Math.pow(f, 0.333333333) : 7.78703704 * (double)f + 0.137931034);
    }

    public P3 labToXyz(P3 p3, P3 p32) {
        if (p32 == null) {
            p32 = new P3();
        }
        p32.setT(p3);
        float f = (p32.x + 16.0f) / 116.0f;
        float f2 = p32.y / 500.0f + f;
        float f3 = f - p32.z / 200.0f;
        p32.x = this.fxyz(f2) * 95.0429f;
        p32.y = this.fxyz(f) * 100.0f;
        p32.z = this.fxyz(f3) * 108.89f;
        return p32;
    }

    private float fxyz(float f) {
        return (float)((double)f > 0.206896552 ? (double)(f * f * f) : 0.128418549 * ((double)f - 0.137931034));
    }

    private float clamp(float f, float f2, float f3) {
        f = f < f2 ? f2 : (f > f3 ? f3 : f);
        return f2 == 0.0f ? (float)Math.round(f) : f;
    }

    private void writeHeader() throws IOException {
        this.putString("GIF89a");
        this.putWord(this.width);
        this.putWord(this.height);
        this.putByte(0);
        this.putByte(0);
        this.putByte(0);
    }

    private void writeGraphicControlExtension() {
        if (this.isTransparent || this.delayTime100ths >= 0) {
            this.putByte(33);
            this.putByte(249);
            this.putByte(4);
            this.putByte((this.isTransparent ? 9 : 0) | (this.delayTime100ths > 0 ? 2 : 0));
            this.putWord(this.delayTime100ths > 0 ? this.delayTime100ths : 0);
            this.putByte(0);
            this.putByte(0);
        }
    }

    private void writeNetscapeLoopExtension() {
        this.putByte(33);
        this.putByte(255);
        this.putByte(11);
        this.putString("NETSCAPE2.0");
        this.putByte(3);
        this.putByte(1);
        this.putWord(0);
        this.putByte(0);
    }

    private void writeImage() {
        this.putByte(44);
        this.putWord(0);
        this.putWord(0);
        this.putWord(this.width);
        this.putWord(this.height);
        int n = 0x80 | (this.interlaced ? 64 : 0) | this.bitsPerPixel - 1;
        this.putByte(n);
        int n2 = 1 << this.bitsPerPixel;
        P3 p3 = new P3();
        int n3 = 0;
        while (n3 < n2) {
            if (this.palette[n3] != null) {
                p3 = this.palette[n3];
            }
            this.putByte((int)p3.x);
            this.putByte((int)p3.y);
            this.putByte((int)p3.z);
            ++n3;
        }
        this.initCodeSize = this.bitsPerPixel <= 1 ? 2 : this.bitsPerPixel;
        this.putByte(this.initCodeSize);
        this.compress();
        this.putByte(0);
    }

    private void writeTrailer() {
        this.putByte(59);
    }

    private int nextPixel() {
        if (this.countDown-- == 0) {
            return -1;
        }
        int n = this.pixels[this.curpt];
        ++this.curx;
        if (this.curx == this.width) {
            this.curx = 0;
            if (this.interlaced) {
                this.updateY(INTERLACE_PARAMS[this.pass], INTERLACE_PARAMS[this.pass + 4]);
            } else {
                ++this.cury;
            }
        }
        this.curpt = this.cury * this.width + this.curx;
        return n & 0xFF;
    }

    private void updateY(int n, int n2) {
        this.cury += n;
        if (n2 >= 0 && this.cury >= this.height) {
            this.cury = n2;
            ++this.pass;
        }
    }

    private void putWord(int n) {
        this.putByte(n);
        this.putByte(n >> 8);
    }

    private static final int MAXCODE(int n) {
        return (1 << n) - 1;
    }

    private void compress() {
        int n;
        this.countDown = this.width * this.height;
        this.pass = 0;
        this.curx = 0;
        this.cury = 0;
        this.clearFlag = false;
        this.nBits = this.initCodeSize + 1;
        this.maxcode = GifEncoder.MAXCODE(this.nBits);
        this.clearCode = 1 << this.initCodeSize;
        this.EOFCode = this.clearCode + 1;
        this.freeEnt = this.clearCode + 2;
        this.bufPt = 0;
        int n2 = this.nextPixel();
        int n3 = 0;
        int n4 = this.hsize;
        while (n4 < 65536) {
            ++n3;
            n4 *= 2;
        }
        n3 = 8 - n3;
        int n5 = this.hsize;
        this.clearHash(n5);
        this.output(this.clearCode);
        block1: while ((n = this.nextPixel()) != -1) {
            int n6 = n << n3 ^ n2;
            n4 = (n << this.maxbits) + n2;
            if (this.htab[n6] == n4) {
                n2 = this.codetab[n6];
                continue;
            }
            if (this.htab[n6] >= 0) {
                int n7 = n5 - n6;
                if (n6 == 0) {
                    n7 = 1;
                }
                do {
                    if ((n6 -= n7) < 0) {
                        n6 += n5;
                    }
                    if (this.htab[n6] != n4) continue;
                    n2 = this.codetab[n6];
                    continue block1;
                } while (this.htab[n6] >= 0);
            }
            this.output(n2);
            n2 = n;
            if (this.freeEnt < this.maxmaxcode) {
                ++this.freeEnt;
                this.htab[n6] = n4;
                continue;
            }
            this.clearBlock();
        }
        this.output(n2);
        this.output(this.EOFCode);
    }

    private void output(int n) {
        this.curAccum &= this.masks[this.curBits];
        this.curAccum = this.curBits > 0 ? (this.curAccum |= n << this.curBits) : n;
        this.curBits += this.nBits;
        while (this.curBits >= 8) {
            this.byteOut((byte)(this.curAccum & 0xFF));
            this.curAccum >>= 8;
            this.curBits -= 8;
        }
        if (this.freeEnt > this.maxcode || this.clearFlag) {
            if (this.clearFlag) {
                this.nBits = this.initCodeSize + 1;
                this.maxcode = GifEncoder.MAXCODE(this.nBits);
                this.clearFlag = false;
            } else {
                ++this.nBits;
                this.maxcode = this.nBits == this.maxbits ? this.maxmaxcode : GifEncoder.MAXCODE(this.nBits);
            }
        }
        if (n == this.EOFCode) {
            while (this.curBits > 0) {
                this.byteOut((byte)(this.curAccum & 0xFF));
                this.curAccum >>= 8;
                this.curBits -= 8;
            }
            this.flushBytes();
        }
    }

    private void clearBlock() {
        this.clearHash(this.hsize);
        this.freeEnt = this.clearCode + 2;
        this.clearFlag = true;
        this.output(this.clearCode);
    }

    private void clearHash(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.htab[n2] = -1;
            ++n2;
        }
    }

    private void byteOut(byte by) {
        this.buf[this.bufPt++] = by;
        if (this.bufPt >= 254) {
            this.flushBytes();
        }
    }

    protected void flushBytes() {
        if (this.bufPt > 0) {
            this.putByte(this.bufPt);
            this.out.write(this.buf, 0, this.bufPt);
            this.byteCount += this.bufPt;
            this.bufPt = 0;
        }
    }

    private class ColorCell
    extends Lst<P3> {
        protected int index;
        protected P3 center;
        private float volume;

        ColorCell(int n) {
            this.index = n;
        }

        public float getVolume(boolean bl) {
            int n;
            if (this.volume != 0.0f) {
                return this.volume;
            }
            if (this.size() < 2) {
                return -1.0f;
            }
            float f = -2.1474836E9f;
            float f2 = 2.1474836E9f;
            float f3 = -2.1474836E9f;
            float f4 = 2.1474836E9f;
            float f5 = -2.1474836E9f;
            float f6 = 2.1474836E9f;
            int n2 = n = this.size();
            while (--n2 >= 0) {
                P3 p3 = (P3)this.get(n2);
                if (p3.x < f2) {
                    f2 = p3.x;
                }
                if (p3.y < f4) {
                    f4 = p3.y;
                }
                if (p3.z < f6) {
                    f6 = p3.z;
                }
                if (p3.x > f) {
                    f = p3.x;
                }
                if (p3.y > f3) {
                    f3 = p3.y;
                }
                if (!(p3.z > f5)) continue;
                f5 = p3.z;
            }
            float f7 = f - f2;
            float f8 = f3 - f4;
            float f9 = f5 - f6;
            this.volume = f7 * f7 + f8 * f8 + f9 * f9;
            return this.volume;
        }

        protected P3 setColor() {
            int n = this.size();
            this.center = new P3();
            int n2 = n;
            while (--n2 >= 0) {
                this.center.add((T3)this.get(n2));
            }
            this.center.scale(1.0f / (float)n);
            return GifEncoder.this.toRGB(this.center);
        }

        protected boolean splitCell(Lst<ColorCell> lst) {
            int n;
            float f;
            int n2 = this.size();
            if (n2 < 2) {
                return false;
            }
            int n3 = lst.size();
            ColorCell colorCell = new ColorCell(n3);
            lst.addLast(colorCell);
            float[][] fArray = new float[3][3];
            int n4 = 0;
            while (n4 < 3) {
                float f2 = Float.MAX_VALUE;
                f = -3.4028235E38f;
                n = n2;
                while (--n >= 0) {
                    float f3;
                    P3 p3 = (P3)this.get(n);
                    float f4 = n4 == 0 ? p3.x : (f3 = n4 == 1 ? p3.y : p3.z);
                    if (f2 > f3) {
                        f2 = f3;
                    }
                    if (!(f < f3)) continue;
                    f = f3;
                }
                fArray[0][n4] = f2;
                fArray[1][n4] = f;
                fArray[2][n4] = f - f2;
                ++n4;
            }
            float[] fArray2 = fArray[2];
            int n5 = fArray2[0] >= fArray2[1] ? (fArray2[0] >= fArray2[2] ? 0 : 2) : (fArray2[1] >= fArray2[2] ? 1 : 2);
            f = fArray[0][n5] + fArray[2][n5] / 2.0f;
            this.volume = 0.0f;
            switch (n5) {
                case 0: {
                    n = n2;
                    while (--n >= 0) {
                        if (!(((P3)this.get((int)n)).x >= f)) continue;
                        colorCell.addLast((P3)this.removeItemAt(n));
                    }
                    break;
                }
                case 1: {
                    n = n2;
                    while (--n >= 0) {
                        if (!(((P3)this.get((int)n)).y >= f)) continue;
                        colorCell.addLast((P3)this.removeItemAt(n));
                    }
                    break;
                }
                case 2: {
                    n = this.size();
                    while (--n >= 0) {
                        if (!(((P3)this.get((int)n)).z >= f)) continue;
                        colorCell.addLast((P3)this.removeItemAt(n));
                    }
                    break;
                }
            }
            return true;
        }
    }

    private class ColorItem
    extends P3 {
        protected boolean isBackground;

        ColorItem(int n, boolean bl) {
            this.isBackground = bl;
            this.setT(GifEncoder.this.toLABnorm(n));
        }
    }
}

