/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions;

import com.android.dx.io.instructions.FillArrayDataPayloadDecodedInstruction;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.PrimitiveType;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class FillArrayNode
extends InsnNode {
    private static final ArgType ONE_BYTE_TYPE = ArgType.unknown(PrimitiveType.BOOLEAN, PrimitiveType.BYTE);
    private static final ArgType TWO_BYTES_TYPE = ArgType.unknown(PrimitiveType.SHORT, PrimitiveType.CHAR);
    private static final ArgType FOUR_BYTES_TYPE = ArgType.unknown(PrimitiveType.INT, PrimitiveType.FLOAT);
    private static final ArgType EIGHT_BYTES_TYPE = ArgType.unknown(PrimitiveType.LONG, PrimitiveType.DOUBLE);
    private final Object data;
    private final int size;
    private ArgType elemType;

    public FillArrayNode(int resReg, FillArrayDataPayloadDecodedInstruction payload) {
        super(InsnType.FILL_ARRAY, 1);
        ArgType elType = FillArrayNode.getElementType(payload.getElementWidthUnit());
        this.addArg(InsnArg.reg(resReg, ArgType.array(elType)));
        this.data = payload.getData();
        this.size = payload.getSize();
        this.elemType = elType;
    }

    private static ArgType getElementType(short elementWidthUnit) {
        switch (elementWidthUnit) {
            case 1: {
                return ONE_BYTE_TYPE;
            }
            case 2: {
                return TWO_BYTES_TYPE;
            }
            case 4: {
                return FOUR_BYTES_TYPE;
            }
            case 8: {
                return EIGHT_BYTES_TYPE;
            }
        }
        throw new JadxRuntimeException("Unknown array element width: " + elementWidthUnit);
    }

    public Object getData() {
        return this.data;
    }

    public int getSize() {
        return this.size;
    }

    public ArgType getElementType() {
        return this.elemType;
    }

    public List<LiteralArg> getLiteralArgs(ArgType type) {
        ArrayList<LiteralArg> list = new ArrayList<LiteralArg>(this.size);
        Object array = this.data;
        if (array instanceof int[]) {
            for (int b : (int[])array) {
                list.add(InsnArg.lit(b, type));
            }
        } else if (array instanceof byte[]) {
            for (byte b : (byte[])array) {
                list.add(InsnArg.lit(b, type));
            }
        } else if (array instanceof short[]) {
            for (short b : (short[])array) {
                list.add(InsnArg.lit(b, type));
            }
        } else if (array instanceof long[]) {
            for (long b : (long[])array) {
                list.add(InsnArg.lit(b, type));
            }
        } else {
            throw new JadxRuntimeException("Unknown type: " + this.data.getClass() + ", expected: " + type);
        }
        return list;
    }

    @Override
    public boolean isSame(InsnNode obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FillArrayNode) || !super.isSame(obj)) {
            return false;
        }
        FillArrayNode other = (FillArrayNode)obj;
        return this.elemType.equals(other.elemType) && this.data == other.data;
    }

    public String dataToString() {
        if (this.data instanceof int[]) {
            return Arrays.toString((int[])this.data);
        }
        if (this.data instanceof short[]) {
            return Arrays.toString((short[])this.data);
        }
        if (this.data instanceof byte[]) {
            return Arrays.toString((byte[])this.data);
        }
        if (this.data instanceof long[]) {
            return Arrays.toString((long[])this.data);
        }
        return "?";
    }

    @Override
    public String toString() {
        return super.toString() + ", data: " + this.dataToString();
    }
}

