/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class ResourceUtils {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String ALL_CLASSPATH_URL_PREFIX = "classpath*:";
    public static final String FILE_URL_PREFIX = "file:";

    public static List<String> getUrls(String path, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = ClassUtils.getDefaultClassLoader();
        }
        path = StringUtils.cleanPath((String)path);
        try {
            return ResourceUtils.getUrlsFromWildcardPath(path, classLoader);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot create URL from path [" + path + "]", ex);
        }
    }

    private static List<String> getUrlsFromWildcardPath(String path, ClassLoader classLoader) throws IOException {
        if (path.contains(":")) {
            return ResourceUtils.getUrlsFromPrefixedWildcardPath(path, classLoader);
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        try {
            result.addAll(ResourceUtils.getUrls(FILE_URL_PREFIX + path, classLoader));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        path = ResourceUtils.stripLeadingSlashes(path);
        result.addAll(ResourceUtils.getUrls(ALL_CLASSPATH_URL_PREFIX + path, classLoader));
        return new ArrayList<String>(result);
    }

    private static List<String> getUrlsFromPrefixedWildcardPath(String path, ClassLoader classLoader) throws IOException {
        Resource[] resources = new PathMatchingResourcePatternResolver((ResourceLoader)new FileSearchResourceLoader(classLoader)).getResources(path);
        ArrayList<String> result = new ArrayList<String>();
        for (Resource resource : resources) {
            if (!resource.exists()) continue;
            if (resource.getURI().getScheme().equals("file") && resource.getFile().isDirectory()) {
                result.addAll(ResourceUtils.getChildFiles(resource));
                continue;
            }
            result.add(ResourceUtils.absolutePath(resource));
        }
        return result;
    }

    private static List<String> getChildFiles(Resource resource) throws IOException {
        Resource[] children = new PathMatchingResourcePatternResolver().getResources(resource.getURL() + "/**");
        ArrayList<String> childFiles = new ArrayList<String>();
        for (Resource child : children) {
            if (child.getFile().isDirectory()) continue;
            childFiles.add(ResourceUtils.absolutePath(child));
        }
        return childFiles;
    }

    private static String absolutePath(Resource resource) throws IOException {
        if (!resource.getURI().getScheme().equals("file")) {
            return resource.getURL().toExternalForm();
        }
        return resource.getFile().getAbsoluteFile().toURI().toString();
    }

    private static String stripLeadingSlashes(String path) {
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    private static class FileSearchResourceLoader
    extends DefaultResourceLoader {
        private final FileSystemResourceLoader files = new FileSystemResourceLoader();

        FileSearchResourceLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        public Resource getResource(String location) {
            Assert.notNull((Object)location, (String)"Location must not be null");
            if (location.startsWith(ResourceUtils.CLASSPATH_URL_PREFIX)) {
                return new ClassPathResource(location.substring(ResourceUtils.CLASSPATH_URL_PREFIX.length()), this.getClassLoader());
            }
            if (location.startsWith(ResourceUtils.FILE_URL_PREFIX)) {
                Resource resource = this.files.getResource(location);
                return resource;
            }
            try {
                URL url = new URL(location);
                return new UrlResource(url);
            }
            catch (MalformedURLException ex) {
                return this.getResourceByPath(location);
            }
        }
    }
}

