/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.SystemInfo;

public class MutableSystemInfo
implements SystemInfo {
    public String osName;
    public String osVersion;
    public String machineArchitecture;

    public String getKernelName() {
        return this.osName;
    }

    public String getKernelVersion() {
        return this.osVersion;
    }

    public String getArchitectureName() {
        return this.machineArchitecture;
    }

    public SystemInfo.Architecture getArchitecture() {
        if (this.machineArchitecture.equals("amd64") || this.machineArchitecture.equals("x86_64")) {
            return SystemInfo.Architecture.amd64;
        }
        if (this.machineArchitecture.equals("i386") || this.machineArchitecture.equals("x86") || this.machineArchitecture.equals("i686")) {
            return SystemInfo.Architecture.i386;
        }
        throw new NativeException(String.format("Cannot determine architecture from kernel architecture name '%s'.", this.machineArchitecture));
    }

    void windows(int major, int minor, int build, boolean workstation, String arch) {
        this.osName = this.toWindowsVersionName(major, minor, workstation);
        this.osVersion = String.format("%s.%s (build %s)", major, minor, build);
        this.machineArchitecture = arch;
    }

    private String toWindowsVersionName(int major, int minor, boolean workstation) {
        switch (major) {
            case 5: {
                switch (minor) {
                    case 0: {
                        return "Windows 2000";
                    }
                    case 1: {
                        return "Windows XP";
                    }
                    case 2: {
                        return workstation ? "Windows XP Professional" : "Windows Server 2003";
                    }
                }
                break;
            }
            case 6: {
                switch (minor) {
                    case 0: {
                        return workstation ? "Windows Vista" : "Windows Server 2008";
                    }
                    case 1: {
                        return workstation ? "Windows 7" : "Windows Server 2008 R2";
                    }
                    case 2: {
                        return workstation ? "Windows 8" : "Windows Server 2012";
                    }
                    case 3: {
                        return workstation ? "Windows 8.1" : "Windows Server 2012 R2";
                    }
                }
                break;
            }
            case 10: {
                if (minor != 0) break;
                return workstation ? "Windows 10" : "Windows Server 2016";
            }
        }
        return "Windows (unknown version)";
    }
}

