/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.exporter.plugin;

import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.io.exporter.api.FileType;
import org.gephi.io.exporter.spi.CharacterExporter;
import org.gephi.io.exporter.spi.GraphExporter;
import org.gephi.project.api.Workspace;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ExporterGraphML
implements GraphExporter,
CharacterExporter,
LongTask {
    private boolean cancel = false;
    private ProgressTicket progressTicket;
    private Workspace workspace;
    private Writer writer;
    private boolean exportVisible;
    private boolean normalize = false;
    private boolean exportColors = true;
    private boolean exportPosition = true;
    private boolean exportSize = true;
    private boolean exportDynamicWeight = true;
    private boolean exportAttributes = true;
    private float minSize;
    private float maxSize;
    private float minX;
    private float maxX;
    private float minY;
    private float maxY;
    private float minZ;
    private float maxZ;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        GraphModel graphModel = graphController.getGraphModel(this.workspace);
        Graph graph = this.exportVisible ? graphModel.getGraphVisible() : graphModel.getGraph();
        graph.readLock();
        try {
            this.exportData(this.createDocument(), graph);
        }
        catch (Exception e) {
            Logger.getLogger(ExporterGraphML.class.getName()).log(Level.SEVERE, null, e);
        }
        finally {
            graph.readUnlock();
            Progress.finish((ProgressTicket)this.progressTicket);
        }
        return !this.cancel;
    }

    private Document createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        document.setXmlVersion("1.0");
        document.setXmlStandalone(true);
        return document;
    }

    private void transform(Document document) throws TransformerConfigurationException, TransformerException {
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(this.writer);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(source, result);
    }

    private void exportData(Document document, Graph graph) throws Exception {
        Progress.start((ProgressTicket)this.progressTicket);
        this.calculateMinMax(graph);
        int max = graph.getNodeCount() + graph.getEdgeCount();
        Progress.switchToDeterminate((ProgressTicket)this.progressTicket, (int)max);
        Element root = document.createElementNS("http://graphml.graphdrawing.org/xmlns", "graphml");
        document.appendChild(root);
        this.createKeys(document, root, graph.getModel());
        Element graphE = this.createGraph(document, graph);
        root.appendChild(graphE);
        if (!this.cancel) {
            this.transform(document);
        }
        Progress.finish((ProgressTicket)this.progressTicket);
    }

    private void createKeys(Document document, Element root, GraphModel graphModel) {
        Element nodeLabelKeyE = document.createElement("key");
        nodeLabelKeyE.setAttribute("id", "label");
        nodeLabelKeyE.setAttribute("attr.name", "label");
        nodeLabelKeyE.setAttribute("attr.type", "string");
        nodeLabelKeyE.setAttribute("for", "node");
        root.appendChild(nodeLabelKeyE);
        Element edgeLabelKeyE = document.createElement("key");
        edgeLabelKeyE.setAttribute("id", "edgelabel");
        edgeLabelKeyE.setAttribute("attr.name", "Edge Label");
        edgeLabelKeyE.setAttribute("attr.type", "string");
        edgeLabelKeyE.setAttribute("for", "edge");
        root.appendChild(edgeLabelKeyE);
        Element weightKeyE = document.createElement("key");
        weightKeyE.setAttribute("id", "weight");
        weightKeyE.setAttribute("attr.name", "weight");
        weightKeyE.setAttribute("attr.type", "double");
        weightKeyE.setAttribute("for", "edge");
        root.appendChild(weightKeyE);
        if (this.exportColors) {
            Element colorRKeyE = document.createElement("key");
            colorRKeyE.setAttribute("id", "r");
            colorRKeyE.setAttribute("attr.name", "r");
            colorRKeyE.setAttribute("attr.type", "int");
            colorRKeyE.setAttribute("for", "node");
            root.appendChild(colorRKeyE);
            Element colorGKeyE = document.createElement("key");
            colorGKeyE.setAttribute("id", "g");
            colorGKeyE.setAttribute("attr.name", "g");
            colorGKeyE.setAttribute("attr.type", "int");
            colorGKeyE.setAttribute("for", "node");
            root.appendChild(colorGKeyE);
            Element colorBKeyE = document.createElement("key");
            colorBKeyE.setAttribute("id", "b");
            colorBKeyE.setAttribute("attr.name", "b");
            colorBKeyE.setAttribute("attr.type", "int");
            colorBKeyE.setAttribute("for", "node");
            root.appendChild(colorBKeyE);
        }
        if (this.exportPosition) {
            Element positionKeyE = document.createElement("key");
            positionKeyE.setAttribute("id", "x");
            positionKeyE.setAttribute("attr.name", "x");
            positionKeyE.setAttribute("attr.type", "float");
            positionKeyE.setAttribute("for", "node");
            root.appendChild(positionKeyE);
            Element positionKey2E = document.createElement("key");
            positionKey2E.setAttribute("id", "y");
            positionKey2E.setAttribute("attr.name", "y");
            positionKey2E.setAttribute("attr.type", "float");
            positionKey2E.setAttribute("for", "node");
            root.appendChild(positionKey2E);
            if (this.minZ != 0.0f || this.maxZ != 0.0f) {
                Element positionKey3E = document.createElement("key");
                positionKey3E.setAttribute("id", "z");
                positionKey3E.setAttribute("attr.name", "z");
                positionKey3E.setAttribute("attr.type", "float");
                positionKey3E.setAttribute("for", "node");
                root.appendChild(positionKey3E);
            }
        }
        if (this.exportSize) {
            Element sizeKeyE = document.createElement("key");
            sizeKeyE.setAttribute("id", "size");
            sizeKeyE.setAttribute("attr.name", "size");
            sizeKeyE.setAttribute("attr.type", "float");
            sizeKeyE.setAttribute("for", "node");
            root.appendChild(sizeKeyE);
        }
        if (graphModel != null && this.exportAttributes) {
            Element attributeE;
            for (Column column : graphModel.getNodeTable()) {
                if (column.isProperty()) continue;
                attributeE = this.createAttribute(document, column);
                attributeE.setAttribute("for", "node");
                root.appendChild(attributeE);
            }
            for (Column column : graphModel.getEdgeTable()) {
                if (column.isProperty()) continue;
                attributeE = this.createAttribute(document, column);
                attributeE.setAttribute("for", "edge");
                root.appendChild(attributeE);
            }
        }
    }

    private Element createGraph(Document document, Graph graph) throws Exception {
        Element graphE = document.createElement("graph");
        if (graph.isDirected() || graph.isMixed()) {
            graphE.setAttribute("edgedefault", "directed");
        } else {
            graphE.setAttribute("edgedefault", "undirected");
        }
        this.createNodes(document, graphE, graph);
        this.createEdges(document, graphE, graph);
        return graphE;
    }

    private Element createAttribute(Document document, Column column) {
        Element attributeE = document.createElement("key");
        attributeE.setAttribute("id", column.getId());
        attributeE.setAttribute("attr.name", column.getTitle());
        if (column.getTypeClass().equals(Integer.class) || column.getTypeClass().equals(Short.class) || column.getTypeClass().equals(Byte.class)) {
            attributeE.setAttribute("attr.type", "int");
        } else {
            attributeE.setAttribute("attr.type", AttributeUtils.getTypeName((Class)column.getTypeClass()));
        }
        if (column.getDefaultValue() != null) {
            Element defaultE = document.createElement("default");
            Text defaultTextE = document.createTextNode(column.getDefaultValue().toString());
            defaultE.appendChild(defaultTextE);
        }
        return attributeE;
    }

    private Element createNodeAttvalue(Document document, Column column, Graph graph, Node n) throws Exception {
        Object val = n.getAttribute(column, graph.getView());
        if (val != null) {
            String value = val.toString();
            String id = column.getId();
            Element attvalueE = document.createElement("data");
            attvalueE.setAttribute("key", id);
            attvalueE.setTextContent(value);
            return attvalueE;
        }
        return null;
    }

    private Element createEdgeAttvalue(Document document, Column column, Graph graph, Edge e) throws Exception {
        Object val = e.getAttribute(column, graph.getView());
        if (val != null) {
            String value = val.toString();
            String id = column.getId();
            Element attvalueE = document.createElement("data");
            attvalueE.setAttribute("key", id);
            attvalueE.setTextContent(value);
            return attvalueE;
        }
        return null;
    }

    private void createNodes(Document document, Element parentE, Graph graph) throws Exception {
        NodeIterable nodeIterable = graph.getNodes();
        for (Node n : nodeIterable) {
            if (this.cancel) {
                nodeIterable.doBreak();
                break;
            }
            Element nodeE = this.createNode(document, graph, n);
            parentE.appendChild(nodeE);
        }
    }

    private Element createNode(Document document, Graph graph, Node n) throws Exception {
        Element nodeE = document.createElement("node");
        nodeE.setAttribute("id", n.getId().toString());
        if (n.getLabel() != null && !n.getLabel().isEmpty()) {
            Element labelE = this.createNodeLabel(document, n);
            nodeE.appendChild(labelE);
        }
        if (this.exportAttributes) {
            for (Column column : n.getAttributeColumns()) {
                Element attvalueE;
                if (column.isProperty() || (attvalueE = this.createNodeAttvalue(document, column, graph, n)) == null) continue;
                nodeE.appendChild(attvalueE);
            }
        }
        if (this.exportSize) {
            Element sizeE = this.createNodeSize(document, n);
            nodeE.appendChild(sizeE);
        }
        if (this.exportColors) {
            Element colorE = this.createNodeColorR(document, n);
            nodeE.appendChild(colorE);
            colorE = this.createNodeColorG(document, n);
            nodeE.appendChild(colorE);
            colorE = this.createNodeColorB(document, n);
            nodeE.appendChild(colorE);
        }
        if (this.exportPosition) {
            Element positionXE = this.createNodePositionX(document, n);
            nodeE.appendChild(positionXE);
            Element positionYE = this.createNodePositionY(document, n);
            nodeE.appendChild(positionYE);
            if (this.minZ != 0.0f || this.maxZ != 0.0f) {
                Element positionZE = this.createNodePositionZ(document, n);
                nodeE.appendChild(positionZE);
            }
        }
        Progress.progress((ProgressTicket)this.progressTicket);
        return nodeE;
    }

    private void createEdges(Document document, Element edgesE, Graph graph) throws Exception {
        EdgeIterable itr = graph.getEdges();
        for (Edge e : itr) {
            if (this.cancel) {
                itr.doBreak();
                break;
            }
            Element edgeE = this.createEdge(document, e, graph);
            edgesE.appendChild(edgeE);
        }
    }

    private Element createEdge(Document document, Edge e, Graph graph) throws Exception {
        Element edgeE = document.createElement("edge");
        edgeE.setAttribute("id", e.getId().toString());
        edgeE.setAttribute("source", e.getSource().getId().toString());
        edgeE.setAttribute("target", e.getTarget().getId().toString());
        if (e.getLabel() != null && !e.getLabel().isEmpty()) {
            Element labelE = this.createEdgeLabel(document, e);
            edgeE.appendChild(labelE);
        }
        Element weightE = this.createEdgeWeight(document, e, graph);
        edgeE.appendChild(weightE);
        if (e.isDirected() && !graph.isDirected()) {
            edgeE.setAttribute("type", "directed");
        } else if (!e.isDirected() && graph.isDirected()) {
            edgeE.setAttribute("type", "undirected");
        }
        if (this.exportAttributes) {
            for (Column column : e.getAttributeColumns()) {
                Element attvalueE;
                if (column.isProperty() || (attvalueE = this.createEdgeAttvalue(document, column, graph, e)) == null) continue;
                edgeE.appendChild(attvalueE);
            }
        }
        Progress.progress((ProgressTicket)this.progressTicket);
        return edgeE;
    }

    private Element createNodeSize(Document document, Node n) throws Exception {
        Element sizeE = document.createElement("data");
        float size = n.size();
        if (this.normalize) {
            size = (size - this.minSize) / (this.maxSize - this.minSize);
        }
        sizeE.setAttribute("key", "size");
        sizeE.setTextContent("" + size);
        return sizeE;
    }

    private Element createNodeColorR(Document document, Node n) throws Exception {
        int r = Math.round(n.r() * 255.0f);
        Element colorE = document.createElement("data");
        colorE.setAttribute("key", "r");
        colorE.setTextContent("" + r);
        return colorE;
    }

    private Element createNodeColorG(Document document, Node n) throws Exception {
        int g = Math.round(n.g() * 255.0f);
        Element colorE = document.createElement("data");
        colorE.setAttribute("key", "g");
        colorE.setTextContent("" + g);
        return colorE;
    }

    private Element createNodeColorB(Document document, Node n) throws Exception {
        int b = Math.round(n.b() * 255.0f);
        Element colorE = document.createElement("data");
        colorE.setAttribute("key", "b");
        colorE.setTextContent("" + b);
        return colorE;
    }

    private Element createNodePositionX(Document document, Node n) throws Exception {
        Element positionXE = document.createElement("data");
        float x = n.x();
        if (this.normalize && (double)x != 0.0) {
            x = (x - this.minX) / (this.maxX - this.minX);
        }
        positionXE.setAttribute("key", "x");
        positionXE.setTextContent("" + x);
        return positionXE;
    }

    private Element createNodePositionY(Document document, Node n) throws Exception {
        Element positionYE = document.createElement("data");
        float y = n.y();
        if (this.normalize && (double)y != 0.0) {
            y = (y - this.minY) / (this.maxY - this.minY);
        }
        positionYE.setAttribute("key", "y");
        positionYE.setTextContent("" + y);
        return positionYE;
    }

    private Element createNodePositionZ(Document document, Node n) throws Exception {
        Element positionZE = document.createElement("data");
        float z = n.z();
        if (this.normalize && (double)z != 0.0) {
            z = (z - this.minZ) / (this.maxZ - this.minZ);
        }
        positionZE.setAttribute("key", "z");
        positionZE.setTextContent("" + z);
        return positionZE;
    }

    private Element createNodeLabel(Document document, Node n) throws Exception {
        Element labelE = document.createElement("data");
        labelE.setAttribute("key", "label");
        labelE.setTextContent(n.getLabel());
        return labelE;
    }

    private Element createEdgeWeight(Document document, Edge e, Graph graph) throws Exception {
        Element weightE = document.createElement("data");
        weightE.setAttribute("key", "weight");
        Double weight = this.exportDynamicWeight ? Double.valueOf(e.getWeight(graph.getView())) : Double.valueOf(e.getWeight());
        weightE.setTextContent(weight.toString());
        return weightE;
    }

    private Element createEdgeLabel(Document document, Edge e) throws Exception {
        Element labelE = document.createElement("data");
        labelE.setAttribute("key", "edgelabel");
        labelE.setTextContent(e.getLabel());
        return labelE;
    }

    private void calculateMinMax(Graph graph) {
        this.minX = Float.POSITIVE_INFINITY;
        this.maxX = Float.NEGATIVE_INFINITY;
        this.minY = Float.POSITIVE_INFINITY;
        this.maxY = Float.NEGATIVE_INFINITY;
        this.minZ = Float.POSITIVE_INFINITY;
        this.maxZ = Float.NEGATIVE_INFINITY;
        this.minSize = Float.POSITIVE_INFINITY;
        this.maxSize = Float.NEGATIVE_INFINITY;
        for (Node node : graph.getNodes()) {
            this.minX = Math.min(this.minX, node.x());
            this.maxX = Math.max(this.maxX, node.x());
            this.minY = Math.min(this.minY, node.y());
            this.maxY = Math.max(this.maxY, node.y());
            this.minZ = Math.min(this.minZ, node.z());
            this.maxZ = Math.max(this.maxZ, node.z());
            this.minSize = Math.min(this.minSize, node.size());
            this.maxSize = Math.max(this.maxSize, node.size());
        }
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }

    public String getName() {
        return NbBundle.getMessage(this.getClass(), (String)"ExporterGraphML_name");
    }

    public FileType[] getFileTypes() {
        FileType ft = new FileType(".graphml", NbBundle.getMessage(this.getClass(), (String)"fileType_GraphML_Name"));
        return new FileType[]{ft};
    }

    public void setExportAttributes(boolean exportAttributes) {
        this.exportAttributes = exportAttributes;
    }

    public void setExportColors(boolean exportColors) {
        this.exportColors = exportColors;
    }

    public void setExportPosition(boolean exportPosition) {
        this.exportPosition = exportPosition;
    }

    public void setExportSize(boolean exportSize) {
        this.exportSize = exportSize;
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public boolean isExportAttributes() {
        return this.exportAttributes;
    }

    public boolean isExportColors() {
        return this.exportColors;
    }

    public boolean isExportPosition() {
        return this.exportPosition;
    }

    public boolean isExportSize() {
        return this.exportSize;
    }

    public boolean isNormalize() {
        return this.normalize;
    }

    public boolean isExportVisible() {
        return this.exportVisible;
    }

    public void setExportVisible(boolean exportVisible) {
        this.exportVisible = exportVisible;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }
}

