/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.recentfiles;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.gephi.desktop.importer.api.ImportControllerUI;
import org.gephi.desktop.mrufiles.api.MostRecentFiles;
import org.gephi.desktop.project.api.ProjectControllerUI;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public class RecentFiles
extends CallableSystemAction {
    private static final String GEPHI_EXTENSION = "gephi";

    public void performAction() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getName() {
        return "recentfiles";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getMenuPresenter() {
        JMenu menu = new JMenu(NbBundle.getMessage(RecentFiles.class, (String)"CTL_OpenRecentFiles"));
        MostRecentFiles mru = (MostRecentFiles)Lookup.getDefault().lookup(MostRecentFiles.class);
        for (String filePath : mru.getMRUFileList()) {
            final File file = new File(filePath);
            if (!file.exists()) continue;
            String fileName = file.getName();
            JMenuItem menuItem = new JMenuItem(new AbstractAction(fileName){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileObject fileObject = FileUtil.toFileObject((File)file);
                    if (fileObject.hasExt(RecentFiles.GEPHI_EXTENSION)) {
                        ProjectControllerUI pc = (ProjectControllerUI)Lookup.getDefault().lookup(ProjectControllerUI.class);
                        try {
                            pc.openProject(file);
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    } else {
                        ImportControllerUI importController = (ImportControllerUI)Lookup.getDefault().lookup(ImportControllerUI.class);
                        if (importController.getImportController().isFileSupported(file)) {
                            importController.importFile(fileObject);
                        }
                    }
                }
            });
            menu.add(menuItem);
        }
        return menu;
    }
}

