/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.internal.context.oxm;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jaxb.core.JaxbNode;
import org.eclipse.jpt.jaxb.core.internal.context.AbstractJaxbContextNode;
import org.eclipse.jpt.jaxb.eclipselink.core.context.ELJaxbContextRoot;
import org.eclipse.jpt.jaxb.eclipselink.core.context.ELJaxbPackage;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmFile;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmFileDefinition;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmXmlBindings;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.oxm.OxmFileDefinitionImpl;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.oxm.OxmXmlBindingsImpl;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EXmlBindings;
import org.eclipse.jpt.jaxb.eclipselink.core.validation.JptJaxbEclipseLinkCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class OxmFileImpl
extends AbstractJaxbContextNode
implements OxmFile {
    protected OxmFileDefinition definition = new OxmFileDefinitionImpl();
    protected JptXmlResource oxmResource;
    protected JptResourceType resourceType;
    protected ELJaxbPackage elJaxbPackage;
    protected OxmXmlBindings xmlBindings;

    public OxmFileImpl(ELJaxbContextRoot parent, JptXmlResource oxmResource) {
        super((JaxbNode)parent);
        this.oxmResource = oxmResource;
        this.resourceType = oxmResource.getResourceType();
        this.xmlBindings = this.buildXmlBindings();
    }

    public ELJaxbContextRoot getContextRoot() {
        return (ELJaxbContextRoot)super.getContextRoot();
    }

    public IResource getResource() {
        return this.oxmResource.getFile();
    }

    @Override
    public OxmFileDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public JptXmlResource getOxmResource() {
        return this.oxmResource;
    }

    @Override
    public String getPackageName() {
        return this.xmlBindings == null ? null : this.xmlBindings.getPackageName();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.resourceType = this.oxmResource.getResourceType();
        this.syncXmlBindings();
    }

    public void update() {
        super.update();
        if (this.xmlBindings != null) {
            this.xmlBindings.update();
        }
    }

    @Override
    public ELJaxbPackage getJaxbPackage() {
        return this.elJaxbPackage;
    }

    @Override
    public void setPackage(ELJaxbPackage newPackage) {
        ELJaxbPackage oldPackage = this.elJaxbPackage;
        this.elJaxbPackage = newPackage;
        this.firePropertyChanged("package", oldPackage, newPackage);
    }

    @Override
    public OxmXmlBindings getXmlBindings() {
        return this.xmlBindings;
    }

    protected void setXmlBindings(OxmXmlBindings xmlBindings) {
        OxmXmlBindings oldXmlBindings = this.xmlBindings;
        this.xmlBindings = xmlBindings;
        this.firePropertyChanged("xmlBindings", oldXmlBindings, xmlBindings);
    }

    protected void syncXmlBindings() {
        EXmlBindings eXmlBindings = (EXmlBindings)this.oxmResource.getRootObject();
        if (this.xmlBindings == null || this.xmlBindings.getEXmlBindings() != eXmlBindings) {
            this.setXmlBindings(this.buildXmlBindings());
        }
        if (this.xmlBindings != null) {
            this.xmlBindings.synchronizeWithResourceModel();
        }
    }

    protected OxmXmlBindings buildXmlBindings() {
        EXmlBindings eXmlBindings = (EXmlBindings)this.oxmResource.getRootObject();
        return eXmlBindings == null ? null : new OxmXmlBindingsImpl(this, eXmlBindings);
    }

    protected EXmlBindings getEXmlBindings() {
        return (EXmlBindings)this.oxmResource.getRootObject();
    }

    public TextRange getValidationTextRange() {
        return this.getEXmlBindings().getValidationTextRange();
    }

    protected TextRange getVersionTextRange() {
        return this.getEXmlBindings().getVersionTextRange();
    }

    protected TextRange getPackageNameTextRange() {
        return this.getEXmlBindings().getPackageNameTextRange();
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.getJaxbPackage() == null) {
            if (StringTools.isBlank((String)this.getPackageName())) {
                messages.add(this.buildValidationMessage(this.getPackageNameTextRange(), JptJaxbEclipseLinkCoreValidationMessages.OXM_FILE__NO_PACKAGE_SPECIFIED));
            } else {
                messages.add(this.buildValidationMessage(this.getPackageNameTextRange(), JptJaxbEclipseLinkCoreValidationMessages.OXM_FILE__NO_SUCH_PACKAGE, new Object[]{this.getPackageName()}));
            }
        }
        if (this.xmlBindings != null) {
            this.xmlBindings.validate(messages, reporter);
        }
    }
}

