/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.apt.core.internal.AptProject;
import org.eclipse.jdt.apt.core.internal.generatedfile.GeneratedResourceChangeListener;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class AptPlugin
extends Plugin
implements DebugOptionsListener {
    public static final String PLUGIN_ID = "org.eclipse.jdt.apt.core";
    public static boolean DEBUG = false;
    public static final String APT_DEBUG_OPTION = "org.eclipse.jdt.apt.core/debug";
    public static boolean DEBUG_GFM = false;
    public static final String APT_DEBUG_GFM_OPTION = "org.eclipse.jdt.apt.core/debug/generatedFiles";
    public static boolean DEBUG_GFM_MAPS = false;
    public static final String APT_DEBUG_GFM_MAPS_OPTION = "org.eclipse.jdt.apt.core/debug/generatedFileMaps";
    public static boolean DEBUG_COMPILATION_ENV = false;
    public static final String APT_COMPILATION_ENV_OPTION = "org.eclipse.jdt.apt.core/debug/compilationEnv";
    public static final int STATUS_EXCEPTION = 1;
    public static final int STATUS_NOTOOLSJAR = 2;
    public static final int STATUS_CANTLOADPLUGINFACTORY = 3;
    public static final String APT_MARKER_SOURCE_ID = "APT";
    public static final String APT_BATCH_PROCESSOR_PROBLEM_MARKER = "org.eclipse.jdt.apt.core.marker";
    public static final String APT_LOADER_PROBLEM_MARKER = "org.eclipse.jdt.apt.core.buildproblem";
    public static final String APT_CONFIG_PROBLEM_MARKER = "org.eclipse.jdt.apt.core.configproblem";
    public static final String APT_COMPILATION_PROBLEM_MARKER = "org.eclipse.jdt.apt.core.compile.problem";
    public static final String APT_NONRECONCILE_COMPILATION_PROBLEM_MARKER = "org.eclipse.jdt.apt.core.nonreconcile.compile.problem";
    private static final SimpleDateFormat TRACE_DATE_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    private static AptPlugin thePlugin = null;
    private ServiceRegistration<DebugOptionsListener> debugRegistration;
    private static Class<?> _java6ProcessorClass;
    private static final Map<IJavaProject, AptProject> PROJECT_MAP;
    public static final String JAVA5_FACTORY_NAME = "com.sun.mirror.apt.AnnotationProcessorFactory";
    public static final String JAVA6_FACTORY_NAME = "javax.annotation.processing.Processor";

    static {
        PROJECT_MAP = new HashMap<IJavaProject, AptProject>();
    }

    public void start(BundleContext context) throws Exception {
        thePlugin = this;
        super.start(context);
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        properties.put("listener.symbolic.name", PLUGIN_ID);
        this.debugRegistration = context.registerService(DebugOptionsListener.class, (Object)this, properties);
        try {
            _java6ProcessorClass = Class.forName(JAVA6_FACTORY_NAME);
        }
        catch (Throwable throwable) {}
        AptConfig.initialize();
        int mask = 15;
        JavaCore.addPreProcessingResourceChangedListener((IResourceChangeListener)new GeneratedResourceChangeListener(), (int)mask);
        if (DEBUG) {
            AptPlugin.trace("registered resource change listener");
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.debugRegistration.unregister();
        this.debugRegistration = null;
    }

    public static AptPlugin getPlugin() {
        return thePlugin;
    }

    public static void log(IStatus status) {
        thePlugin.getLog().log(status);
    }

    public static void log(Throwable e, String message) {
        AptPlugin.log((IStatus)new Status(4, PLUGIN_ID, 1, message, e));
    }

    public static void logWarning(Throwable e, String message) {
        AptPlugin.log((IStatus)AptPlugin.createWarningStatus(e, message));
    }

    public static Status createStatus(Throwable e, String message) {
        return new Status(4, PLUGIN_ID, 1, message, e);
    }

    public static Status createWarningStatus(Throwable e, String message) {
        return new Status(2, PLUGIN_ID, 1, message, e);
    }

    public static Status createInfoStatus(Throwable e, String message) {
        return new Status(1, PLUGIN_ID, 1, message, e);
    }

    public void optionsChanged(DebugOptions options) {
        DEBUG = options.getBooleanOption(APT_DEBUG_OPTION, false);
        DEBUG_GFM = options.getBooleanOption(APT_DEBUG_GFM_OPTION, false);
        DEBUG_GFM_MAPS = options.getBooleanOption(APT_DEBUG_GFM_MAPS_OPTION, false);
        DEBUG_COMPILATION_ENV = options.getBooleanOption(APT_COMPILATION_ENV_OPTION, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void trace(String msg) {
        if (DEBUG) {
            StringBuffer sb = new StringBuffer();
            sb.append('[');
            SimpleDateFormat simpleDateFormat = TRACE_DATE_FORMAT;
            synchronized (simpleDateFormat) {
                sb.append(TRACE_DATE_FORMAT.format(new Date()));
            }
            sb.append('-');
            String threadName = Thread.currentThread().getName();
            int dot = threadName.lastIndexOf(46);
            if (dot < 0) {
                sb.append(threadName);
            } else {
                sb.append(threadName.substring(dot + 1));
            }
            sb.append(']');
            sb.append(msg);
            System.out.println(sb);
        }
    }

    public static void trace(String msg, Throwable t) {
        AptPlugin.trace(msg);
        if (DEBUG) {
            t.printStackTrace(System.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AptProject getAptProject(IJavaProject javaProject, boolean create) {
        Map<IJavaProject, AptProject> map = PROJECT_MAP;
        synchronized (map) {
            AptProject aptProject = PROJECT_MAP.get(javaProject);
            if (aptProject != null) {
                return aptProject;
            }
            if (create) {
                aptProject = new AptProject(javaProject);
                PROJECT_MAP.put(javaProject, aptProject);
                return aptProject;
            }
            return null;
        }
    }

    public static AptProject getAptProject(IJavaProject javaProject) {
        return AptPlugin.getAptProject(javaProject, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAptProject(IJavaProject javaProject) {
        Map<IJavaProject, AptProject> map = PROJECT_MAP;
        synchronized (map) {
            PROJECT_MAP.remove(javaProject);
        }
    }

    public static boolean canRunJava6Processors() {
        if (_java6ProcessorClass == null) {
            return false;
        }
        return Platform.getBundle((String)"org.eclipse.jdt.compiler.apt") != null;
    }

    public static Class<?> getJava6ProcessorClass() {
        return _java6ProcessorClass;
    }
}

