/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.standalone.ui.internal.startcommand;

import java.util.ArrayList;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.standalone.ui.internal.Messages;
import org.eclipse.cft.server.standalone.ui.internal.SelectMainTypeWizard;
import org.eclipse.cft.server.ui.internal.CFUiUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.debug.ui.launcher.MainMethodSearchEngine;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class JavaTypeResolver {
    private final IJavaProject project;
    private String serverID;

    public JavaTypeResolver(IJavaProject project, String serverID) {
        this.project = project;
        this.serverID = serverID;
    }

    protected IJavaProject getJavaProject() {
        return this.project;
    }

    public IType[] getMainTypes(IProgressMonitor monitor) {
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null) {
            boolean includeSubtypes = true;
            MainMethodSearchEngine engine = new MainMethodSearchEngine();
            int constraints = 1;
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject}, (int)(constraints |= 2));
            return engine.searchMainMethods(monitor, scope, includeSubtypes);
        }
        return new IType[0];
    }

    public IType getMainTypesFromSource(IProgressMonitor monitor) {
        IType[] types;
        if (this.project != null && (types = this.getMainTypes(monitor)) != null && types.length > 0) {
            final ArrayList<IType> typesFromSource = new ArrayList<IType>();
            IType[] iTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                if (!type.isBinary() && !typesFromSource.contains(type)) {
                    typesFromSource.add(type);
                }
                ++n2;
            }
            if (typesFromSource.size() == 1) {
                return (IType)typesFromSource.get(0);
            }
            final IType[] selectedType = new IType[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = CFUiUtil.getShell();
                    if (shell != null && !shell.isDisposed()) {
                        SelectMainTypeWizard wizard = new SelectMainTypeWizard(JavaTypeResolver.this.serverID, typesFromSource);
                        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                        if (dialog.open() == 0) {
                            selectedType[0] = wizard.getSelectedMainType();
                        }
                    } else {
                        CloudFoundryPlugin.getCallback().displayAndLogError(CloudFoundryPlugin.getErrorStatus((String)NLS.bind((String)Messages.SelectMainTypeWizardPage_NO_SHELL, (Object)JavaTypeResolver.this.project.getProject().getName())));
                        selectedType[0] = (IType)typesFromSource.get(0);
                    }
                }
            });
            return selectedType[0];
        }
        return null;
    }
}

