/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.cdt.internal.ui.editor.CSourceViewer;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.SimpleCSourceViewerConfiguration;
import org.eclipse.cdt.internal.ui.text.c.hover.SourceViewerInformationControl;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractSourceViewerInformationControl
extends AbstractInformationControl
implements IInformationControlExtension2,
DisposeListener {
    private ISourceViewer fSourceViewer;
    private Color fBackgroundColor;
    private boolean fIsSystemBackgroundColor = true;
    private Font fTextFont;
    private StyledText fText;
    private Label fTitleLabel;

    public AbstractSourceViewerInformationControl(Shell parent, String statusFieldText) {
        super(parent, statusFieldText);
        this.create();
    }

    public AbstractSourceViewerInformationControl(Shell parent, boolean isResizable) {
        super(parent, isResizable);
        this.create();
    }

    protected boolean hasHeader() {
        return false;
    }

    private void initializeColors() {
        IPreferenceStore store = CUIPlugin.getDefault().getPreferenceStore();
        RGB bgRGB = store.getBoolean("sourceHoverBackgroundColor.SystemDefault") ? SourceViewerInformationControl.getVisibleBackgroundColor(this.getShell().getDisplay()) : PreferenceConverter.getColor((IPreferenceStore)store, (String)"sourceHoverBackgroundColor");
        if (bgRGB != null) {
            this.fBackgroundColor = new Color((Device)this.getShell().getDisplay(), bgRGB);
            this.fIsSystemBackgroundColor = false;
        } else {
            this.fBackgroundColor = this.getShell().getDisplay().getSystemColor(29);
            this.fIsSystemBackgroundColor = true;
        }
    }

    public void createContent(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        content.setLayout((Layout)gridLayout);
        if (this.hasHeader()) {
            this.createTitleLabel(content);
        }
        this.fSourceViewer = this.createSourceViewer(content, 0);
        StyledText text = this.fSourceViewer.getTextWidget();
        text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    AbstractSourceViewerInformationControl.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.addDisposeListener(this);
    }

    protected final ISourceViewer createSourceViewer(Composite parent, int style) {
        IPreferenceStore store = CUIPlugin.getDefault().getCombinedPreferenceStore();
        CSourceViewer sourceViewer = new CSourceViewer(parent, null, null, false, style, store);
        CTextTools tools = CUIPlugin.getDefault().getTextTools();
        sourceViewer.configure((SourceViewerConfiguration)new SimpleCSourceViewerConfiguration(tools.getColorManager(), store, null, "___c_partitioning", false));
        sourceViewer.setEditable(false);
        this.fText = sourceViewer.getTextWidget();
        GridData gd = new GridData(1809);
        this.fText.setLayoutData((Object)gd);
        this.initializeColors();
        this.fText.setForeground(parent.getDisplay().getSystemColor(28));
        this.fText.setBackground(this.fBackgroundColor);
        this.fTextFont = JFaceResources.getFont((String)"org.eclipse.cdt.ui.editors.textfont");
        this.fText.setFont(this.fTextFont);
        return sourceViewer;
    }

    private void createTitleLabel(Composite parent) {
        this.fTitleLabel = new Label(parent, 16384);
        this.fTitleLabel.setLayoutData((Object)new GridData(768));
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
        this.fTitleLabel.setFont(JFaceResources.getDialogFont());
        Display display = parent.getDisplay();
        Color foreground = display.getSystemColor(28);
        Color background = display.getSystemColor(29);
        this.fTitleLabel.setForeground(foreground);
        this.fTitleLabel.setBackground(background);
    }

    public void setTitleText(String titleText) {
        if (this.fTitleLabel != null) {
            this.fTitleLabel.setText(titleText);
        }
    }

    protected final ISourceViewer getSourceViewer() {
        return this.fSourceViewer;
    }

    public void setInformation(String content) {
        if (content == null) {
            this.fSourceViewer.setDocument(null);
            return;
        }
        Document doc = new Document(content);
        CUIPlugin.getDefault().getTextTools().setupCDocument((IDocument)doc);
        this.fSourceViewer.setDocument((IDocument)doc);
    }

    public void setInput(Object input) {
        if (input instanceof String) {
            this.setInformation((String)input);
        } else {
            this.setInformation(null);
        }
    }

    public final void dispose() {
        if (!this.fIsSystemBackgroundColor) {
            this.fBackgroundColor.dispose();
        }
        super.dispose();
    }

    public void widgetDisposed(DisposeEvent event) {
        this.fSourceViewer = null;
    }

    public boolean hasContents() {
        return this.fSourceViewer != null && this.fSourceViewer.getDocument() != null;
    }

    public void setFocus() {
        super.setFocus();
        this.fSourceViewer.getTextWidget().setFocus();
    }

    public Point computeSizeConstraints(int widthInChars, int heightInChars) {
        GC gc = new GC((Drawable)this.fText);
        gc.setFont(this.fTextFont);
        int width = gc.getFontMetrics().getAverageCharWidth();
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        return new Point(widthInChars * width, heightInChars * height);
    }

    public Point computeSizeHint() {
        int x = -1;
        int y = -1;
        Point size = this.getShell().computeSize(x, y);
        Point constraints = this.getSizeConstraints();
        if (constraints != null) {
            if (size.x > constraints.x) {
                x = constraints.x;
            }
            if (size.y > constraints.y) {
                y = constraints.y;
            }
        }
        if (x != -1 || y != -1) {
            size = this.getShell().computeSize(x, y, false);
        }
        return size;
    }
}

