/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.spreadsheet;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridCell;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridPos;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.Spreadsheet;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.SpreadsheetPresentation;
import org.jkiss.utils.CommonUtils;

class SpreadsheetFindReplaceTarget
implements IFindReplaceTarget,
IFindReplaceTargetExtension,
IFindReplaceTargetExtension3 {
    private static final Log log = Log.getLog(SpreadsheetFindReplaceTarget.class);
    private final SpreadsheetPresentation owner;
    private Pattern searchPattern;
    private Color scopeHighlightColor;
    private boolean replaceAll;
    private boolean sessionActive = false;

    SpreadsheetFindReplaceTarget(SpreadsheetPresentation owner) {
        this.owner = owner;
    }

    public boolean isSessionActive() {
        return this.sessionActive;
    }

    public Pattern getSearchPattern() {
        return this.searchPattern;
    }

    public Color getScopeHighlightColor() {
        return this.scopeHighlightColor;
    }

    public boolean canPerformFind() {
        return true;
    }

    public int findAndSelect(int widgetOffset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
        return this.findAndSelect(widgetOffset, findString, searchForward, caseSensitive, wholeWord, false);
    }

    public Point getSelection() {
        Collection<GridPos> selection = this.owner.getSpreadsheet().getSelection();
        if (selection.isEmpty()) {
            return new Point(-1, -1);
        }
        GridPos pos = selection.iterator().next();
        return new Point(pos.col, pos.row);
    }

    public String getSelectionText() {
        GridPos selection = (GridPos)this.owner.getSelection().getFirstElement();
        if (selection == null) {
            return "";
        }
        Spreadsheet spreadsheet = this.owner.getSpreadsheet();
        GridCell cell = spreadsheet.posToCell(selection);
        String value = cell == null ? "" : spreadsheet.getContentProvider().getCellText(cell.col, cell.row);
        return CommonUtils.toString((Object)value);
    }

    public boolean isEditable() {
        return !this.owner.getController().isReadOnly();
    }

    public void replaceSelection(String text) {
        this.replaceSelection(text, false);
    }

    public void beginSession() {
        this.sessionActive = true;
        this.owner.getControl().redraw();
    }

    public void endSession() {
        this.sessionActive = false;
        this.searchPattern = null;
        Control control = this.owner.getControl();
        if (control != null && !control.isDisposed()) {
            control.redraw();
        }
    }

    public IRegion getScope() {
        return null;
    }

    public void setScope(IRegion scope) {
    }

    public Point getLineSelection() {
        return this.getSelection();
    }

    public void setSelection(int offset, int length) {
        this.owner.setSelection((ISelection)new StructuredSelection((Object)new GridPos(offset, length)));
    }

    public void setScopeHighlightColor(Color color) {
        this.scopeHighlightColor = color;
    }

    public void setReplaceAllMode(boolean replaceAll) {
        this.replaceAll = replaceAll;
    }

    public int findAndSelect(int offset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord, boolean regExSearch) {
        Pattern findPattern;
        GridPos startPosition;
        this.searchPattern = null;
        ResultSetModel model = this.owner.getController().getModel();
        if (model.isEmpty()) {
            return -1;
        }
        Spreadsheet spreadsheet = this.owner.getSpreadsheet();
        int rowCount = spreadsheet.getItemCount();
        int columnCount = spreadsheet.getColumnCount();
        Collection<GridPos> selection = spreadsheet.getSelection();
        GridPos gridPos = startPosition = selection.isEmpty() ? null : selection.iterator().next();
        if (startPosition == null) {
            startPosition = new GridPos(0, 0);
        }
        if (regExSearch) {
            try {
                findPattern = Pattern.compile(findString, caseSensitive ? 0 : 2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                log.warn((Object)("Bad regex pattern: " + findString));
                return -1;
            }
        } else {
            findPattern = Pattern.compile(Pattern.quote(findString), caseSensitive ? 0 : 2);
        }
        int minColumnNum = this.owner.getController().isRecordMode() ? -1 : 0;
        GridPos curPosition = new GridPos(startPosition);
        while (true) {
            String cellText;
            if (searchForward) {
                ++curPosition.col;
                if (curPosition.col >= columnCount) {
                    curPosition.col = minColumnNum;
                    ++curPosition.row;
                }
            } else {
                --curPosition.col;
                if (curPosition.col < minColumnNum) {
                    curPosition.col = columnCount - 1;
                    --curPosition.row;
                }
            }
            if (curPosition.row < 0 || curPosition.row >= rowCount) {
                if (offset == -1) {
                    offset = 0;
                    curPosition = searchForward ? new GridPos(0, 0) : new GridPos(columnCount - 1, rowCount - 1);
                } else {
                    return -1;
                }
            }
            if (this.owner.getController().isRecordMode() && curPosition.col == minColumnNum) {
                cellText = spreadsheet.getLabelProvider().getText(spreadsheet.getRowElement(curPosition.row));
            } else {
                GridCell cell = spreadsheet.posToCell(curPosition);
                if (cell == null) continue;
                cellText = spreadsheet.getContentProvider().getCellText(cell.col, cell.row);
            }
            Matcher matcher = findPattern.matcher(cellText);
            if (wholeWord ? matcher.matches() : matcher.find()) break;
        }
        if (curPosition.col == minColumnNum) {
            curPosition.col = 0;
        }
        spreadsheet.setFocusColumn(curPosition.col);
        spreadsheet.setFocusItem(curPosition.row);
        spreadsheet.setCellSelection(curPosition);
        spreadsheet.showSelection();
        this.searchPattern = findPattern;
        return curPosition.row;
    }

    public void replaceSelection(String text, boolean regExReplace) {
        boolean recordMode;
        GridPos selection = (GridPos)this.owner.getSelection().getFirstElement();
        if (selection == null) {
            return;
        }
        GridCell cell = this.owner.getSpreadsheet().posToCell(selection);
        if (cell == null) {
            return;
        }
        String oldValue = this.owner.getSpreadsheet().getContentProvider().getCellText(cell.col, cell.row);
        String newValue = text;
        if (this.searchPattern != null) {
            newValue = this.searchPattern.matcher(oldValue).replaceAll(newValue);
        }
        DBDAttributeBinding attr = (DBDAttributeBinding)((recordMode = this.owner.getController().isRecordMode()) ? cell.row : cell.col);
        ResultSetRow row = (ResultSetRow)(recordMode ? cell.col : cell.row);
        this.owner.getController().getModel().updateCellValue(attr, row, newValue);
        this.owner.getController().updatePanelsContent(false);
    }

    public String toString() {
        DBSDataContainer dataContainer = this.owner.getController().getDataContainer();
        return "Target: " + (dataContainer == null ? null : dataContainer.getName());
    }
}

