/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.attributes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jgit.attributes.Attribute;

public final class Attributes {
    private final Map<String, Attribute> map = new LinkedHashMap<String, Attribute>();

    public Attributes(Attribute ... attributes) {
        if (attributes != null) {
            for (Attribute a : attributes) {
                this.put(a);
            }
        }
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Attribute get(String key2) {
        return this.map.get(key2);
    }

    public Collection<Attribute> getAll() {
        return new ArrayList<Attribute>(this.map.values());
    }

    public void put(Attribute a) {
        this.map.put(a.getKey(), a);
    }

    public void remove(String key2) {
        this.map.remove(key2);
    }

    public boolean containsKey(String key2) {
        return this.map.containsKey(key2);
    }

    public Attribute.State getState(String key2) {
        Attribute a = this.map.get(key2);
        return a != null ? a.getState() : Attribute.State.UNSPECIFIED;
    }

    public boolean isSet(String key2) {
        return this.getState(key2) == Attribute.State.SET;
    }

    public boolean isUnset(String key2) {
        return this.getState(key2) == Attribute.State.UNSET;
    }

    public boolean isUnspecified(String key2) {
        return this.getState(key2) == Attribute.State.UNSPECIFIED;
    }

    public boolean isCustom(String key2) {
        return this.getState(key2) == Attribute.State.CUSTOM;
    }

    public String getValue(String key2) {
        Attribute a = this.map.get(key2);
        return a != null ? a.getValue() : null;
    }

    public boolean canBeContentMerged() {
        if (this.isUnset("merge")) {
            return false;
        }
        return !this.isCustom("merge") || !this.getValue("merge").equals("binary");
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append("[");
        buf.append(" ");
        for (Attribute a : this.map.values()) {
            buf.append(a.toString());
            buf.append(" ");
        }
        buf.append("]");
        return buf.toString();
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Attributes)) {
            return false;
        }
        Attributes other = (Attributes)obj;
        return this.map.equals(other.map);
    }
}

