"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _url = _interopRequireDefault(require("url"));

var _path = _interopRequireDefault(require("path"));

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _helpers = require("../helpers");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CloneDialog extends _react["default"].Component {
  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'clone', 'cancel', 'didChangeRemoteUrl', 'didChangeProjectPath', 'editorRefs');
    this.state = {
      cloneDisabled: false
    };
    this.projectHome = this.props.config.get('core.projectHome');
    this.subs = new _eventKit.CompositeDisposable();
  }

  componentDidMount() {
    if (this.projectPathEditor) {
      this.projectPathEditor.setText(this.props.config.get('core.projectHome'));
      this.projectPathModified = false;
    }

    if (this.remoteUrlElement) {
      setTimeout(() => this.remoteUrlElement.focus());
    }
  }

  render() {
    if (!this.props.inProgress) {
      return this.renderDialog();
    } else {
      return this.renderSpinner();
    }
  }

  renderDialog() {
    return _react["default"].createElement("div", {
      className: "github-Dialog github-Clone modal"
    }, _react["default"].createElement(_commands["default"], {
      registry: this.props.commandRegistry,
      target: ".github-Clone"
    }, _react["default"].createElement(_commands.Command, {
      command: "core:cancel",
      callback: this.cancel
    }), _react["default"].createElement(_commands.Command, {
      command: "core:confirm",
      callback: this.clone
    })), _react["default"].createElement("main", {
      className: "github-DialogInputs"
    }, _react["default"].createElement("label", {
      className: "github-DialogLabel github-CloneUrl"
    }, "Clone from", _react["default"].createElement("atom-text-editor", {
      mini: true,
      ref: this.editorRefs('remoteUrl'),
      tabIndex: "1"
    })), _react["default"].createElement("label", {
      className: "github-DialogLabel github-ProjectPath"
    }, "To directory", _react["default"].createElement("atom-text-editor", {
      mini: true,
      ref: this.editorRefs('projectPath'),
      tabIndex: "2"
    }))), _react["default"].createElement("div", {
      className: "github-DialogButtons"
    }, _react["default"].createElement("button", {
      className: "btn github-CancelButton",
      onClick: this.cancel,
      tabIndex: "3"
    }, "Cancel"), _react["default"].createElement("button", {
      className: "btn btn-primary icon icon-repo-clone",
      onClick: this.clone,
      disabled: this.state.cloneDisabled,
      tabIndex: "4"
    }, "Clone")));
  }

  renderSpinner() {
    return _react["default"].createElement("div", {
      className: "github-Dialog github-Clone modal"
    }, _react["default"].createElement("main", {
      className: "github-DialogSpinner"
    }, _react["default"].createElement("span", {
      className: "loading loading-spinner-small inline-block"
    }), _react["default"].createElement("span", {
      className: "github-DialogMessage inline-block"
    }, "Cloning ", _react["default"].createElement("strong", null, this.getRemoteUrl()))));
  }

  clone() {
    if (this.getRemoteUrl().length === 0 || this.getProjectPath().length === 0) {
      return;
    }

    this.props.didAccept(this.getRemoteUrl(), this.getProjectPath());
  }

  cancel() {
    this.props.didCancel();
  }

  didChangeRemoteUrl() {
    if (!this.projectPathModified) {
      const name = _path["default"].basename(_url["default"].parse(this.getRemoteUrl()).pathname, '.git') || '';

      if (name.length > 0) {
        const proposedPath = _path["default"].join(this.projectHome, name);

        this.projectPathEditor.setText(proposedPath);
        this.projectPathModified = false;
      }
    }

    this.setCloneEnablement();
  }

  didChangeProjectPath() {
    this.projectPathModified = true;
    this.setCloneEnablement();
  }

  editorRefs(baseName) {
    const elementName = `${baseName}Element`;
    const modelName = `${baseName}Editor`;
    const subName = `${baseName}Subs`;
    const changeMethodName = `didChange${baseName[0].toUpperCase()}${baseName.substring(1)}`;
    return element => {
      if (!element) {
        return;
      }

      this[elementName] = element;
      const editor = element.getModel();

      if (this[modelName] !== editor) {
        this[modelName] = editor;

        if (this[subName]) {
          this[subName].dispose();
          this.subs.remove(this[subName]);
        }

        this[subName] = editor.onDidChange(this[changeMethodName]);
        this.subs.add(this[subName]);
      }
    };
  }

  getProjectPath() {
    return this.projectPathEditor ? this.projectPathEditor.getText() : '';
  }

  getRemoteUrl() {
    return this.remoteUrlEditor ? this.remoteUrlEditor.getText() : '';
  }

  setCloneEnablement() {
    const disabled = this.getRemoteUrl().length === 0 || this.getProjectPath().length === 0;
    this.setState({
      cloneDisabled: disabled
    });
  }

}

exports["default"] = CloneDialog;

_defineProperty(CloneDialog, "propTypes", {
  config: _propTypes["default"].object.isRequired,
  commandRegistry: _propTypes["default"].object.isRequired,
  inProgress: _propTypes["default"].bool,
  didAccept: _propTypes["default"].func,
  didCancel: _propTypes["default"].func
});

_defineProperty(CloneDialog, "defaultProps", {
  inProgress: false,
  didAccept: () => {},
  didCancel: () => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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