"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reporterProxy = require("../reporter-proxy");

var _eventKit = require("event-kit");

var _commitDetailItem = _interopRequireDefault(require("../items/commit-detail-item"));

var _uriPattern = _interopRequireDefault(require("../atom/uri-pattern"));

var _recentCommitsView = _interopRequireDefault(require("../views/recent-commits-view"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class RecentCommitsController extends _react["default"].Component {
  constructor(props, context) {
    super(props, context);

    _defineProperty(this, "updateSelectedCommit", () => {
      const activeItem = this.props.workspace.getActivePaneItem();
      const pattern = new _uriPattern["default"](decodeURIComponent(_commitDetailItem["default"].buildURI(this.props.repository.getWorkingDirectoryPath(), '{sha}')));

      if (activeItem && activeItem.getURI) {
        const match = pattern.matches(activeItem.getURI());
        const {
          sha
        } = match.getParams();

        if (match.ok() && sha && sha !== this.state.selectedCommitSha) {
          return new Promise(resolve => this.setState({
            selectedCommitSha: sha
          }, resolve));
        }
      }

      return Promise.resolve();
    });

    _defineProperty(this, "openCommit", async ({
      sha,
      preserveFocus
    }) => {
      const workdir = this.props.repository.getWorkingDirectoryPath();

      const uri = _commitDetailItem["default"].buildURI(workdir, sha);

      const item = await this.props.workspace.open(uri, {
        pending: true
      });

      if (preserveFocus) {
        item.preventFocus();
        this.setFocus(this.constructor.focus.RECENT_COMMIT);
      }

      (0, _reporterProxy.addEvent)('open-commit-in-pane', {
        "package": 'github',
        from: this.constructor.name
      });
    });

    _defineProperty(this, "selectNextCommit", () => this.setSelectedCommitIndex(this.getSelectedCommitIndex() + 1));

    _defineProperty(this, "selectPreviousCommit", () => this.setSelectedCommitIndex(Math.max(this.getSelectedCommitIndex() - 1, 0)));

    this.subscriptions = new _eventKit.CompositeDisposable(this.props.workspace.onDidChangeActivePaneItem(this.updateSelectedCommit));
    this.refView = new _refHolder["default"]();
    this.state = {
      selectedCommitSha: ''
    };
  }

  render() {
    return _react["default"].createElement(_recentCommitsView["default"], {
      ref: this.refView.setter,
      commits: this.props.commits,
      isLoading: this.props.isLoading,
      undoLastCommit: this.props.undoLastCommit,
      openCommit: this.openCommit,
      selectNextCommit: this.selectNextCommit,
      selectPreviousCommit: this.selectPreviousCommit,
      selectedCommitSha: this.state.selectedCommitSha,
      commandRegistry: this.props.commandRegistry
    });
  }

  getSelectedCommitIndex() {
    return this.props.commits.findIndex(commit => commit.getSha() === this.state.selectedCommitSha);
  }

  setSelectedCommitIndex(ind) {
    const commit = this.props.commits[ind];

    if (commit) {
      return new Promise(resolve => this.setState({
        selectedCommitSha: commit.getSha()
      }, resolve));
    } else {
      return Promise.resolve();
    }
  }

  getFocus(element) {
    return this.refView.map(view => view.getFocus(element)).getOr(null);
  }

  setFocus(focus) {
    return this.refView.map(view => {
      const wasFocused = view.setFocus(focus);

      if (wasFocused && this.getSelectedCommitIndex() === -1) {
        this.setSelectedCommitIndex(0);
      }

      return wasFocused;
    }).getOr(false);
  }

  advanceFocusFrom(focus) {
    return this.refView.map(view => view.advanceFocusFrom(focus)).getOr(Promise.resolve(null));
  }

  retreatFocusFrom(focus) {
    return this.refView.map(view => view.retreatFocusFrom(focus)).getOr(Promise.resolve(null));
  }

}

exports["default"] = RecentCommitsController;

_defineProperty(RecentCommitsController, "propTypes", {
  commits: _propTypes["default"].arrayOf(_propTypes["default"].object).isRequired,
  isLoading: _propTypes["default"].bool.isRequired,
  undoLastCommit: _propTypes["default"].func.isRequired,
  workspace: _propTypes["default"].object.isRequired,
  repository: _propTypes["default"].object.isRequired,
  commandRegistry: _propTypes["default"].object.isRequired
});

_defineProperty(RecentCommitsController, "focus", _recentCommitsView["default"].focus);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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