Object.defineProperty(exports, '__esModule', {
  value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _atomSlick = require('atom-slick');

var _atomSlick2 = _interopRequireDefault(_atomSlick);

'use babel';

var EscapeCharacterRegex = /[-!"#$%&'*+,/:;=?@|^~()<>{}[\]]/g;

var cachedMatchesBySelector = {};

var getCachedMatch = function getCachedMatch(selector, scopeChain) {
  var cachedMatchesByScopeChain = cachedMatchesBySelector[selector];
  if (cachedMatchesByScopeChain) {
    return cachedMatchesByScopeChain[scopeChain];
  }
};

var setCachedMatch = function setCachedMatch(selector, scopeChain, match) {
  var cachedMatchesByScopeChain = cachedMatchesBySelector[selector];
  if (!cachedMatchesByScopeChain) {
    cachedMatchesByScopeChain = {};
    cachedMatchesBySelector[selector] = cachedMatchesByScopeChain;
  }
  cachedMatchesByScopeChain[scopeChain] = match;
  cachedMatchesByScopeChain[scopeChain];
};

var parseScopeChain = function parseScopeChain(scopeChain) {
  scopeChain = scopeChain.replace(EscapeCharacterRegex, function (match) {
    return '\\' + match[0];
  });

  var parsed = _atomSlick2['default'].parse(scopeChain)[0];
  if (!parsed || parsed.length === 0) {
    return [];
  }

  var result = [];
  for (var i = 0; i < parsed.length; i++) {
    result.push(parsed[i]);
  }

  return result;
};

var selectorForScopeChain = function selectorForScopeChain(selectors, scopeChain) {
  for (var i = 0; i < selectors.length; i++) {
    var selector = selectors[i];
    var cachedMatch = getCachedMatch(selector, scopeChain);
    if (cachedMatch != null) {
      if (cachedMatch) {
        return selector;
      } else {
        continue;
      }
    } else {
      var scopes = parseScopeChain(scopeChain);
      while (scopes.length > 0) {
        if (selector.matches(scopes)) {
          setCachedMatch(selector, scopeChain, true);
          return selector;
        }
        scopes.pop();
      }
      setCachedMatch(selector, scopeChain, false);
    }
  }

  return null;
};

var selectorsMatchScopeChain = function selectorsMatchScopeChain(selectors, scopeChain) {
  return selectorForScopeChain(selectors, scopeChain) != null;
};

var buildScopeChainString = function buildScopeChainString(scopes) {
  return '.' + scopes.join(' .');
};

exports.selectorsMatchScopeChain = selectorsMatchScopeChain;
exports.selectorForScopeChain = selectorForScopeChain;
exports.buildScopeChainString = buildScopeChainString;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzguMi9vdXQvYXBwL25vZGVfbW9kdWxlcy9hdXRvY29tcGxldGUtcGx1cy9saWIvc2NvcGUtaGVscGVycy5qcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7eUJBRWtCLFlBQVk7Ozs7QUFGOUIsV0FBVyxDQUFBOztBQUlYLElBQU0sb0JBQW9CLEdBQUcsa0NBQWtDLENBQUE7O0FBRS9ELElBQU0sdUJBQXVCLEdBQUcsRUFBRSxDQUFBOztBQUVsQyxJQUFNLGNBQWMsR0FBRyxTQUFqQixjQUFjLENBQUksUUFBUSxFQUFFLFVBQVUsRUFBSztBQUMvQyxNQUFNLHlCQUF5QixHQUFHLHVCQUF1QixDQUFDLFFBQVEsQ0FBQyxDQUFBO0FBQ25FLE1BQUkseUJBQXlCLEVBQUU7QUFDN0IsV0FBTyx5QkFBeUIsQ0FBQyxVQUFVLENBQUMsQ0FBQTtHQUM3QztDQUNGLENBQUE7O0FBRUQsSUFBTSxjQUFjLEdBQUcsU0FBakIsY0FBYyxDQUFJLFFBQVEsRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFLO0FBQ3RELE1BQUkseUJBQXlCLEdBQUcsdUJBQXVCLENBQUMsUUFBUSxDQUFDLENBQUE7QUFDakUsTUFBSSxDQUFDLHlCQUF5QixFQUFFO0FBQzlCLDZCQUF5QixHQUFHLEVBQUUsQ0FBQTtBQUM5QiwyQkFBdUIsQ0FBQyxRQUFRLENBQUMsR0FBRyx5QkFBeUIsQ0FBQTtHQUM5RDtBQUNELDJCQUF5QixDQUFDLFVBQVUsQ0FBQyxHQUFHLEtBQUssQ0FBQTtBQUM3QywyQkFBeUIsQ0FBQyxVQUFVLENBQUMsQ0FBQTtDQUN0QyxDQUFBOztBQUVELElBQU0sZUFBZSxHQUFHLFNBQWxCLGVBQWUsQ0FBSSxVQUFVLEVBQUs7QUFDdEMsWUFBVSxHQUFHLFVBQVUsQ0FBQyxPQUFPLENBQUMsb0JBQW9CLEVBQUUsVUFBQyxLQUFLLEVBQUs7QUFDL0QsV0FBTyxJQUFJLEdBQUcsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFBO0dBQ3ZCLENBQUMsQ0FBQTs7QUFFRixNQUFNLE1BQU0sR0FBRyx1QkFBTSxLQUFLLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUE7QUFDekMsTUFBSSxDQUFDLE1BQU0sSUFBSSxNQUFNLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRTtBQUNsQyxXQUFPLEVBQUUsQ0FBQTtHQUNWOztBQUVELE1BQU0sTUFBTSxHQUFHLEVBQUUsQ0FBQTtBQUNqQixPQUFLLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEdBQUcsTUFBTSxDQUFDLE1BQU0sRUFBRSxDQUFDLEVBQUUsRUFBRTtBQUN0QyxVQUFNLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFBO0dBQ3ZCOztBQUVELFNBQU8sTUFBTSxDQUFBO0NBQ2QsQ0FBQTs7QUFFRCxJQUFNLHFCQUFxQixHQUFHLFNBQXhCLHFCQUFxQixDQUFJLFNBQVMsRUFBRSxVQUFVLEVBQUs7QUFDdkQsT0FBSyxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxHQUFHLFNBQVMsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxFQUFFLEVBQUU7QUFDekMsUUFBTSxRQUFRLEdBQUcsU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFBO0FBQzdCLFFBQU0sV0FBVyxHQUFHLGNBQWMsQ0FBQyxRQUFRLEVBQUUsVUFBVSxDQUFDLENBQUE7QUFDeEQsUUFBSSxXQUFXLElBQUksSUFBSSxFQUFFO0FBQ3ZCLFVBQUksV0FBVyxFQUFFO0FBQ2YsZUFBTyxRQUFRLENBQUE7T0FDaEIsTUFBTTtBQUNMLGlCQUFRO09BQ1Q7S0FDRixNQUFNO0FBQ0wsVUFBTSxNQUFNLEdBQUcsZUFBZSxDQUFDLFVBQVUsQ0FBQyxDQUFBO0FBQzFDLGFBQU8sTUFBTSxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUU7QUFDeEIsWUFBSSxRQUFRLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxFQUFFO0FBQzVCLHdCQUFjLENBQUMsUUFBUSxFQUFFLFVBQVUsRUFBRSxJQUFJLENBQUMsQ0FBQTtBQUMxQyxpQkFBTyxRQUFRLENBQUE7U0FDaEI7QUFDRCxjQUFNLENBQUMsR0FBRyxFQUFFLENBQUE7T0FDYjtBQUNELG9CQUFjLENBQUMsUUFBUSxFQUFFLFVBQVUsRUFBRSxLQUFLLENBQUMsQ0FBQTtLQUM1QztHQUNGOztBQUVELFNBQU8sSUFBSSxDQUFBO0NBQ1osQ0FBQTs7QUFFRCxJQUFNLHdCQUF3QixHQUFHLFNBQTNCLHdCQUF3QixDQUFJLFNBQVMsRUFBRSxVQUFVLEVBQUs7QUFBRSxTQUFPLHFCQUFxQixDQUFDLFNBQVMsRUFBRSxVQUFVLENBQUMsSUFBSSxJQUFJLENBQUE7Q0FBRSxDQUFBOztBQUUzSCxJQUFNLHFCQUFxQixHQUFHLFNBQXhCLHFCQUFxQixDQUFJLE1BQU0sRUFBSztBQUFFLGVBQVcsTUFBTSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBRTtDQUFFLENBQUE7O1FBRW5FLHdCQUF3QixHQUF4Qix3QkFBd0I7UUFBRSxxQkFBcUIsR0FBckIscUJBQXFCO1FBQUUscUJBQXFCLEdBQXJCLHFCQUFxQiIsImZpbGUiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS0xLjM4LjIvb3V0L2FwcC9ub2RlX21vZHVsZXMvYXV0b2NvbXBsZXRlLXBsdXMvbGliL3Njb3BlLWhlbHBlcnMuanMiLCJzb3VyY2VzQ29udGVudCI6WyIndXNlIGJhYmVsJ1xuXG5pbXBvcnQgc2xpY2sgZnJvbSAnYXRvbS1zbGljaydcblxuY29uc3QgRXNjYXBlQ2hhcmFjdGVyUmVnZXggPSAvWy0hXCIjJCUmJyorLC86Oz0/QHxefigpPD57fVtcXF1dL2dcblxuY29uc3QgY2FjaGVkTWF0Y2hlc0J5U2VsZWN0b3IgPSB7fVxuXG5jb25zdCBnZXRDYWNoZWRNYXRjaCA9IChzZWxlY3Rvciwgc2NvcGVDaGFpbikgPT4ge1xuICBjb25zdCBjYWNoZWRNYXRjaGVzQnlTY29wZUNoYWluID0gY2FjaGVkTWF0Y2hlc0J5U2VsZWN0b3Jbc2VsZWN0b3JdXG4gIGlmIChjYWNoZWRNYXRjaGVzQnlTY29wZUNoYWluKSB7XG4gICAgcmV0dXJuIGNhY2hlZE1hdGNoZXNCeVNjb3BlQ2hhaW5bc2NvcGVDaGFpbl1cbiAgfVxufVxuXG5jb25zdCBzZXRDYWNoZWRNYXRjaCA9IChzZWxlY3Rvciwgc2NvcGVDaGFpbiwgbWF0Y2gpID0+IHtcbiAgbGV0IGNhY2hlZE1hdGNoZXNCeVNjb3BlQ2hhaW4gPSBjYWNoZWRNYXRjaGVzQnlTZWxlY3RvcltzZWxlY3Rvcl1cbiAgaWYgKCFjYWNoZWRNYXRjaGVzQnlTY29wZUNoYWluKSB7XG4gICAgY2FjaGVkTWF0Y2hlc0J5U2NvcGVDaGFpbiA9IHt9XG4gICAgY2FjaGVkTWF0Y2hlc0J5U2VsZWN0b3Jbc2VsZWN0b3JdID0gY2FjaGVkTWF0Y2hlc0J5U2NvcGVDaGFpblxuICB9XG4gIGNhY2hlZE1hdGNoZXNCeVNjb3BlQ2hhaW5bc2NvcGVDaGFpbl0gPSBtYXRjaFxuICBjYWNoZWRNYXRjaGVzQnlTY29wZUNoYWluW3Njb3BlQ2hhaW5dXG59XG5cbmNvbnN0IHBhcnNlU2NvcGVDaGFpbiA9IChzY29wZUNoYWluKSA9PiB7XG4gIHNjb3BlQ2hhaW4gPSBzY29wZUNoYWluLnJlcGxhY2UoRXNjYXBlQ2hhcmFjdGVyUmVnZXgsIChtYXRjaCkgPT4ge1xuICAgIHJldHVybiAnXFxcXCcgKyBtYXRjaFswXVxuICB9KVxuXG4gIGNvbnN0IHBhcnNlZCA9IHNsaWNrLnBhcnNlKHNjb3BlQ2hhaW4pWzBdXG4gIGlmICghcGFyc2VkIHx8IHBhcnNlZC5sZW5ndGggPT09IDApIHtcbiAgICByZXR1cm4gW11cbiAgfVxuXG4gIGNvbnN0IHJlc3VsdCA9IFtdXG4gIGZvciAobGV0IGkgPSAwOyBpIDwgcGFyc2VkLmxlbmd0aDsgaSsrKSB7XG4gICAgcmVzdWx0LnB1c2gocGFyc2VkW2ldKVxuICB9XG5cbiAgcmV0dXJuIHJlc3VsdFxufVxuXG5jb25zdCBzZWxlY3RvckZvclNjb3BlQ2hhaW4gPSAoc2VsZWN0b3JzLCBzY29wZUNoYWluKSA9PiB7XG4gIGZvciAobGV0IGkgPSAwOyBpIDwgc2VsZWN0b3JzLmxlbmd0aDsgaSsrKSB7XG4gICAgY29uc3Qgc2VsZWN0b3IgPSBzZWxlY3RvcnNbaV1cbiAgICBjb25zdCBjYWNoZWRNYXRjaCA9IGdldENhY2hlZE1hdGNoKHNlbGVjdG9yLCBzY29wZUNoYWluKVxuICAgIGlmIChjYWNoZWRNYXRjaCAhPSBudWxsKSB7XG4gICAgICBpZiAoY2FjaGVkTWF0Y2gpIHtcbiAgICAgICAgcmV0dXJuIHNlbGVjdG9yXG4gICAgICB9IGVsc2Uge1xuICAgICAgICBjb250aW51ZVxuICAgICAgfVxuICAgIH0gZWxzZSB7XG4gICAgICBjb25zdCBzY29wZXMgPSBwYXJzZVNjb3BlQ2hhaW4oc2NvcGVDaGFpbilcbiAgICAgIHdoaWxlIChzY29wZXMubGVuZ3RoID4gMCkge1xuICAgICAgICBpZiAoc2VsZWN0b3IubWF0Y2hlcyhzY29wZXMpKSB7XG4gICAgICAgICAgc2V0Q2FjaGVkTWF0Y2goc2VsZWN0b3IsIHNjb3BlQ2hhaW4sIHRydWUpXG4gICAgICAgICAgcmV0dXJuIHNlbGVjdG9yXG4gICAgICAgIH1cbiAgICAgICAgc2NvcGVzLnBvcCgpXG4gICAgICB9XG4gICAgICBzZXRDYWNoZWRNYXRjaChzZWxlY3Rvciwgc2NvcGVDaGFpbiwgZmFsc2UpXG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIG51bGxcbn1cblxuY29uc3Qgc2VsZWN0b3JzTWF0Y2hTY29wZUNoYWluID0gKHNlbGVjdG9ycywgc2NvcGVDaGFpbikgPT4geyByZXR1cm4gc2VsZWN0b3JGb3JTY29wZUNoYWluKHNlbGVjdG9ycywgc2NvcGVDaGFpbikgIT0gbnVsbCB9XG5cbmNvbnN0IGJ1aWxkU2NvcGVDaGFpblN0cmluZyA9IChzY29wZXMpID0+IHsgcmV0dXJuIGAuJHtzY29wZXMuam9pbignIC4nKX1gIH1cblxuZXhwb3J0IHsgc2VsZWN0b3JzTWF0Y2hTY29wZUNoYWluLCBzZWxlY3RvckZvclNjb3BlQ2hhaW4sIGJ1aWxkU2NvcGVDaGFpblN0cmluZyB9XG4iXX0=