//===-- AMDGPURegAsmNames.inc - Register asm names ----------*- C++ -*-----===//

#ifdef AMDGPU_REG_ASM_NAMES

static const char *const VGPR32RegNames[] = {
    "v0",   "v1",   "v2",   "v3",   "v4",   "v5",   "v6",   "v7",   "v8",
    "v9",   "v10",  "v11",  "v12",  "v13",  "v14",  "v15",  "v16",  "v17",
    "v18",  "v19",  "v20",  "v21",  "v22",  "v23",  "v24",  "v25",  "v26",
    "v27",  "v28",  "v29",  "v30",  "v31",  "v32",  "v33",  "v34",  "v35",
    "v36",  "v37",  "v38",  "v39",  "v40",  "v41",  "v42",  "v43",  "v44",
    "v45",  "v46",  "v47",  "v48",  "v49",  "v50",  "v51",  "v52",  "v53",
    "v54",  "v55",  "v56",  "v57",  "v58",  "v59",  "v60",  "v61",  "v62",
    "v63",  "v64",  "v65",  "v66",  "v67",  "v68",  "v69",  "v70",  "v71",
    "v72",  "v73",  "v74",  "v75",  "v76",  "v77",  "v78",  "v79",  "v80",
    "v81",  "v82",  "v83",  "v84",  "v85",  "v86",  "v87",  "v88",  "v89",
    "v90",  "v91",  "v92",  "v93",  "v94",  "v95",  "v96",  "v97",  "v98",
    "v99",  "v100", "v101", "v102", "v103", "v104", "v105", "v106", "v107",
    "v108", "v109", "v110", "v111", "v112", "v113", "v114", "v115", "v116",
    "v117", "v118", "v119", "v120", "v121", "v122", "v123", "v124", "v125",
    "v126", "v127", "v128", "v129", "v130", "v131", "v132", "v133", "v134",
    "v135", "v136", "v137", "v138", "v139", "v140", "v141", "v142", "v143",
    "v144", "v145", "v146", "v147", "v148", "v149", "v150", "v151", "v152",
    "v153", "v154", "v155", "v156", "v157", "v158", "v159", "v160", "v161",
    "v162", "v163", "v164", "v165", "v166", "v167", "v168", "v169", "v170",
    "v171", "v172", "v173", "v174", "v175", "v176", "v177", "v178", "v179",
    "v180", "v181", "v182", "v183", "v184", "v185", "v186", "v187", "v188",
    "v189", "v190", "v191", "v192", "v193", "v194", "v195", "v196", "v197",
    "v198", "v199", "v200", "v201", "v202", "v203", "v204", "v205", "v206",
    "v207", "v208", "v209", "v210", "v211", "v212", "v213", "v214", "v215",
    "v216", "v217", "v218", "v219", "v220", "v221", "v222", "v223", "v224",
    "v225", "v226", "v227", "v228", "v229", "v230", "v231", "v232", "v233",
    "v234", "v235", "v236", "v237", "v238", "v239", "v240", "v241", "v242",
    "v243", "v244", "v245", "v246", "v247", "v248", "v249", "v250", "v251",
    "v252", "v253", "v254", "v255"
};

static const char *const SGPR32RegNames[] = {
    "s0",   "s1",   "s2",   "s3",   "s4",  "s5",  "s6",  "s7",  "s8",  "s9",
    "s10",  "s11",  "s12",  "s13",  "s14", "s15", "s16", "s17", "s18", "s19",
    "s20",  "s21",  "s22",  "s23",  "s24", "s25", "s26", "s27", "s28", "s29",
    "s30",  "s31",  "s32",  "s33",  "s34", "s35", "s36", "s37", "s38", "s39",
    "s40",  "s41",  "s42",  "s43",  "s44", "s45", "s46", "s47", "s48", "s49",
    "s50",  "s51",  "s52",  "s53",  "s54", "s55", "s56", "s57", "s58", "s59",
    "s60",  "s61",  "s62",  "s63",  "s64", "s65", "s66", "s67", "s68", "s69",
    "s70",  "s71",  "s72",  "s73",  "s74", "s75", "s76", "s77", "s78", "s79",
    "s80",  "s81",  "s82",  "s83",  "s84", "s85", "s86", "s87", "s88", "s89",
    "s90",  "s91",  "s92",  "s93",  "s94", "s95", "s96", "s97", "s98", "s99",
    "s100", "s101", "s102", "s103", "s104", "s105"
};

static const char *const VGPR64RegNames[] = {
    "v[0:1]",     "v[1:2]",     "v[2:3]",     "v[3:4]",     "v[4:5]",
    "v[5:6]",     "v[6:7]",     "v[7:8]",     "v[8:9]",     "v[9:10]",
    "v[10:11]",   "v[11:12]",   "v[12:13]",   "v[13:14]",   "v[14:15]",
    "v[15:16]",   "v[16:17]",   "v[17:18]",   "v[18:19]",   "v[19:20]",
    "v[20:21]",   "v[21:22]",   "v[22:23]",   "v[23:24]",   "v[24:25]",
    "v[25:26]",   "v[26:27]",   "v[27:28]",   "v[28:29]",   "v[29:30]",
    "v[30:31]",   "v[31:32]",   "v[32:33]",   "v[33:34]",   "v[34:35]",
    "v[35:36]",   "v[36:37]",   "v[37:38]",   "v[38:39]",   "v[39:40]",
    "v[40:41]",   "v[41:42]",   "v[42:43]",   "v[43:44]",   "v[44:45]",
    "v[45:46]",   "v[46:47]",   "v[47:48]",   "v[48:49]",   "v[49:50]",
    "v[50:51]",   "v[51:52]",   "v[52:53]",   "v[53:54]",   "v[54:55]",
    "v[55:56]",   "v[56:57]",   "v[57:58]",   "v[58:59]",   "v[59:60]",
    "v[60:61]",   "v[61:62]",   "v[62:63]",   "v[63:64]",   "v[64:65]",
    "v[65:66]",   "v[66:67]",   "v[67:68]",   "v[68:69]",   "v[69:70]",
    "v[70:71]",   "v[71:72]",   "v[72:73]",   "v[73:74]",   "v[74:75]",
    "v[75:76]",   "v[76:77]",   "v[77:78]",   "v[78:79]",   "v[79:80]",
    "v[80:81]",   "v[81:82]",   "v[82:83]",   "v[83:84]",   "v[84:85]",
    "v[85:86]",   "v[86:87]",   "v[87:88]",   "v[88:89]",   "v[89:90]",
    "v[90:91]",   "v[91:92]",   "v[92:93]",   "v[93:94]",   "v[94:95]",
    "v[95:96]",   "v[96:97]",   "v[97:98]",   "v[98:99]",   "v[99:100]",
    "v[100:101]", "v[101:102]", "v[102:103]", "v[103:104]", "v[104:105]",
    "v[105:106]", "v[106:107]", "v[107:108]", "v[108:109]", "v[109:110]",
    "v[110:111]", "v[111:112]", "v[112:113]", "v[113:114]", "v[114:115]",
    "v[115:116]", "v[116:117]", "v[117:118]", "v[118:119]", "v[119:120]",
    "v[120:121]", "v[121:122]", "v[122:123]", "v[123:124]", "v[124:125]",
    "v[125:126]", "v[126:127]", "v[127:128]", "v[128:129]", "v[129:130]",
    "v[130:131]", "v[131:132]", "v[132:133]", "v[133:134]", "v[134:135]",
    "v[135:136]", "v[136:137]", "v[137:138]", "v[138:139]", "v[139:140]",
    "v[140:141]", "v[141:142]", "v[142:143]", "v[143:144]", "v[144:145]",
    "v[145:146]", "v[146:147]", "v[147:148]", "v[148:149]", "v[149:150]",
    "v[150:151]", "v[151:152]", "v[152:153]", "v[153:154]", "v[154:155]",
    "v[155:156]", "v[156:157]", "v[157:158]", "v[158:159]", "v[159:160]",
    "v[160:161]", "v[161:162]", "v[162:163]", "v[163:164]", "v[164:165]",
    "v[165:166]", "v[166:167]", "v[167:168]", "v[168:169]", "v[169:170]",
    "v[170:171]", "v[171:172]", "v[172:173]", "v[173:174]", "v[174:175]",
    "v[175:176]", "v[176:177]", "v[177:178]", "v[178:179]", "v[179:180]",
    "v[180:181]", "v[181:182]", "v[182:183]", "v[183:184]", "v[184:185]",
    "v[185:186]", "v[186:187]", "v[187:188]", "v[188:189]", "v[189:190]",
    "v[190:191]", "v[191:192]", "v[192:193]", "v[193:194]", "v[194:195]",
    "v[195:196]", "v[196:197]", "v[197:198]", "v[198:199]", "v[199:200]",
    "v[200:201]", "v[201:202]", "v[202:203]", "v[203:204]", "v[204:205]",
    "v[205:206]", "v[206:207]", "v[207:208]", "v[208:209]", "v[209:210]",
    "v[210:211]", "v[211:212]", "v[212:213]", "v[213:214]", "v[214:215]",
    "v[215:216]", "v[216:217]", "v[217:218]", "v[218:219]", "v[219:220]",
    "v[220:221]", "v[221:222]", "v[222:223]", "v[223:224]", "v[224:225]",
    "v[225:226]", "v[226:227]", "v[227:228]", "v[228:229]", "v[229:230]",
    "v[230:231]", "v[231:232]", "v[232:233]", "v[233:234]", "v[234:235]",
    "v[235:236]", "v[236:237]", "v[237:238]", "v[238:239]", "v[239:240]",
    "v[240:241]", "v[241:242]", "v[242:243]", "v[243:244]", "v[244:245]",
    "v[245:246]", "v[246:247]", "v[247:248]", "v[248:249]", "v[249:250]",
    "v[250:251]", "v[251:252]", "v[252:253]", "v[253:254]", "v[254:255]"
};

static const char *const VGPR96RegNames[] = {
    "v[0:2]",     "v[1:3]",     "v[2:4]",     "v[3:5]",     "v[4:6]",
    "v[5:7]",     "v[6:8]",     "v[7:9]",     "v[8:10]",    "v[9:11]",
    "v[10:12]",   "v[11:13]",   "v[12:14]",   "v[13:15]",   "v[14:16]",
    "v[15:17]",   "v[16:18]",   "v[17:19]",   "v[18:20]",   "v[19:21]",
    "v[20:22]",   "v[21:23]",   "v[22:24]",   "v[23:25]",   "v[24:26]",
    "v[25:27]",   "v[26:28]",   "v[27:29]",   "v[28:30]",   "v[29:31]",
    "v[30:32]",   "v[31:33]",   "v[32:34]",   "v[33:35]",   "v[34:36]",
    "v[35:37]",   "v[36:38]",   "v[37:39]",   "v[38:40]",   "v[39:41]",
    "v[40:42]",   "v[41:43]",   "v[42:44]",   "v[43:45]",   "v[44:46]",
    "v[45:47]",   "v[46:48]",   "v[47:49]",   "v[48:50]",   "v[49:51]",
    "v[50:52]",   "v[51:53]",   "v[52:54]",   "v[53:55]",   "v[54:56]",
    "v[55:57]",   "v[56:58]",   "v[57:59]",   "v[58:60]",   "v[59:61]",
    "v[60:62]",   "v[61:63]",   "v[62:64]",   "v[63:65]",   "v[64:66]",
    "v[65:67]",   "v[66:68]",   "v[67:69]",   "v[68:70]",   "v[69:71]",
    "v[70:72]",   "v[71:73]",   "v[72:74]",   "v[73:75]",   "v[74:76]",
    "v[75:77]",   "v[76:78]",   "v[77:79]",   "v[78:80]",   "v[79:81]",
    "v[80:82]",   "v[81:83]",   "v[82:84]",   "v[83:85]",   "v[84:86]",
    "v[85:87]",   "v[86:88]",   "v[87:89]",   "v[88:90]",   "v[89:91]",
    "v[90:92]",   "v[91:93]",   "v[92:94]",   "v[93:95]",   "v[94:96]",
    "v[95:97]",   "v[96:98]",   "v[97:99]",   "v[98:100]",  "v[99:101]",
    "v[100:102]", "v[101:103]", "v[102:104]", "v[103:105]", "v[104:106]",
    "v[105:107]", "v[106:108]", "v[107:109]", "v[108:110]", "v[109:111]",
    "v[110:112]", "v[111:113]", "v[112:114]", "v[113:115]", "v[114:116]",
    "v[115:117]", "v[116:118]", "v[117:119]", "v[118:120]", "v[119:121]",
    "v[120:122]", "v[121:123]", "v[122:124]", "v[123:125]", "v[124:126]",
    "v[125:127]", "v[126:128]", "v[127:129]", "v[128:130]", "v[129:131]",
    "v[130:132]", "v[131:133]", "v[132:134]", "v[133:135]", "v[134:136]",
    "v[135:137]", "v[136:138]", "v[137:139]", "v[138:140]", "v[139:141]",
    "v[140:142]", "v[141:143]", "v[142:144]", "v[143:145]", "v[144:146]",
    "v[145:147]", "v[146:148]", "v[147:149]", "v[148:150]", "v[149:151]",
    "v[150:152]", "v[151:153]", "v[152:154]", "v[153:155]", "v[154:156]",
    "v[155:157]", "v[156:158]", "v[157:159]", "v[158:160]", "v[159:161]",
    "v[160:162]", "v[161:163]", "v[162:164]", "v[163:165]", "v[164:166]",
    "v[165:167]", "v[166:168]", "v[167:169]", "v[168:170]", "v[169:171]",
    "v[170:172]", "v[171:173]", "v[172:174]", "v[173:175]", "v[174:176]",
    "v[175:177]", "v[176:178]", "v[177:179]", "v[178:180]", "v[179:181]",
    "v[180:182]", "v[181:183]", "v[182:184]", "v[183:185]", "v[184:186]",
    "v[185:187]", "v[186:188]", "v[187:189]", "v[188:190]", "v[189:191]",
    "v[190:192]", "v[191:193]", "v[192:194]", "v[193:195]", "v[194:196]",
    "v[195:197]", "v[196:198]", "v[197:199]", "v[198:200]", "v[199:201]",
    "v[200:202]", "v[201:203]", "v[202:204]", "v[203:205]", "v[204:206]",
    "v[205:207]", "v[206:208]", "v[207:209]", "v[208:210]", "v[209:211]",
    "v[210:212]", "v[211:213]", "v[212:214]", "v[213:215]", "v[214:216]",
    "v[215:217]", "v[216:218]", "v[217:219]", "v[218:220]", "v[219:221]",
    "v[220:222]", "v[221:223]", "v[222:224]", "v[223:225]", "v[224:226]",
    "v[225:227]", "v[226:228]", "v[227:229]", "v[228:230]", "v[229:231]",
    "v[230:232]", "v[231:233]", "v[232:234]", "v[233:235]", "v[234:236]",
    "v[235:237]", "v[236:238]", "v[237:239]", "v[238:240]", "v[239:241]",
    "v[240:242]", "v[241:243]", "v[242:244]", "v[243:245]", "v[244:246]",
    "v[245:247]", "v[246:248]", "v[247:249]", "v[248:250]", "v[249:251]",
    "v[250:252]", "v[251:253]", "v[252:254]", "v[253:255]"
};

static const char *const VGPR128RegNames[] = {
    "v[0:3]",     "v[1:4]",     "v[2:5]",     "v[3:6]",     "v[4:7]",
    "v[5:8]",     "v[6:9]",     "v[7:10]",    "v[8:11]",    "v[9:12]",
    "v[10:13]",   "v[11:14]",   "v[12:15]",   "v[13:16]",   "v[14:17]",
    "v[15:18]",   "v[16:19]",   "v[17:20]",   "v[18:21]",   "v[19:22]",
    "v[20:23]",   "v[21:24]",   "v[22:25]",   "v[23:26]",   "v[24:27]",
    "v[25:28]",   "v[26:29]",   "v[27:30]",   "v[28:31]",   "v[29:32]",
    "v[30:33]",   "v[31:34]",   "v[32:35]",   "v[33:36]",   "v[34:37]",
    "v[35:38]",   "v[36:39]",   "v[37:40]",   "v[38:41]",   "v[39:42]",
    "v[40:43]",   "v[41:44]",   "v[42:45]",   "v[43:46]",   "v[44:47]",
    "v[45:48]",   "v[46:49]",   "v[47:50]",   "v[48:51]",   "v[49:52]",
    "v[50:53]",   "v[51:54]",   "v[52:55]",   "v[53:56]",   "v[54:57]",
    "v[55:58]",   "v[56:59]",   "v[57:60]",   "v[58:61]",   "v[59:62]",
    "v[60:63]",   "v[61:64]",   "v[62:65]",   "v[63:66]",   "v[64:67]",
    "v[65:68]",   "v[66:69]",   "v[67:70]",   "v[68:71]",   "v[69:72]",
    "v[70:73]",   "v[71:74]",   "v[72:75]",   "v[73:76]",   "v[74:77]",
    "v[75:78]",   "v[76:79]",   "v[77:80]",   "v[78:81]",   "v[79:82]",
    "v[80:83]",   "v[81:84]",   "v[82:85]",   "v[83:86]",   "v[84:87]",
    "v[85:88]",   "v[86:89]",   "v[87:90]",   "v[88:91]",   "v[89:92]",
    "v[90:93]",   "v[91:94]",   "v[92:95]",   "v[93:96]",   "v[94:97]",
    "v[95:98]",   "v[96:99]",   "v[97:100]",  "v[98:101]",  "v[99:102]",
    "v[100:103]", "v[101:104]", "v[102:105]", "v[103:106]", "v[104:107]",
    "v[105:108]", "v[106:109]", "v[107:110]", "v[108:111]", "v[109:112]",
    "v[110:113]", "v[111:114]", "v[112:115]", "v[113:116]", "v[114:117]",
    "v[115:118]", "v[116:119]", "v[117:120]", "v[118:121]", "v[119:122]",
    "v[120:123]", "v[121:124]", "v[122:125]", "v[123:126]", "v[124:127]",
    "v[125:128]", "v[126:129]", "v[127:130]", "v[128:131]", "v[129:132]",
    "v[130:133]", "v[131:134]", "v[132:135]", "v[133:136]", "v[134:137]",
    "v[135:138]", "v[136:139]", "v[137:140]", "v[138:141]", "v[139:142]",
    "v[140:143]", "v[141:144]", "v[142:145]", "v[143:146]", "v[144:147]",
    "v[145:148]", "v[146:149]", "v[147:150]", "v[148:151]", "v[149:152]",
    "v[150:153]", "v[151:154]", "v[152:155]", "v[153:156]", "v[154:157]",
    "v[155:158]", "v[156:159]", "v[157:160]", "v[158:161]", "v[159:162]",
    "v[160:163]", "v[161:164]", "v[162:165]", "v[163:166]", "v[164:167]",
    "v[165:168]", "v[166:169]", "v[167:170]", "v[168:171]", "v[169:172]",
    "v[170:173]", "v[171:174]", "v[172:175]", "v[173:176]", "v[174:177]",
    "v[175:178]", "v[176:179]", "v[177:180]", "v[178:181]", "v[179:182]",
    "v[180:183]", "v[181:184]", "v[182:185]", "v[183:186]", "v[184:187]",
    "v[185:188]", "v[186:189]", "v[187:190]", "v[188:191]", "v[189:192]",
    "v[190:193]", "v[191:194]", "v[192:195]", "v[193:196]", "v[194:197]",
    "v[195:198]", "v[196:199]", "v[197:200]", "v[198:201]", "v[199:202]",
    "v[200:203]", "v[201:204]", "v[202:205]", "v[203:206]", "v[204:207]",
    "v[205:208]", "v[206:209]", "v[207:210]", "v[208:211]", "v[209:212]",
    "v[210:213]", "v[211:214]", "v[212:215]", "v[213:216]", "v[214:217]",
    "v[215:218]", "v[216:219]", "v[217:220]", "v[218:221]", "v[219:222]",
    "v[220:223]", "v[221:224]", "v[222:225]", "v[223:226]", "v[224:227]",
    "v[225:228]", "v[226:229]", "v[227:230]", "v[228:231]", "v[229:232]",
    "v[230:233]", "v[231:234]", "v[232:235]", "v[233:236]", "v[234:237]",
    "v[235:238]", "v[236:239]", "v[237:240]", "v[238:241]", "v[239:242]",
    "v[240:243]", "v[241:244]", "v[242:245]", "v[243:246]", "v[244:247]",
    "v[245:248]", "v[246:249]", "v[247:250]", "v[248:251]", "v[249:252]",
    "v[250:253]", "v[251:254]", "v[252:255]"
};

static const char *const VGPR256RegNames[] = {
    "v[0:7]",     "v[1:8]",     "v[2:9]",     "v[3:10]",    "v[4:11]",
    "v[5:12]",    "v[6:13]",    "v[7:14]",    "v[8:15]",    "v[9:16]",
    "v[10:17]",   "v[11:18]",   "v[12:19]",   "v[13:20]",   "v[14:21]",
    "v[15:22]",   "v[16:23]",   "v[17:24]",   "v[18:25]",   "v[19:26]",
    "v[20:27]",   "v[21:28]",   "v[22:29]",   "v[23:30]",   "v[24:31]",
    "v[25:32]",   "v[26:33]",   "v[27:34]",   "v[28:35]",   "v[29:36]",
    "v[30:37]",   "v[31:38]",   "v[32:39]",   "v[33:40]",   "v[34:41]",
    "v[35:42]",   "v[36:43]",   "v[37:44]",   "v[38:45]",   "v[39:46]",
    "v[40:47]",   "v[41:48]",   "v[42:49]",   "v[43:50]",   "v[44:51]",
    "v[45:52]",   "v[46:53]",   "v[47:54]",   "v[48:55]",   "v[49:56]",
    "v[50:57]",   "v[51:58]",   "v[52:59]",   "v[53:60]",   "v[54:61]",
    "v[55:62]",   "v[56:63]",   "v[57:64]",   "v[58:65]",   "v[59:66]",
    "v[60:67]",   "v[61:68]",   "v[62:69]",   "v[63:70]",   "v[64:71]",
    "v[65:72]",   "v[66:73]",   "v[67:74]",   "v[68:75]",   "v[69:76]",
    "v[70:77]",   "v[71:78]",   "v[72:79]",   "v[73:80]",   "v[74:81]",
    "v[75:82]",   "v[76:83]",   "v[77:84]",   "v[78:85]",   "v[79:86]",
    "v[80:87]",   "v[81:88]",   "v[82:89]",   "v[83:90]",   "v[84:91]",
    "v[85:92]",   "v[86:93]",   "v[87:94]",   "v[88:95]",   "v[89:96]",
    "v[90:97]",   "v[91:98]",   "v[92:99]",   "v[93:100]",  "v[94:101]",
    "v[95:102]",  "v[96:103]",  "v[97:104]",  "v[98:105]",  "v[99:106]",
    "v[100:107]", "v[101:108]", "v[102:109]", "v[103:110]", "v[104:111]",
    "v[105:112]", "v[106:113]", "v[107:114]", "v[108:115]", "v[109:116]",
    "v[110:117]", "v[111:118]", "v[112:119]", "v[113:120]", "v[114:121]",
    "v[115:122]", "v[116:123]", "v[117:124]", "v[118:125]", "v[119:126]",
    "v[120:127]", "v[121:128]", "v[122:129]", "v[123:130]", "v[124:131]",
    "v[125:132]", "v[126:133]", "v[127:134]", "v[128:135]", "v[129:136]",
    "v[130:137]", "v[131:138]", "v[132:139]", "v[133:140]", "v[134:141]",
    "v[135:142]", "v[136:143]", "v[137:144]", "v[138:145]", "v[139:146]",
    "v[140:147]", "v[141:148]", "v[142:149]", "v[143:150]", "v[144:151]",
    "v[145:152]", "v[146:153]", "v[147:154]", "v[148:155]", "v[149:156]",
    "v[150:157]", "v[151:158]", "v[152:159]", "v[153:160]", "v[154:161]",
    "v[155:162]", "v[156:163]", "v[157:164]", "v[158:165]", "v[159:166]",
    "v[160:167]", "v[161:168]", "v[162:169]", "v[163:170]", "v[164:171]",
    "v[165:172]", "v[166:173]", "v[167:174]", "v[168:175]", "v[169:176]",
    "v[170:177]", "v[171:178]", "v[172:179]", "v[173:180]", "v[174:181]",
    "v[175:182]", "v[176:183]", "v[177:184]", "v[178:185]", "v[179:186]",
    "v[180:187]", "v[181:188]", "v[182:189]", "v[183:190]", "v[184:191]",
    "v[185:192]", "v[186:193]", "v[187:194]", "v[188:195]", "v[189:196]",
    "v[190:197]", "v[191:198]", "v[192:199]", "v[193:200]", "v[194:201]",
    "v[195:202]", "v[196:203]", "v[197:204]", "v[198:205]", "v[199:206]",
    "v[200:207]", "v[201:208]", "v[202:209]", "v[203:210]", "v[204:211]",
    "v[205:212]", "v[206:213]", "v[207:214]", "v[208:215]", "v[209:216]",
    "v[210:217]", "v[211:218]", "v[212:219]", "v[213:220]", "v[214:221]",
    "v[215:222]", "v[216:223]", "v[217:224]", "v[218:225]", "v[219:226]",
    "v[220:227]", "v[221:228]", "v[222:229]", "v[223:230]", "v[224:231]",
    "v[225:232]", "v[226:233]", "v[227:234]", "v[228:235]", "v[229:236]",
    "v[230:237]", "v[231:238]", "v[232:239]", "v[233:240]", "v[234:241]",
    "v[235:242]", "v[236:243]", "v[237:244]", "v[238:245]", "v[239:246]",
    "v[240:247]", "v[241:248]", "v[242:249]", "v[243:250]", "v[244:251]",
    "v[245:252]", "v[246:253]", "v[247:254]", "v[248:255]"
};

static const char *const VGPR512RegNames[] = {
    "v[0:15]",    "v[1:16]",    "v[2:17]",    "v[3:18]",    "v[4:19]",
    "v[5:20]",    "v[6:21]",    "v[7:22]",    "v[8:23]",    "v[9:24]",
    "v[10:25]",   "v[11:26]",   "v[12:27]",   "v[13:28]",   "v[14:29]",
    "v[15:30]",   "v[16:31]",   "v[17:32]",   "v[18:33]",   "v[19:34]",
    "v[20:35]",   "v[21:36]",   "v[22:37]",   "v[23:38]",   "v[24:39]",
    "v[25:40]",   "v[26:41]",   "v[27:42]",   "v[28:43]",   "v[29:44]",
    "v[30:45]",   "v[31:46]",   "v[32:47]",   "v[33:48]",   "v[34:49]",
    "v[35:50]",   "v[36:51]",   "v[37:52]",   "v[38:53]",   "v[39:54]",
    "v[40:55]",   "v[41:56]",   "v[42:57]",   "v[43:58]",   "v[44:59]",
    "v[45:60]",   "v[46:61]",   "v[47:62]",   "v[48:63]",   "v[49:64]",
    "v[50:65]",   "v[51:66]",   "v[52:67]",   "v[53:68]",   "v[54:69]",
    "v[55:70]",   "v[56:71]",   "v[57:72]",   "v[58:73]",   "v[59:74]",
    "v[60:75]",   "v[61:76]",   "v[62:77]",   "v[63:78]",   "v[64:79]",
    "v[65:80]",   "v[66:81]",   "v[67:82]",   "v[68:83]",   "v[69:84]",
    "v[70:85]",   "v[71:86]",   "v[72:87]",   "v[73:88]",   "v[74:89]",
    "v[75:90]",   "v[76:91]",   "v[77:92]",   "v[78:93]",   "v[79:94]",
    "v[80:95]",   "v[81:96]",   "v[82:97]",   "v[83:98]",   "v[84:99]",
    "v[85:100]",  "v[86:101]",  "v[87:102]",  "v[88:103]",  "v[89:104]",
    "v[90:105]",  "v[91:106]",  "v[92:107]",  "v[93:108]",  "v[94:109]",
    "v[95:110]",  "v[96:111]",  "v[97:112]",  "v[98:113]",  "v[99:114]",
    "v[100:115]", "v[101:116]", "v[102:117]", "v[103:118]", "v[104:119]",
    "v[105:120]", "v[106:121]", "v[107:122]", "v[108:123]", "v[109:124]",
    "v[110:125]", "v[111:126]", "v[112:127]", "v[113:128]", "v[114:129]",
    "v[115:130]", "v[116:131]", "v[117:132]", "v[118:133]", "v[119:134]",
    "v[120:135]", "v[121:136]", "v[122:137]", "v[123:138]", "v[124:139]",
    "v[125:140]", "v[126:141]", "v[127:142]", "v[128:143]", "v[129:144]",
    "v[130:145]", "v[131:146]", "v[132:147]", "v[133:148]", "v[134:149]",
    "v[135:150]", "v[136:151]", "v[137:152]", "v[138:153]", "v[139:154]",
    "v[140:155]", "v[141:156]", "v[142:157]", "v[143:158]", "v[144:159]",
    "v[145:160]", "v[146:161]", "v[147:162]", "v[148:163]", "v[149:164]",
    "v[150:165]", "v[151:166]", "v[152:167]", "v[153:168]", "v[154:169]",
    "v[155:170]", "v[156:171]", "v[157:172]", "v[158:173]", "v[159:174]",
    "v[160:175]", "v[161:176]", "v[162:177]", "v[163:178]", "v[164:179]",
    "v[165:180]", "v[166:181]", "v[167:182]", "v[168:183]", "v[169:184]",
    "v[170:185]", "v[171:186]", "v[172:187]", "v[173:188]", "v[174:189]",
    "v[175:190]", "v[176:191]", "v[177:192]", "v[178:193]", "v[179:194]",
    "v[180:195]", "v[181:196]", "v[182:197]", "v[183:198]", "v[184:199]",
    "v[185:200]", "v[186:201]", "v[187:202]", "v[188:203]", "v[189:204]",
    "v[190:205]", "v[191:206]", "v[192:207]", "v[193:208]", "v[194:209]",
    "v[195:210]", "v[196:211]", "v[197:212]", "v[198:213]", "v[199:214]",
    "v[200:215]", "v[201:216]", "v[202:217]", "v[203:218]", "v[204:219]",
    "v[205:220]", "v[206:221]", "v[207:222]", "v[208:223]", "v[209:224]",
    "v[210:225]", "v[211:226]", "v[212:227]", "v[213:228]", "v[214:229]",
    "v[215:230]", "v[216:231]", "v[217:232]", "v[218:233]", "v[219:234]",
    "v[220:235]", "v[221:236]", "v[222:237]", "v[223:238]", "v[224:239]",
    "v[225:240]", "v[226:241]", "v[227:242]", "v[228:243]", "v[229:244]",
    "v[230:245]", "v[231:246]", "v[232:247]", "v[233:248]", "v[234:249]",
    "v[235:250]", "v[236:251]", "v[237:252]", "v[238:253]", "v[239:254]",
    "v[240:255]"
};

static const char *const SGPR64RegNames[] = {
    "s[0:1]",   "s[2:3]",   "s[4:5]",     "s[6:7]",     "s[8:9]",   "s[10:11]",
    "s[12:13]", "s[14:15]", "s[16:17]",   "s[18:19]",   "s[20:21]", "s[22:23]",
    "s[24:25]", "s[26:27]", "s[28:29]",   "s[30:31]",   "s[32:33]", "s[34:35]",
    "s[36:37]", "s[38:39]", "s[40:41]",   "s[42:43]",   "s[44:45]", "s[46:47]",
    "s[48:49]", "s[50:51]", "s[52:53]",   "s[54:55]",   "s[56:57]", "s[58:59]",
    "s[60:61]", "s[62:63]", "s[64:65]",   "s[66:67]",   "s[68:69]", "s[70:71]",
    "s[72:73]", "s[74:75]", "s[76:77]",   "s[78:79]",   "s[80:81]", "s[82:83]",
    "s[84:85]", "s[86:87]", "s[88:89]",   "s[90:91]",   "s[92:93]", "s[94:95]",
    "s[96:97]", "s[98:99]", "s[100:101]", "s[102:103]", "s[104:105]"
};

static const char *const SGPR128RegNames[] = {
    "s[0:3]",   "s[4:7]",     "s[8:11]",  "s[12:15]", "s[16:19]", "s[20:23]",
    "s[24:27]", "s[28:31]",   "s[32:35]", "s[36:39]", "s[40:43]", "s[44:47]",
    "s[48:51]", "s[52:55]",   "s[56:59]", "s[60:63]", "s[64:67]", "s[68:71]",
    "s[72:75]", "s[76:79]",   "s[80:83]", "s[84:87]", "s[88:91]", "s[92:95]",
    "s[96:99]", "s[100:103]"
};

static const char *const SGPR256RegNames[] = {
    "s[0:7]",   "s[4:11]",  "s[8:15]",  "s[12:19]", "s[16:23]",
    "s[20:27]", "s[24:31]", "s[28:35]", "s[32:39]", "s[36:43]",
    "s[40:47]", "s[44:51]", "s[48:55]", "s[52:59]", "s[56:63]",
    "s[60:67]", "s[64:71]", "s[68:75]", "s[72:79]", "s[76:83]",
    "s[80:87]", "s[84:91]", "s[88:95]", "s[92:99]", "s[96:103]"
};

static const char *const SGPR512RegNames[] = {
    "s[0:15]",  "s[4:19]",  "s[8:23]",  "s[12:27]", "s[16:31]",  "s[20:35]",
    "s[24:39]", "s[28:43]", "s[32:47]", "s[36:51]", "s[40:55]",  "s[44:59]",
    "s[48:63]", "s[52:67]", "s[56:71]", "s[60:75]", "s[64:79]",  "s[68:83]",
    "s[72:87]", "s[76:91]", "s[80:95]", "s[84:99]", "s[88:103]"
};

#endif
