/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.search;

import com.google.common.base.Strings;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import org.jetbrains.annotations.NotNull;

public class PyClassReferenceSearchExecutor
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        PyClass pyClass;
        if (queryParameters == null) {
            PyClassReferenceSearchExecutor.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            PyClassReferenceSearchExecutor.$$$reportNull$$$0(1);
        }
        if ((pyClass = PyUtil.as(queryParameters.getElementToSearch(), PyClass.class)) == null) {
            return;
        }
        ReadAction.run(() -> {
            String className = pyClass.getName();
            if (Strings.isNullOrEmpty((String)className)) {
                return;
            }
            PyFunction initMethod = pyClass.findMethodByName("__init__", false, null);
            if (initMethod == null) {
                return;
            }
            SearchScope searchScope = queryParameters.getEffectiveSearchScope();
            if (searchScope instanceof GlobalSearchScope) {
                searchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)searchScope), (FileType[])new FileType[]{PythonFileType.INSTANCE});
            }
            queryParameters.getOptimizer().searchWord(className, searchScope, (short)1, true, (PsiElement)initMethod);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/psi/search/PyClassReferenceSearchExecutor";
        objectArray[2] = "processQuery";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

