/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserModuleNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesBrowserFilePathNode
extends ChangesBrowserNode<FilePath> {
    public ChangesBrowserFilePathNode(FilePath userObject) {
        super(userObject);
    }

    @Override
    protected boolean isFile() {
        return !((FilePath)this.getUserObject()).isDirectory();
    }

    @Override
    protected boolean isDirectory() {
        return ((FilePath)this.getUserObject()).isDirectory() && this.isLeaf();
    }

    @Override
    public void render(ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        FilePath path = (FilePath)this.userObject;
        if (path.isDirectory() || !this.isLeaf()) {
            renderer.append(this.getRelativePath(path), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            if (!this.isLeaf()) {
                this.appendCount(renderer);
            }
        } else if (renderer.isShowFlatten()) {
            renderer.append(path.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.appendParentPath(renderer, path.getParentPath());
        } else {
            renderer.append(this.getRelativePath(path), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        renderer.setIcon(path.getFileType(), path.isDirectory() || !this.isLeaf());
    }

    @NotNull
    protected String getRelativePath(FilePath path) {
        String string = ChangesBrowserFilePathNode.getRelativePath(ChangesBrowserFilePathNode.safeCastToFilePath((ChangesBrowserNode)this.getParent()), path);
        if (string == null) {
            ChangesBrowserFilePathNode.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public String getTextPresentation() {
        return this.getRelativePath((FilePath)this.getUserObject());
    }

    @Override
    public String toString() {
        return FileUtil.toSystemDependentName((String)((FilePath)this.getUserObject()).getPath());
    }

    @Nullable
    public static FilePath safeCastToFilePath(ChangesBrowserNode node) {
        if (node instanceof ChangesBrowserModuleNode) {
            return ((ChangesBrowserModuleNode)node).getModuleRoot();
        }
        Object o = node.getUserObject();
        if (o instanceof FilePath) {
            return (FilePath)o;
        }
        if (o instanceof Change) {
            return ChangesUtil.getAfterPath((Change)((Change)o));
        }
        return null;
    }

    @NotNull
    public static String getRelativePath(@Nullable FilePath parent, @NotNull FilePath child2) {
        if (child2 == null) {
            ChangesBrowserFilePathNode.$$$reportNull$$$0(1);
        }
        boolean isLocal = !child2.isNonLocal();
        boolean caseSensitive = isLocal && SystemInfoRt.isFileSystemCaseSensitive;
        String result2 = parent != null ? FileUtil.getRelativePath((String)parent.getPath(), (String)child2.getPath(), (char)'/', (boolean)caseSensitive) : null;
        result2 = result2 == null ? child2.getPath() : result2;
        String string = isLocal ? FileUtil.toSystemDependentName((String)result2) : result2;
        if (string == null) {
            ChangesBrowserFilePathNode.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public int getSortWeight() {
        if (((FilePath)this.userObject).isDirectory()) {
            return 4;
        }
        return 5;
    }

    @Override
    public int compareUserObjects(FilePath o2) {
        return ((FilePath)this.getUserObject()).getPath().compareToIgnoreCase(o2.getPath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserFilePathNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserFilePathNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

