/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions.suppress;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SequentialTask;
import com.intellij.util.ThrowableRunnable;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressActionSequentialTask
implements SequentialTask {
    private static final Logger LOG = Logger.getInstance(SuppressActionSequentialTask.class);
    private final SuppressableInspectionTreeNode[] myNodesToSuppress;
    @NotNull
    private final SuppressIntentionAction mySuppressAction;
    @NotNull
    private final InspectionToolWrapper myWrapper;
    private int myCount;

    public SuppressActionSequentialTask(@NotNull SuppressableInspectionTreeNode[] nodesToSuppress, @NotNull SuppressIntentionAction suppressAction, @NotNull InspectionToolWrapper wrapper2) {
        if (nodesToSuppress == null) {
            SuppressActionSequentialTask.$$$reportNull$$$0(0);
        }
        if (suppressAction == null) {
            SuppressActionSequentialTask.$$$reportNull$$$0(1);
        }
        if (wrapper2 == null) {
            SuppressActionSequentialTask.$$$reportNull$$$0(2);
        }
        this.myCount = 0;
        this.myNodesToSuppress = nodesToSuppress;
        this.mySuppressAction = suppressAction;
        this.myWrapper = wrapper2;
    }

    public boolean iteration() {
        SuppressableInspectionTreeNode node = this.myNodesToSuppress[this.myCount++];
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setFraction((double)this.myCount / (double)this.myNodesToSuppress.length);
        }
        Pair<PsiElement, CommonProblemDescriptor> content = node.getSuppressContent();
        if (content.first != null) {
            PsiElement element = (PsiElement)content.first;
            RefEntity refEntity = node.getElement();
            LOG.assertTrue(refEntity != null);
            this.suppress(element, (CommonProblemDescriptor)content.second, this.mySuppressAction, refEntity, this.myWrapper, node);
        }
        return false;
    }

    public boolean isDone() {
        return this.myCount > this.myNodesToSuppress.length - 1;
    }

    public void stop() {
    }

    public void prepare() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setText(InspectionsBundle.message((String)"inspection.action.suppress", (Object[])new Object[]{this.myWrapper.getDisplayName()}));
        }
    }

    private void suppress(@NotNull PsiElement element, @Nullable CommonProblemDescriptor descriptor, @NotNull SuppressIntentionAction action, @NotNull RefEntity refEntity, InspectionToolWrapper wrapper2, @NotNull SuppressableInspectionTreeNode node) {
        if (element == null) {
            SuppressActionSequentialTask.$$$reportNull$$$0(3);
        }
        if (action == null) {
            SuppressActionSequentialTask.$$$reportNull$$$0(4);
        }
        if (refEntity == null) {
            SuppressActionSequentialTask.$$$reportNull$$$0(5);
        }
        if (node == null) {
            SuppressActionSequentialTask.$$$reportNull$$$0(6);
        }
        if (action instanceof SuppressIntentionActionFromFix && !(descriptor instanceof ProblemDescriptor)) {
            LOG.info("local suppression fix for specific problem descriptor:  " + wrapper2.getTool().getClass().getName());
        }
        Project project = element.getProject();
        try {
            PsiElement container = null;
            if (action instanceof SuppressIntentionActionFromFix) {
                container = ((SuppressIntentionActionFromFix)action).getContainer(element);
            }
            if (container == null) {
                container = element;
            }
            if (action.isAvailable(project, null, element)) {
                ThrowableRunnable runnable2 = () -> action.invoke(project, null, element);
                if (action.startInWriteAction()) {
                    WriteAction.run((ThrowableRunnable)runnable2);
                } else {
                    runnable2.run();
                }
            }
            Set<GlobalInspectionContextImpl> globalInspectionContexts = ((InspectionManagerEx)InspectionManager.getInstance((Project)element.getProject())).getRunningContexts();
            for (GlobalInspectionContextImpl context : globalInspectionContexts) {
                context.resolveElement(wrapper2.getTool(), container);
                if (descriptor == null) continue;
                context.getPresentation(wrapper2).suppressProblem(descriptor);
            }
        }
        catch (IncorrectOperationException e1) {
            LOG.error((Throwable)e1);
        }
        node.removeSuppressActionFromAvailable(this.mySuppressAction);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesToSuppress";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suppressAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/ui/actions/suppress/SuppressActionSequentialTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "suppress";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

