/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.common.collection.NullSafeSet;
import org.sejda.model.input.PdfSource;
import org.sejda.model.parameter.base.MultiplePdfSourceMultipleOutputParameters;
import org.sejda.model.pdf.page.PageRange;
import org.sejda.model.pdf.page.PageRangeSelection;
import org.sejda.model.pdf.page.PagesSelection;
import org.sejda.model.validation.constraint.NoIntersections;

@NoIntersections
public class AddBackPagesParameters
extends MultiplePdfSourceMultipleOutputParameters
implements PageRangeSelection,
PagesSelection {
    @Min(value=1L)
    private int step = 1;
    @Valid
    private final Set<PageRange> pageSelection = new NullSafeSet<PageRange>();
    @Valid
    @NotNull
    private PdfSource<?> backPagesSource;

    public PdfSource<?> getBackPagesSource() {
        return this.backPagesSource;
    }

    public void setBackPagesSource(PdfSource<?> backPagesSource) {
        this.backPagesSource = backPagesSource;
    }

    @Override
    public Set<PageRange> getPageSelection() {
        return Collections.unmodifiableSet(this.pageSelection);
    }

    public void addPageRange(PageRange range) {
        this.pageSelection.add(range);
    }

    public void addAllPageRanges(Collection<PageRange> ranges) {
        this.pageSelection.addAll(ranges);
    }

    @Override
    public Set<Integer> getPages(int totalNumberOfPage) {
        if (this.pageSelection.isEmpty()) {
            return new PageRange(1).getPages(totalNumberOfPage);
        }
        NullSafeSet<Integer> retSet = new NullSafeSet<Integer>();
        for (PageRange range : this.getPageSelection()) {
            retSet.addAll(range.getPages(totalNumberOfPage));
        }
        return retSet;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.backPagesSource).append(this.pageSelection).append(this.step).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AddBackPagesParameters)) {
            return false;
        }
        AddBackPagesParameters parameter = (AddBackPagesParameters)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append(this.backPagesSource, parameter.getBackPagesSource()).append(this.pageSelection, parameter.pageSelection).append(this.step, parameter.step).isEquals();
    }
}

