/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.queries.PhpVisibilityQuery;
import org.netbeans.modules.php.api.queries.Queries;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.refactoring.api.Scope;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class AnalysisUtils {
    private static final Logger LOGGER = Logger.getLogger(AnalysisUtils.class.getName());
    private static final String SERIALIZE_DELIMITER = "|";

    private AnalysisUtils() {
    }

    public static String serialize(List<String> input) {
        return StringUtils.implode(input, (String)SERIALIZE_DELIMITER);
    }

    public static List<String> deserialize(String input) {
        return StringUtils.explode((String)input, (String)SERIALIZE_DELIMITER);
    }

    public static Map<FileObject, Integer> countPhpFiles(Scope scope) {
        HashMap<FileObject, Integer> counts = new HashMap<FileObject, Integer>();
        for (FileObject root : scope.getSourceRoots()) {
            counts.put(root, AnalysisUtils.countPhpFiles(Queries.getVisibilityQuery((PhpModule)PhpModule.Factory.forFileObject((FileObject)root)), root, true));
        }
        for (FileObject file : scope.getFiles()) {
            counts.put(file, AnalysisUtils.countPhpFiles(Queries.getVisibilityQuery((PhpModule)PhpModule.Factory.forFileObject((FileObject)file)), file, true));
        }
        for (NonRecursiveFolder nonRecursiveFolder : scope.getFolders()) {
            FileObject folder = nonRecursiveFolder.getFolder();
            counts.put(folder, AnalysisUtils.countPhpFiles(Queries.getVisibilityQuery((PhpModule)PhpModule.Factory.forFileObject((FileObject)folder)), folder, false));
        }
        return counts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] computeLineMap(FileObject file, Charset decoder) {
        InputStreamReader in = null;
        ArrayList<Integer> lineLengthsTemp = new ArrayList<Integer>();
        int currentOffset = 0;
        lineLengthsTemp.add(0);
        lineLengthsTemp.add(0);
        try {
            int read;
            in = new InputStreamReader(file.getInputStream(), decoder);
            boolean wascr = false;
            boolean lineStart = true;
            while ((read = ((Reader)in).read()) != -1) {
                ++currentOffset;
                switch (read) {
                    case 13: {
                        wascr = true;
                        lineLengthsTemp.add(currentOffset);
                        lineLengthsTemp.add(currentOffset);
                        lineStart = true;
                        break;
                    }
                    case 10: {
                        if (wascr) {
                            wascr = false;
                            --currentOffset;
                            break;
                        }
                        lineLengthsTemp.add(currentOffset);
                        lineLengthsTemp.add(currentOffset);
                        wascr = false;
                        lineStart = true;
                        break;
                    }
                }
                if (lineStart && Character.isWhitespace(read)) {
                    lineLengthsTemp.set(lineLengthsTemp.size() - 2, currentOffset);
                    lineLengthsTemp.set(lineLengthsTemp.size() - 1, currentOffset);
                    continue;
                }
                if (Character.isWhitespace(read)) continue;
                lineLengthsTemp.set(lineLengthsTemp.size() - 1, currentOffset);
                lineStart = false;
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (in != null) {
                try {
                    ((Reader)in).close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        int[] lineOffsets = new int[lineLengthsTemp.size()];
        int i = 0;
        for (Integer o : lineLengthsTemp) {
            lineOffsets[i++] = o;
        }
        return lineOffsets;
    }

    private static int countPhpFiles(PhpVisibilityQuery visibilityQuery, FileObject fileObject, boolean recursive) {
        if (!visibilityQuery.isVisible(fileObject)) {
            LOGGER.log(Level.FINE, "Ignoring invisible file {0}", fileObject);
            return 0;
        }
        int count = 0;
        if (FileUtils.isPhpFile((FileObject)fileObject)) {
            ++count;
        }
        for (FileObject child : fileObject.getChildren()) {
            if (!visibilityQuery.isVisible(child)) {
                LOGGER.log(Level.FINE, "Ignoring invisible file {0}", child);
                continue;
            }
            if (FileUtils.isPhpFile((FileObject)child)) {
                ++count;
            }
            if (!recursive || !child.isFolder()) continue;
            count += AnalysisUtils.countPhpFiles(visibilityQuery, child, recursive);
        }
        return count;
    }

    public static int getValidInt(int min, int max, int target) {
        return Math.min(Math.max(min, target), max);
    }
}

