/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.support;

import java.io.File;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.runconfigs.RunConfigScript;
import org.netbeans.modules.php.project.runconfigs.validation.RunConfigScriptValidator;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.ConfigAction;
import org.netbeans.modules.php.project.ui.actions.support.DebugStarterFactory;
import org.netbeans.modules.php.project.ui.actions.support.FileRunner;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

class ConfigActionScript
extends ConfigAction {
    private final FileObject sourceRoot;

    protected ConfigActionScript(PhpProject project) {
        super(project);
        this.sourceRoot = ProjectPropertiesSupport.getSourcesDirectory(project);
        assert (this.sourceRoot != null);
    }

    @Override
    public boolean isProjectValid() {
        return this.isValid(RunConfigScriptValidator.validateConfigAction(RunConfigScript.forProject(this.project), true) == null);
    }

    @Override
    public boolean isFileValid() {
        return this.isValid(RunConfigScriptValidator.validateConfigAction(RunConfigScript.forProject(this.project), false) == null);
    }

    private boolean isValid(boolean valid) {
        if (!valid) {
            this.showCustomizer();
        }
        return valid;
    }

    @Override
    public boolean isRunFileEnabled(Lookup context) {
        FileObject file = CommandUtils.fileForContextOrSelectedNodes(context, this.sourceRoot);
        return file != null && FileUtils.isPhpFile((FileObject)file);
    }

    @Override
    public boolean isDebugFileEnabled(Lookup context) {
        if (DebugStarterFactory.getInstance() == null) {
            return false;
        }
        return this.isRunFileEnabled(context);
    }

    @Override
    public void runProject() {
        this.createFileRunner(null).run();
    }

    @Override
    public void debugProject() {
        this.createFileRunner(null).debug();
    }

    @Override
    public void runFile(Lookup context) {
        this.createFileRunner(context).run();
    }

    @Override
    public void debugFile(Lookup context) {
        this.createFileRunner(context).debug();
    }

    private File getStartFile(Lookup context) {
        FileObject file = context == null ? FileUtil.toFileObject((File)RunConfigScript.forProject(this.project).getIndexFile()) : CommandUtils.fileForContextOrSelectedNodes(context, this.sourceRoot);
        assert (file != null) : "Start file must be found";
        return FileUtil.toFile((FileObject)file);
    }

    private FileRunner createFileRunner(Lookup context) {
        RunConfigScript configScript = RunConfigScript.forProject(this.project);
        return new FileRunner(this.getStartFile(context)).project(this.project).command(configScript.getInterpreter()).workDir(configScript.getWorkDir()).phpArgs(configScript.getOptions()).fileArgs(configScript.getArguments());
    }
}

