/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.wizard;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.docker.api.DockerSupport;
import org.netbeans.modules.docker.ui.wizard.Bundle;
import org.netbeans.modules.docker.ui.wizard.Configuration;
import org.netbeans.modules.docker.ui.wizard.ConfigurationLinuxPanel;
import org.netbeans.modules.docker.ui.wizard.ConfigurationPanel;
import org.netbeans.modules.docker.ui.wizard.DockerConnectionPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class DockerConnectionVisual
extends JPanel
implements ChangeListener {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final DockerConnectionPanel panel;
    private final Configuration configPanel;
    private JLabel explanationLabel;
    private JPanel mainPanel;
    private JPanel southPanel;
    private JButton testButton;

    public DockerConnectionVisual(DockerConnectionPanel panel) {
        this.initComponents();
        this.panel = panel;
        if (DockerSupport.getDefault().isSocketSupported()) {
            this.configPanel = new ConfigurationLinuxPanel();
        } else {
            if (Utilities.isMac() || Utilities.isWindows()) {
                this.explanationLabel.setVisible(false);
            }
            this.configPanel = new ConfigurationPanel();
        }
        this.configPanel.addChangeListener(this);
        this.mainPanel.add((JPanel)((Object)this.configPanel));
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.changeSupport.fireChange();
    }

    public Configuration getConfiguration() {
        return this.configPanel;
    }

    public void setWaitingState(boolean wait) {
        JRootPane rootPane = this.getRootPane();
        this.configPanel.setInputEnabled(!wait);
        this.testButton.setEnabled(!wait);
        if (rootPane != null) {
            rootPane.setCursor(wait ? Cursor.getPredefinedCursor(3) : null);
        }
    }

    @Override
    public String getName() {
        return Bundle.MSG_Connection();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.southPanel = new JPanel();
        this.explanationLabel = new JLabel();
        this.testButton = new JButton();
        this.mainPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.explanationLabel, (String)NbBundle.getMessage(DockerConnectionVisual.class, (String)"DockerConnectionVisual.explanationLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.testButton, (String)NbBundle.getMessage(DockerConnectionVisual.class, (String)"DockerConnectionVisual.testButton.text"));
        this.testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DockerConnectionVisual.this.testButtonActionPerformed(evt);
            }
        });
        GroupLayout southPanelLayout = new GroupLayout(this.southPanel);
        this.southPanel.setLayout(southPanelLayout);
        southPanelLayout.setHorizontalGroup(southPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.explanationLabel, -1, 440, Short.MAX_VALUE).addGroup(southPanelLayout.createSequentialGroup().addComponent(this.testButton).addGap(0, 0, Short.MAX_VALUE)));
        southPanelLayout.setVerticalGroup(southPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, southPanelLayout.createSequentialGroup().addComponent(this.explanationLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.testButton).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainPanel, -1, 440, Short.MAX_VALUE).addComponent(this.southPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.mainPanel, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.southPanel, -1, -1, Short.MAX_VALUE)));
    }

    private void testButtonActionPerformed(ActionEvent evt) {
        this.panel.testConnection();
    }
}

