/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.projects;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.persistence.api.PersistenceLocation;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.support.SourceGroups;
import org.netbeans.modules.websvc.spi.jaxws.client.ProjectJAXWSClientSupport;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class J2SEProjectJAXWSClientSupport
extends ProjectJAXWSClientSupport {
    private Project project;
    private static final String WSDL_FOLDER = "wsdl";
    private static final String KEY_PROXY_HOST = "http.proxyHost";
    private static final String KEY_PROXY_PORT = "http.proxyPort";
    private static final String KEY_NON_PROXY_HOSTS = "http.nonProxyHosts";
    private static final String KEY_HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String KEY_HTTPS_PROXY_PORT = "https.proxyPort";
    private static final String KEY_HTTPS_NON_PROXY_HOSTS = "https.nonProxyHosts";
    private static final String HTTP_PROXY_HOST_OPTION = "-Dhttp.proxyHost";
    private static final String HTTP_PROXY_PORT_OPTION = "-Dhttp.proxyPort";
    private static final String HTTP_NON_PROXY_HOSTS_OPTION = "-Dhttp.nonProxyHosts";
    private static final String HTTPS_PROXY_HOST_OPTION = "-Dhttps.proxyHost";
    private static final String HTTPS_PROXY_PORT_OPTION = "-Dhttps.proxyPort";
    private static final String HTTPS_NON_PROXY_HOSTS_OPTION = "-Dhttps.nonProxyHosts";
    private static final String RUN_JVM_ARGS = "run.jvmargs";

    public J2SEProjectJAXWSClientSupport(Project project) {
        super(project, null);
        this.project = project;
    }

    public FileObject getWsdlFolder(boolean create) throws IOException {
        if (create) {
            FileObject metaInfDir = PersistenceLocation.createLocation((Project)this.project);
            if (metaInfDir != null) {
                return FileUtil.createFolder((FileObject)metaInfDir, (String)WSDL_FOLDER);
            }
        } else {
            FileObject metaInfDir = PersistenceLocation.getLocation((Project)this.project);
            if (metaInfDir != null) {
                return metaInfDir.getFileObject(WSDL_FOLDER);
            }
        }
        return null;
    }

    public String addServiceClient(String clientName, String wsdlUrl, String packageName, boolean isJsr109) {
        String serviceIdeName = super.addServiceClient(clientName, wsdlUrl, packageName, false);
        if (serviceIdeName != null) {
            this.addJVMOptions(clientName);
        }
        return serviceIdeName;
    }

    protected void addJaxWs20Library() {
        ClassPath classPath = null;
        SourceGroup[] sourceGroups = SourceGroups.getJavaSourceGroups((Project)this.project);
        if (sourceGroups != null && sourceGroups.length > 0) {
            FileObject srcRoot = sourceGroups[0].getRootFolder();
            ClassPath compileClassPath = ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/compile");
            ClassPath bootClassPath = ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/boot");
            classPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{compileClassPath, bootClassPath});
            try {
                this.addJaxWsApiEndorsed(srcRoot);
            }
            catch (IOException ex) {
                Logger.getLogger(J2SEProjectJAXWSClientSupport.class.getName()).log(Level.FINE, "Cannot add JAX-WS-ENDORSED classpath", ex);
            }
        }
        FileObject webServiceClass = null;
        if (classPath != null) {
            webServiceClass = classPath.findResource("javax/xml/ws/WebServiceFeature.class");
        }
        if (webServiceClass == null) {
            Library metroLib = LibraryManager.getDefault().getLibrary("metro");
            if (sourceGroups.length > 0 && metroLib != null) {
                try {
                    ProjectClassPathModifier.addLibraries((Library[])new Library[]{metroLib}, (FileObject)sourceGroups[0].getRootFolder(), (String)"classpath/compile");
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().log(ex.getMessage());
                }
                FileObject wscompileFO = null;
                if (classPath != null) {
                    wscompileFO = classPath.findResource("com/sun/xml/rpc/tools/ant/Wscompile.class");
                }
                if (wscompileFO != null) {
                    NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2SEProjectJAXWSClientSupport.class, (String)"MSG_RemoveJAX-RPC"), 2);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                }
            }
        }
    }

    private void addJVMOptions(final String clientName) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                EditableProperties ep = null;
                EditableProperties ep1 = null;
                try {
                    ep = WSUtils.getEditableProperties((Project)J2SEProjectJAXWSClientSupport.this.project, (String)"nbproject/project.properties");
                    ep1 = WSUtils.getEditableProperties((Project)J2SEProjectJAXWSClientSupport.this.project, (String)"nbproject/private/private.properties");
                    assert (ep != null);
                    assert (ep1 != null);
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
                boolean proxyModif = J2SEProjectJAXWSClientSupport.this.addJVMProxyOptions(ep);
                if (proxyModif) {
                    try {
                        WSUtils.storeEditableProperties((Project)J2SEProjectJAXWSClientSupport.this.project, (String)"nbproject/project.properties", (EditableProperties)ep);
                        ProjectManager.getDefault().saveProject(J2SEProjectJAXWSClientSupport.this.project);
                    }
                    catch (IOException ex) {
                        NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2SEProjectJAXWSClientSupport.class, (String)"MSG_ErrorSavingOnWSClientAdd", (Object)clientName, (Object)ex.getLocalizedMessage()), 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                    }
                }
            }
        });
    }

    private boolean addJVMProxyOptions(EditableProperties ep) {
        assert (ep != null);
        boolean modif = false;
        String proxyHost = System.getProperty(KEY_PROXY_HOST);
        if (proxyHost != null && proxyHost.length() > 0) {
            String proxyPort = System.getProperty(KEY_PROXY_PORT);
            if (proxyPort == null || proxyPort.length() == 0) {
                proxyPort = "8080";
            }
            String localHosts = "";
            localHosts = this.getDefaultNonProxyHosts();
            String jvmOptions = ep.getProperty(RUN_JVM_ARGS);
            if (jvmOptions == null || jvmOptions.length() == 0) {
                jvmOptions = "-Dhttp.proxyHost=" + proxyHost + " " + HTTP_PROXY_PORT_OPTION + "=" + proxyPort + " " + HTTP_NON_PROXY_HOSTS_OPTION + "=" + localHosts + " " + HTTPS_PROXY_HOST_OPTION + "=" + proxyHost + " " + HTTPS_PROXY_PORT_OPTION + "=" + proxyPort + " " + HTTPS_NON_PROXY_HOSTS_OPTION + "=" + localHosts;
                modif = true;
            } else {
                if (jvmOptions.indexOf(HTTP_PROXY_HOST_OPTION) < 0) {
                    jvmOptions = jvmOptions + " -Dhttp.proxyHost=" + proxyHost;
                    modif = true;
                }
                if (jvmOptions.indexOf(HTTP_PROXY_PORT_OPTION) < 0) {
                    jvmOptions = jvmOptions + " -Dhttp.proxyPort=" + proxyPort;
                    modif = true;
                }
                if (jvmOptions.indexOf(HTTP_NON_PROXY_HOSTS_OPTION) < 0) {
                    jvmOptions = jvmOptions + " -Dhttp.nonProxyHosts=" + localHosts;
                    modif = true;
                }
                if (jvmOptions.indexOf(HTTPS_PROXY_HOST_OPTION) < 0) {
                    jvmOptions = jvmOptions + " -Dhttps.proxyHost=" + proxyHost;
                    modif = true;
                }
                if (jvmOptions.indexOf(HTTPS_PROXY_PORT_OPTION) < 0) {
                    jvmOptions = jvmOptions + " -Dhttps.proxyPort=" + proxyPort;
                    modif = true;
                }
                if (jvmOptions.indexOf(HTTPS_NON_PROXY_HOSTS_OPTION) < 0) {
                    jvmOptions = jvmOptions + " -Dhttps.nonProxyHosts=" + localHosts;
                    modif = true;
                }
            }
            if (modif) {
                ep.setProperty(RUN_JVM_ARGS, jvmOptions);
            }
        }
        return modif;
    }

    public void addJaxWsApiEndorsed(FileObject srcRoot) throws IOException {
        WSUtils.addJaxWsApiEndorsed((Project)this.project, (FileObject)srcRoot);
    }

    private String getDefaultNonProxyHosts() {
        String nonProxy = "localhost|127.0.0.1";
        String localhost = "";
        try {
            localhost = InetAddress.getLocalHost().getHostName();
            if (!localhost.equals("localhost")) {
                nonProxy = nonProxy + "|" + localhost;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        try {
            String localhost2 = InetAddress.getLocalHost().getCanonicalHostName();
            if (!localhost2.equals("localhost") && !localhost2.equals(localhost)) {
                nonProxy = nonProxy + "|" + localhost2;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return nonProxy;
    }
}

