/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.http.AmazonHttpClient;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

class HttpClientFactory {
    HttpClientFactory() {
    }

    public HttpClient createHttpClient(ClientConfiguration config) {
        String userAgent = config.getUserAgent();
        if (!userAgent.equals(ClientConfiguration.DEFAULT_USER_AGENT)) {
            userAgent = userAgent + ", " + ClientConfiguration.DEFAULT_USER_AGENT;
        }
        BasicHttpParams httpClientParams = new BasicHttpParams();
        HttpProtocolParams.setUserAgent((HttpParams)httpClientParams, (String)userAgent);
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpClientParams, (int)config.getConnectionTimeout());
        HttpConnectionParams.setSoTimeout((HttpParams)httpClientParams, (int)config.getSocketTimeout());
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)httpClientParams, (boolean)true);
        HttpConnectionParams.setTcpNoDelay((HttpParams)httpClientParams, (boolean)true);
        int socketSendBufferSizeHint = config.getSocketBufferSizeHints()[0];
        int socketReceiveBufferSizeHint = config.getSocketBufferSizeHints()[1];
        if (socketSendBufferSizeHint > 0 || socketReceiveBufferSizeHint > 0) {
            HttpConnectionParams.setSocketBufferSize((HttpParams)httpClientParams, (int)Math.max(socketSendBufferSizeHint, socketReceiveBufferSizeHint));
        }
        ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager();
        connectionManager.setDefaultMaxPerRoute(config.getMaxConnections());
        connectionManager.setMaxTotal(config.getMaxConnections());
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager, (HttpParams)httpClientParams);
        String proxyHost = config.getProxyHost();
        int proxyPort = config.getProxyPort();
        if (proxyHost != null && proxyPort > 0) {
            AmazonHttpClient.log.info((Object)("Configuring Proxy. Proxy Host: " + proxyHost + " " + "Proxy Port: " + proxyPort));
            HttpHost proxyHttpHost = new HttpHost(proxyHost, proxyPort);
            httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxyHttpHost);
            String proxyUsername = config.getProxyUsername();
            String proxyPassword = config.getProxyPassword();
            String proxyDomain = config.getProxyDomain();
            String proxyWorkstation = config.getProxyWorkstation();
            if (proxyUsername != null && proxyPassword != null) {
                httpClient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new NTCredentials(proxyUsername, proxyPassword, proxyWorkstation, proxyDomain));
            }
        }
        return httpClient;
    }
}

