/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui.customizer;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.indent.project.api.Customizers;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.api.jstesting.JsTestingProviders;
import org.netbeans.modules.web.clientproject.api.platform.PlatformProvider;
import org.netbeans.modules.web.clientproject.ui.customizer.Bundle;
import org.netbeans.modules.web.clientproject.ui.customizer.ClientSideProjectProperties;
import org.netbeans.modules.web.clientproject.ui.customizer.RunPanel;
import org.netbeans.modules.web.clientproject.ui.customizer.SourcesPanel;
import org.netbeans.modules.web.common.ui.api.CssPreprocessorsUI;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.Lookup;

public class CompositePanelProviderImpl
implements ProjectCustomizer.CompositeCategoryProvider {
    public static final String SOURCES = "SOURCES";
    public static final String RUN = "RUN";
    private static final String LICENSE = "License";
    private final String name;

    public CompositePanelProviderImpl(String name) {
        this.name = name;
    }

    public ProjectCustomizer.Category createCategory(Lookup context) {
        ClientSideProject project = (ClientSideProject)context.lookup(ClientSideProject.class);
        assert (project != null);
        ProjectCustomizer.Category category = null;
        if (SOURCES.equals(this.name)) {
            category = ProjectCustomizer.Category.create((String)SOURCES, (String)Bundle.CompositePanelProviderImpl_sources_title(), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        } else if (RUN.equals(this.name)) {
            if (project.isJsLibrary()) {
                boolean runSupported = false;
                for (PlatformProvider platformProvider : project.getPlatformProviders()) {
                    List<String> actions;
                    ActionProvider actionProvider = platformProvider.getActionProvider((Project)project);
                    if (actionProvider == null || !(actions = Arrays.asList(actionProvider.getSupportedActions())).contains("run") && !actions.contains("debug")) continue;
                    runSupported = true;
                    break;
                }
                if (!runSupported) {
                    return null;
                }
            }
            category = ProjectCustomizer.Category.create((String)RUN, (String)Bundle.CompositePanelProviderImpl_run_title(), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        } else if (LICENSE.equals(this.name)) {
            category = ProjectCustomizer.Category.create((String)LICENSE, (String)Bundle.CompositePanelProviderImpl_license_title(), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        }
        assert (category != null) : "No category for name: " + this.name;
        return category;
    }

    public JComponent createComponent(ProjectCustomizer.Category category, Lookup context) {
        String categoryName = category.getName();
        ClientSideProject project = (ClientSideProject)context.lookup(ClientSideProject.class);
        assert (project != null);
        ClientSideProjectProperties uiProperties = (ClientSideProjectProperties)context.lookup(ClientSideProjectProperties.class);
        if (SOURCES.equals(categoryName)) {
            return new SourcesPanel(category, uiProperties);
        }
        if (RUN.equals(categoryName)) {
            return new RunPanel(category, uiProperties);
        }
        if (LICENSE.equals(categoryName)) {
            return project.is.createLicenseHeaderCustomizerPanel(category, uiProperties.getLicenseSupport());
        }
        assert (false) : "No component found for " + category.getDisplayName();
        return new JPanel();
    }

    public static CompositePanelProviderImpl createSources() {
        return new CompositePanelProviderImpl(SOURCES);
    }

    public static ProjectCustomizer.CompositeCategoryProvider createCssPreprocessors() {
        return CssPreprocessorsUI.getDefault().createCustomizer();
    }

    public static CompositePanelProviderImpl createRunConfigs() {
        return new CompositePanelProviderImpl(RUN);
    }

    public static ProjectCustomizer.CompositeCategoryProvider createJsTesting() {
        return JsTestingProviders.getDefault().createCustomizer();
    }

    public static ProjectCustomizer.CompositeCategoryProvider createLicense() {
        return new CompositePanelProviderImpl(LICENSE);
    }

    public static ProjectCustomizer.CompositeCategoryProvider createFormatting() {
        return Customizers.createFormattingCategoryProvider(Collections.singletonMap("allowedMimeTypes", "text/html,text/css,text/javascript,text/x-json"));
    }
}

