/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.editor.completion.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.BadLocationException;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappings;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.ManyToMany;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.ManyToOne;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.OneToMany;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.OneToOne;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Table;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.editor.completion.AnnotationUtils;
import org.netbeans.modules.j2ee.persistence.editor.completion.CCParser;
import org.netbeans.modules.j2ee.persistence.editor.completion.CompletionContextResolver;
import org.netbeans.modules.j2ee.persistence.editor.completion.JPACodeCompletionProvider;
import org.netbeans.modules.j2ee.persistence.editor.completion.JPACompletionItem;
import org.netbeans.modules.j2ee.persistence.editor.completion.db.Catalog;
import org.netbeans.modules.j2ee.persistence.editor.completion.db.DBMetaDataProvider;
import org.netbeans.modules.j2ee.persistence.editor.completion.db.DBMetaDataUtils;
import org.netbeans.modules.j2ee.persistence.editor.completion.db.Schema;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSource;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSourceProvider;
import org.netbeans.modules.j2ee.persistence.wizard.jpacontroller.JpaControllerUtil;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class DBCompletionContextResolver
implements CompletionContextResolver {
    private DatabaseConnection dbconn;
    private DBMetaDataProvider provider;
    private static final String[] ANNOTATION_QUERY_TYPES = new String[]{"Table", "SecondaryTable", "Column", "PrimaryKeyJoinColumn", "JoinColumn", "JoinTable", "PersistenceUnit", "PersistenceContext", "ManyToMany", "Index"};
    private static final String PERSISTENCE_PKG = "javax.persistence";
    private static final boolean DEBUG = Boolean.getBoolean("debug." + DBCompletionContextResolver.class.getName());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List resolve(JPACodeCompletionProvider.Context ctx) {
        ArrayList result = new ResultItemsFilterList(ctx);
        CCParser.CC parsedNN = ctx.getParsedAnnotation();
        if (parsedNN == null) {
            return result;
        }
        CCParser.NNAttr nnattr = parsedNN.getAttributeForOffset(ctx.getCompletionOffset());
        if (nnattr == null) {
            return result;
        }
        String annotationName = parsedNN.getName();
        if (annotationName == null) {
            return result;
        }
        try {
            int index = this.getAnnotationIndex(annotationName);
            if (index == 6 || index == 7) {
                this.completePersistenceUnitContext(ctx, parsedNN, nnattr, result);
            } else if (index != -1) {
                this.dbconn = this.findDatabaseConnection(ctx);
                if (this.dbconn == null) {
                    ErrorManager.getDefault().log("No Database Connection.");
                    return result;
                }
                Connection conn = this.dbconn.getJDBCConnection();
                if (conn == null) {
                    result = new ArrayList();
                    result.add(new JPACompletionItem.NoConnectionElementItem(this.dbconn));
                    return result;
                }
                this.provider = this.getDBMetadataProvider(this.dbconn, conn);
            }
            if (this.provider == null) return result;
            switch (index) {
                case 0: {
                    this.completeTable(parsedNN, nnattr, result, false);
                    return result;
                }
                case 1: 
                case 5: {
                    this.completeTable(parsedNN, nnattr, result, true);
                    return result;
                }
                case 2: {
                    this.completeColumn(ctx, parsedNN, nnattr, result);
                    return result;
                }
                case 3: {
                    this.completePrimaryKeyJoinColumn(ctx, parsedNN, nnattr, result);
                    return result;
                }
                case 4: {
                    this.completeJoinColumn(ctx, parsedNN, nnattr, result);
                    return result;
                }
                case 8: {
                    this.completeManyToMany(ctx, parsedNN, nnattr, result);
                }
                case 9: {
                    this.completeIndex(ctx, parsedNN, nnattr, result);
                    return result;
                }
            }
            return result;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return result;
    }

    private int getAnnotationIndex(String annotationName) {
        if (annotationName.startsWith(PERSISTENCE_PKG)) {
            annotationName = annotationName.substring(annotationName.lastIndexOf(46) + 1);
        }
        for (int i = 0; i < ANNOTATION_QUERY_TYPES.length; ++i) {
            if (!ANNOTATION_QUERY_TYPES[i].equals(annotationName)) continue;
            return i;
        }
        return -1;
    }

    private DBMetaDataProvider getDBMetadataProvider(DatabaseConnection dbconn, Connection con) {
        return DBMetaDataProvider.get(con, dbconn.getDriverClass());
    }

    private DatabaseConnection findDatabaseConnection(JPACodeCompletionProvider.Context ctx) {
        PersistenceUnit[] pus = ctx.getPersistenceUnits();
        if (pus == null || pus.length == 0) {
            ErrorManager.getDefault().log(1, "There isn't any defined persistence unit for this class in the project!");
            return null;
        }
        PersistenceUnit pu = pus[0];
        DatabaseConnection dbcon = ProviderUtil.getConnection(pu);
        if (dbcon != null) {
            return dbcon;
        }
        String datasourceName = ProviderUtil.getDatasourceName(pu);
        if (datasourceName == null) {
            return null;
        }
        FileObject fo = ctx.getFileObject();
        if (fo == null) {
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project == null) {
            return null;
        }
        JPADataSource datasource = null;
        JPADataSourceProvider dsProvider = (JPADataSourceProvider)project.getLookup().lookup(JPADataSourceProvider.class);
        if (dsProvider == null) {
            return null;
        }
        for (JPADataSource each : dsProvider.getDataSources()) {
            if (!datasourceName.equals(each.getJndiName())) continue;
            datasource = each;
        }
        if (datasource == null) {
            ErrorManager.getDefault().log(1, "The " + datasourceName + " was not found.");
            return null;
        }
        List<DatabaseConnection> dbconns = DBCompletionContextResolver.findDatabaseConnections(datasource);
        if (dbconns.size() > 0) {
            return dbconns.get(0);
        }
        return null;
    }

    private static List<DatabaseConnection> findDatabaseConnections(JPADataSource datasource) {
        if (datasource == null) {
            throw new NullPointerException("The datasource parameter cannot be null.");
        }
        String databaseUrl = datasource.getUrl();
        String user = datasource.getUsername();
        if (databaseUrl == null || user == null) {
            return Collections.emptyList();
        }
        ArrayList<DatabaseConnection> result = new ArrayList<DatabaseConnection>();
        for (DatabaseConnection dbconn : ConnectionManager.getDefault().getConnections()) {
            if (!databaseUrl.equals(dbconn.getDatabaseURL()) || !user.equals(dbconn.getUser())) continue;
            result.add(dbconn);
        }
        if (result.size() > 0) {
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    private List completeTable(CCParser.CC nn, CCParser.NNAttr nnattr, List<JPACompletionItem> results, boolean secondaryTable) throws SQLException {
        block5: {
            String schemaName;
            String catalogName;
            Schema schema;
            Map<String, Object> members;
            String completedMember;
            block6: {
                block4: {
                    completedMember = nnattr.getName();
                    members = nn.getAttributes();
                    if (!"catalog".equals(completedMember)) break block4;
                    Catalog[] catalogs = this.provider.getCatalogs();
                    for (int i = 0; i < catalogs.length; ++i) {
                        String catalogName2 = catalogs[i].getName();
                        if (catalogName2 == null) continue;
                        results.add(new JPACompletionItem.CatalogElementItem(catalogName2, nnattr.isValueQuoted(), nnattr.getValueOffset()));
                    }
                    break block5;
                }
                if (!"schema".equals(completedMember)) break block6;
                String catalogName3 = this.getThisOrDefaultCatalog((String)members.get("catalog"));
                Catalog catalog = this.provider.getCatalog(catalogName3);
                if (catalog == null) break block5;
                Schema[] schemas = catalog.getSchemas();
                for (int i = 0; i < schemas.length; ++i) {
                    results.add(new JPACompletionItem.SchemaElementItem(schemas[i].getName(), nnattr.isValueQuoted(), nnattr.getValueOffset()));
                }
                break block5;
            }
            if ("name".equals(completedMember) && (schema = DBMetaDataUtils.getSchema(this.provider, catalogName = this.getThisOrDefaultCatalog((String)members.get("catalog")), schemaName = this.getThisOrDefaultSchema((String)members.get("schema")))) != null) {
                String[] tableNames = schema.getTableNames();
                for (int i = 0; i < tableNames.length; ++i) {
                    results.add(new JPACompletionItem.TableElementItem(tableNames[i], nnattr.isValueQuoted(), nnattr.getValueOffset()));
                }
            }
        }
        return results;
    }

    private List completeIndex(JPACodeCompletionProvider.Context ctx, CCParser.CC nn, CCParser.NNAttr nnattr, List<JPACompletionItem> results) throws SQLException {
        block7: {
            String schemaName;
            String catalogName;
            Schema schema;
            String completedMember = nnattr.getName();
            Map<String, Object> members = nn.getAttributes();
            if (!"columnList".equals(completedMember) || (schema = DBMetaDataUtils.getSchema(this.provider, catalogName = this.getThisOrDefaultCatalog((String)members.get("catalog")), schemaName = this.getThisOrDefaultSchema((String)members.get("schema")))) == null) break block7;
            String[] tableNames = schema.getTableNames();
            int cmplOffset = ctx.getCompletionOffset();
            int testLen = cmplOffset - nnattr.getValueOffset();
            String toParse = nnattr.getValue().toString();
            int lastSpace = toParse.lastIndexOf(" ");
            int lastComma = toParse.lastIndexOf(",");
            int shift = Math.max(lastComma, lastSpace) + 1 + (nnattr.isValueQuoted() ? 1 : 0);
            boolean compleTables = false;
            if (lastSpace == -1 && lastSpace == -1) {
                compleTables = true;
            } else if (lastComma > -1 && (lastComma == testLen - 1 || toParse.substring(lastComma + 1).trim().length() == 0)) {
                compleTables = true;
            }
            if (compleTables) {
                for (int i = 0; i < tableNames.length; ++i) {
                    results.add(new JPACompletionItem.IndexElementItem(tableNames[i], false, nnattr.getValueOffset(), shift));
                }
            } else {
                for (int i = 0; i < JPACompletionItem.IndexElementItem.PARAMS.length; ++i) {
                    results.add(new JPACompletionItem.IndexElementItem(JPACompletionItem.IndexElementItem.PARAMS[i], false, nnattr.getValueOffset(), shift));
                }
            }
        }
        return results;
    }

    private List completePrimaryKeyJoinColumn(JPACodeCompletionProvider.Context ctx, CCParser.CC nn, CCParser.NNAttr nnattr, List<JPACompletionItem> results) throws SQLException {
        String schemaName;
        String catalogName;
        TableElement tableElement;
        String tableName;
        Table table;
        Entity entity;
        String completedMember = nnattr.getName();
        if ("name".equals(completedMember) && (entity = PersistenceUtils.getEntity(((TypeElement)ctx.getJavaClass()).getQualifiedName().toString(), ctx.getEntityMappings())) != null && (table = entity.getTable()) != null && (tableName = table.getName()) != null && (tableElement = DBMetaDataUtils.getTable(this.provider, catalogName = this.getThisOrDefaultCatalog(table.getCatalog()), schemaName = this.getThisOrDefaultSchema(table.getSchema()), tableName)) != null) {
            ColumnElement[] columnElements = tableElement.getColumns();
            for (int i = 0; i < columnElements.length; ++i) {
                results.add(new JPACompletionItem.ColumnElementItem(columnElements[i].getName().getName(), tableName, true, -1));
            }
        }
        return results;
    }

    private List completeColumn(JPACodeCompletionProvider.Context ctx, CCParser.CC nn, CCParser.NNAttr nnattr, List<JPACompletionItem> results) throws SQLException {
        block7: {
            String schemaName;
            String catalogName;
            String tableName2;
            block8: {
                TableElement tableElement;
                Table table;
                Entity entity;
                String completedMember = nnattr.getName();
                Map<String, Object> members = nn.getAttributes();
                if ("table".equals(completedMember)) {
                    Set mappingTables = this.getMappingEntityTableNames(((TypeElement)ctx.getJavaClass()).getQualifiedName().toString());
                    for (String tableName2 : mappingTables) {
                        results.add(new JPACompletionItem.TableElementItem(tableName2, nnattr.isValueQuoted(), nnattr.getValueOffset()));
                    }
                }
                if (!"name".equals(completedMember)) break block7;
                catalogName = null;
                schemaName = null;
                tableName2 = (String)members.get("table");
                if (tableName2 != null) break block8;
                if (ctx == null) {
                    System.out.println("CTX");
                }
                if (ctx.getJavaClass() == null) {
                    System.out.println("JC");
                }
                if ((entity = PersistenceUtils.getEntity(((TypeElement)ctx.getJavaClass()).getQualifiedName().toString(), ctx.getEntityMappings())) == null || (table = entity.getTable()) == null || (tableName2 = table.getName()) == null || (tableElement = DBMetaDataUtils.getTable(this.provider, catalogName = this.getThisOrDefaultCatalog(table.getCatalog()), schemaName = this.getThisOrDefaultSchema(table.getSchema()), tableName2)) == null) break block7;
                ColumnElement[] columnElements = tableElement.getColumns();
                for (int i = 0; i < columnElements.length; ++i) {
                    results.add(new JPACompletionItem.ColumnElementItem(columnElements[i].getName().getName(), tableName2, nnattr.isValueQuoted(), nnattr.getValueOffset()));
                }
                break block7;
            }
            TableElement tableElement = DBMetaDataUtils.getTable(this.provider, catalogName = this.getThisOrDefaultCatalog(catalogName), schemaName = this.getThisOrDefaultSchema(schemaName), tableName2);
            if (tableElement != null) {
                ColumnElement[] columnElements = tableElement.getColumns();
                for (int i = 0; i < columnElements.length; ++i) {
                    results.add(new JPACompletionItem.ColumnElementItem(columnElements[i].getName().getName(), tableName2, nnattr.isValueQuoted(), nnattr.getValueOffset()));
                }
            }
        }
        return results;
    }

    private List completeJoinColumn(JPACodeCompletionProvider.Context ctx, CCParser.CC nn, CCParser.NNAttr nnattr, List<JPACompletionItem> results) throws SQLException {
        Entity entity;
        String completedMember = nnattr.getName();
        Map<String, Object> members = nn.getAttributes();
        if ("name".equals(completedMember) && (entity = PersistenceUtils.getEntity(((TypeElement)ctx.getJavaClass()).getQualifiedName().toString(), ctx.getEntityMappings())) != null && entity.getAttributes() != null) {
            String propertyName = ctx.getCompletedMemberName();
            String resolvedClassName = ctx.getCompletedMemberClassName();
            TypeElement type = null;
            if (type == null) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JPACodeCompletionProvider.class, (String)"MSG_CannotFindClass", (Object[])new Object[]{resolvedClassName, propertyName}));
                return Collections.EMPTY_LIST;
            }
            String resolvedType = type.getQualifiedName().toString();
            if (DEBUG) {
                System.out.println("completion called on property " + propertyName + " of " + resolvedType + " type.");
            }
            EntityMappings em = ctx.getEntityMappings();
            ManyToOne[] m2o = entity.getAttributes().getManyToOne();
            OneToOne[] o2o = entity.getAttributes().getOneToOne();
            OneToMany[] o2m = entity.getAttributes().getOneToMany();
            ManyToMany[] m2m = entity.getAttributes().getManyToMany();
            ManyToOne m2onn = null;
            if (m2o != null) {
                for (int i = 0; i < m2o.length; ++i) {
                    if (!m2o[i].getName().equals(propertyName)) continue;
                    m2onn = m2o[i];
                    break;
                }
            }
            OneToOne o2onn = null;
            if (o2o != null) {
                for (int i = 0; i < o2o.length; ++i) {
                    if (!o2o[i].getName().equals(propertyName)) continue;
                    o2onn = o2o[i];
                    break;
                }
            }
            OneToMany o2mnn = null;
            if (o2m != null) {
                for (int i = 0; i < o2m.length; ++i) {
                    if (!o2m[i].getName().equals(propertyName)) continue;
                    o2mnn = o2m[i];
                    break;
                }
            }
            ManyToMany m2mnn = null;
            if (m2m != null) {
                for (int i = 0; i < m2m.length; ++i) {
                    if (!m2m[i].getName().equals(propertyName)) continue;
                    m2mnn = m2m[i];
                    break;
                }
            }
            if (m2onn != null || o2onn != null) {
                String targetEntity;
                if (DEBUG) {
                    System.out.println("found OneToOne or ManyToOne annotation on the completed field.");
                }
                Entity ent = PersistenceUtils.getEntity(resolvedType, ctx.getEntityMappings());
                if (m2onn != null && (targetEntity = m2onn.getTargetEntity()) != null) {
                    ent = PersistenceUtils.getEntity(targetEntity, em);
                    if (DEBUG) {
                        System.out.println("entity " + ent.getName() + " is specified in ManyToOne element.");
                    }
                }
                if (o2onn != null && (targetEntity = o2onn.getTargetEntity()) != null) {
                    ent = PersistenceUtils.getEntity(targetEntity, em);
                    if (DEBUG) {
                        System.out.println("entity " + ent.getName() + " is specified in OneToOne element.");
                    }
                }
                if (ent != null) {
                    Table table = ent.getTable();
                    if (table != null) {
                        TableElement tableElement;
                        String catalogName = this.getThisOrDefaultCatalog(null);
                        String schemaName = this.getThisOrDefaultSchema(null);
                        String tableName = table.getName();
                        if (tableName != null && (tableElement = DBMetaDataUtils.getTable(this.provider, catalogName, schemaName, tableName)) != null) {
                            ColumnElement[] columnElements = tableElement.getColumns();
                            for (int i = 0; i < columnElements.length; ++i) {
                                results.add(new JPACompletionItem.ColumnElementItem(columnElements[i].getName().getName(), tableName, nnattr.isValueQuoted(), nnattr.getValueOffset()));
                            }
                            if (DEBUG) {
                                System.out.println("added " + columnElements.length + " CC items.");
                            }
                        }
                    } else if (DEBUG) {
                        System.out.println("the found entity has not defined table!?! (probably a  bug in values defaultter).");
                    }
                }
            }
            if (m2mnn != null) {
                CCParser.CC tableNN;
                Map<String, Object> attrs;
                Object val;
                if (DEBUG) {
                    System.out.println("found ManyToMany annotation on the completed field.");
                }
                if (DEBUG) {
                    System.out.println(nn);
                }
                CCParser.CC tblNN = null;
                if (nn != null && nn.getName().equals("JoinTable") && (val = (attrs = nn.getAttributes()).get("table")) != null && val instanceof CCParser.CC && (tableNN = (CCParser.CC)val).getName().equals("Table")) {
                    tblNN = tableNN;
                }
                if (tblNN != null) {
                    TableElement tableElement;
                    String catalogName = this.getThisOrDefaultCatalog((String)tblNN.getAttributes().get("catalog"));
                    String schemaName = this.getThisOrDefaultSchema((String)tblNN.getAttributes().get("schema"));
                    String tableName = (String)tblNN.getAttributes().get("name");
                    if (tableName != null && (tableElement = DBMetaDataUtils.getTable(this.provider, catalogName, schemaName, tableName)) != null) {
                        ColumnElement[] columnElements = tableElement.getColumns();
                        for (int i = 0; i < columnElements.length; ++i) {
                            results.add(new JPACompletionItem.ColumnElementItem(columnElements[i].getName().getName(), tableName, nnattr.isValueQuoted(), nnattr.getValueOffset()));
                        }
                    }
                }
            }
        }
        return results;
    }

    private List completePersistenceUnitContext(JPACodeCompletionProvider.Context ctx, CCParser.CC nn, CCParser.NNAttr nnattr, List<JPACompletionItem> results) throws SQLException {
        String completedMember = nnattr.getName();
        Map<String, Object> members = nn.getAttributes();
        if ("unitName".equals(completedMember)) {
            PersistenceUnit[] pus;
            for (PersistenceUnit pu : pus = ctx.getPersistenceUnits()) {
                results.add(new JPACompletionItem.PersistenceUnitElementItem(pu.getName(), nnattr.isValueQuoted(), nnattr.getValueOffset()));
            }
        }
        return results;
    }

    private List completeManyToMany(JPACodeCompletionProvider.Context ctx, CCParser.CC nn, CCParser.NNAttr nnattr, List<JPACompletionItem> results) throws SQLException {
        TypeElement cdef;
        Entity entity;
        Object type;
        String completedMember = nnattr.getName();
        Map<String, Object> members = nn.getAttributes();
        if ("mappedBy".equals(completedMember) && (type = null) != null && type instanceof TypeElement && (entity = PersistenceUtils.getEntity((cdef = (TypeElement)type).getQualifiedName().toString(), ctx.getEntityMappings())) != null) {
            LinkedList<ExecutableElement> resultMethods = new LinkedList<ExecutableElement>();
            LinkedList<VariableElement> resultFields = new LinkedList<VariableElement>();
            TypeElement typeElement = cdef;
            while (typeElement != null) {
                if (JpaControllerUtil.isAnnotatedWith(cdef, "javax.persistence.Entity") || JpaControllerUtil.isAnnotatedWith(cdef, "javax.persistence.MappedSuperclass")) {
                    resultMethods.addAll(ElementFilter.methodsIn(typeElement.getEnclosedElements()));
                    resultFields.addAll(ElementFilter.fieldsIn(typeElement.getEnclosedElements()));
                }
                typeElement = JpaControllerUtil.getSuperclassTypeElement(typeElement);
            }
            block1: for (VariableElement variableElement : resultFields) {
                for (Modifier mod : variableElement.getModifiers()) {
                    if (!Modifier.TRANSIENT.equals((Object)mod)) continue;
                    continue block1;
                }
                if (JpaControllerUtil.isAnnotatedWith(variableElement, "javax.persistence.Transient")) continue;
                String name = variableElement.getSimpleName().toString();
                String capName = Character.toUpperCase(name.charAt(0)) + name.substring(1);
                for (ExecutableElement meth : resultMethods) {
                    if (!("get" + capName).equals(meth.getSimpleName().toString()) && !("is" + capName).equals(meth.getSimpleName().toString())) continue;
                    results.add(new JPACompletionItem.EntityPropertyElementItem(name, nnattr.isValueQuoted(), nnattr.getValueOffset()));
                    continue block1;
                }
            }
            for (ExecutableElement executableElement : resultMethods) {
                if (JpaControllerUtil.guessField(executableElement) == null) continue;
                results.add(new JPACompletionItem.EntityPropertyElementItem(JpaControllerUtil.getPropNameFromMethod(executableElement.getSimpleName().toString()), nnattr.isValueQuoted(), nnattr.getValueOffset()));
            }
        }
        return results;
    }

    private Set getMappingEntityTableNames(TypeElement clazz) {
        TreeSet<String> result = new TreeSet<String>();
        List<? extends AnnotationMirror> annotations = clazz.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            String tableName;
            TypeElement annTypeElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            String annotationTypeName = annTypeElement.getQualifiedName().toString();
            if ("javax.persistence.Table".equals(annotationTypeName)) {
                tableName = AnnotationUtils.getStringMemberValue(annotationMirror, "name");
                if (tableName == null) continue;
                result.add(tableName);
                continue;
            }
            if ("javax.persistence.SecondaryTable".equals(annotationTypeName)) {
                tableName = AnnotationUtils.getStringMemberValue(annotationMirror, "name");
                if (tableName == null) continue;
                result.add(tableName);
                continue;
            }
            if (!"javax.persistence.SecondaryTables".equals(annotationTypeName)) continue;
            List<AnnotationMirror> secondaryTableNNs = AnnotationUtils.getAnnotationsMemberValue(annotationMirror, "value");
            for (AnnotationMirror secondaryTableNN : secondaryTableNNs) {
                String string = AnnotationUtils.getStringMemberValue(secondaryTableNN, "name");
            }
        }
        return result;
    }

    private String getThisOrDefaultCatalog(String catalogName) throws SQLException {
        assert (this.provider != null);
        if (catalogName != null && !catalogName.equals("")) {
            return catalogName;
        }
        return this.provider.getDefaultCatalog();
    }

    private String getThisOrDefaultSchema(String schemaName) {
        assert (this.dbconn != null);
        if (schemaName != null && !schemaName.equals("")) {
            return schemaName;
        }
        return this.dbconn.getSchema();
    }

    private Set getMappingEntityTableNames(String javaClass) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private static final class ResultItemsFilterList
    extends ArrayList {
        private JPACodeCompletionProvider.Context ctx;

        public ResultItemsFilterList(JPACodeCompletionProvider.Context ctx) {
            this.ctx = ctx;
        }

        @Override
        public boolean add(Object o) {
            if (!(o instanceof JPACompletionItem)) {
                return false;
            }
            JPACompletionItem ri = (JPACompletionItem)o;
            try {
                String preText = this.ctx.getBaseDocument().getText(ri.getSubstituteOffset(), this.ctx.getCompletionOffset() - ri.getSubstituteOffset());
                if (!ri.canFilter() || ri.getItemText().startsWith(preText)) {
                    return super.add(ri);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return false;
        }
    }
}

