/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerAdviceBean
implements Ordered {
    private final Object bean;
    private final int order;
    private final BeanFactory beanFactory;

    public ControllerAdviceBean(String beanName, BeanFactory beanFactory) {
        Assert.hasText((String)beanName, (String)"'beanName' must not be null");
        Assert.notNull((Object)beanFactory, (String)"'beanFactory' must not be null");
        Assert.isTrue((boolean)beanFactory.containsBean(beanName), (String)("Bean factory [" + beanFactory + "] does not contain bean " + "with name [" + beanName + "]"));
        this.bean = beanName;
        this.beanFactory = beanFactory;
        this.order = ControllerAdviceBean.initOrderFromBeanType(this.beanFactory.getType(beanName));
    }

    private static int initOrderFromBeanType(Class<?> beanType) {
        Order annot = (Order)AnnotationUtils.findAnnotation(beanType, Order.class);
        return annot != null ? annot.value() : Integer.MAX_VALUE;
    }

    public ControllerAdviceBean(Object bean) {
        Assert.notNull((Object)bean, (String)"'bean' must not be null");
        this.bean = bean;
        this.order = ControllerAdviceBean.initOrderFromBean(bean);
        this.beanFactory = null;
    }

    private static int initOrderFromBean(Object bean) {
        return bean instanceof Ordered ? ((Ordered)bean).getOrder() : ControllerAdviceBean.initOrderFromBeanType(bean.getClass());
    }

    public static List<ControllerAdviceBean> findAnnotatedBeans(ApplicationContext applicationContext) {
        ArrayList<ControllerAdviceBean> beans = new ArrayList<ControllerAdviceBean>();
        for (String name : applicationContext.getBeanDefinitionNames()) {
            if (applicationContext.findAnnotationOnBean(name, ControllerAdvice.class) == null) continue;
            beans.add(new ControllerAdviceBean(name, (BeanFactory)applicationContext));
        }
        return beans;
    }

    public int getOrder() {
        return this.order;
    }

    public Class<?> getBeanType() {
        Class clazz = this.bean instanceof String ? this.beanFactory.getType((String)this.bean) : this.bean.getClass();
        return ClassUtils.getUserClass((Class)clazz);
    }

    public Object resolveBean() {
        return this.bean instanceof String ? this.beanFactory.getBean((String)this.bean) : this.bean;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o instanceof ControllerAdviceBean) {
            ControllerAdviceBean other = (ControllerAdviceBean)o;
            return this.bean.equals(other.bean);
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.bean.hashCode();
    }

    public String toString() {
        return this.bean.toString();
    }
}

