/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.frames;

import com.sun.jdi.StringReference;
import java.io.InvalidObjectException;
import java.util.ArrayList;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.truffle.TruffleDebugManager;
import org.netbeans.modules.debugger.jpda.truffle.frames.TruffleStackFrame;
import org.openide.util.Exceptions;

public final class TruffleStackInfo {
    private static final String METHOD_GET_FRAMES_INFO = "getFramesInfo";
    private static final String METHOD_GET_FRAMES_INFO_SIG = "([Lcom/oracle/truffle/api/debug/DebugStackFrame;Z)[Ljava/lang/Object;";
    private final JPDADebugger debugger;
    private final JPDAThread thread;
    private final ObjectVariable stackTrace;
    private TruffleStackFrame[] stackFrames;
    private boolean includedInternalFrames;
    private boolean areInternalFrames;

    public TruffleStackInfo(JPDADebugger debugger, JPDAThread thread, ObjectVariable stackTrace) {
        this.debugger = debugger;
        this.thread = thread;
        this.stackTrace = stackTrace;
    }

    public TruffleStackFrame[] getStackFrames(boolean includeInternal) {
        if (this.stackFrames == null || this.includedInternalFrames != includeInternal) {
            this.stackFrames = this.loadStackFrames(includeInternal);
            this.includedInternalFrames = includeInternal;
        }
        return this.stackFrames;
    }

    public boolean hasInternalFrames() {
        return this.areInternalFrames;
    }

    private TruffleStackFrame[] loadStackFrames(boolean includeInternal) {
        JPDAClassType debugAccessor = TruffleDebugManager.getDebugAccessorJPDAClass(this.debugger);
        try {
            int i2;
            Variable internalVar = this.debugger.createMirrorVar((Object)includeInternal, true);
            Variable framesVar = debugAccessor.invokeMethod(METHOD_GET_FRAMES_INFO, METHOD_GET_FRAMES_INFO_SIG, new Variable[]{this.stackTrace, internalVar});
            Field[] framesInfos = ((ObjectVariable)framesVar).getFields(0, Integer.MAX_VALUE);
            String framesDesc = (String)framesInfos[0].createMirrorObject();
            Field[] codes = ((ObjectVariable)framesInfos[1]).getFields(0, Integer.MAX_VALUE);
            Field[] thiss = ((ObjectVariable)framesInfos[2]).getFields(0, Integer.MAX_VALUE);
            this.areInternalFrames = false;
            if (!includeInternal) {
                this.areInternalFrames = (Boolean)framesInfos[3].createMirrorObject();
            }
            int i1 = 0;
            int depth = 1;
            ArrayList<TruffleStackFrame> truffleFrames = new ArrayList<TruffleStackFrame>();
            while ((i2 = framesDesc.indexOf("\n\n", i1)) > 0) {
                StringReference codeRef = (StringReference)((JDIVariable)codes[depth - 1]).getJDIValue();
                ObjectVariable frameInstance = (ObjectVariable)this.stackTrace.getFields(0, Integer.MAX_VALUE)[depth - 1];
                TruffleStackFrame tsf = new TruffleStackFrame(this.debugger, this.thread, depth, frameInstance, framesDesc.substring(i1, i2), codeRef, null, (ObjectVariable)thiss[depth - 1], includeInternal);
                truffleFrames.add(tsf);
                if (includeInternal && tsf.isInternal()) {
                    this.areInternalFrames = true;
                }
                i1 = i2 + 2;
                ++depth;
            }
            return truffleFrames.toArray(new TruffleStackFrame[truffleFrames.size()]);
        }
        catch (InvalidObjectException | NoSuchMethodException | InvalidExpressionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return new TruffleStackFrame[0];
        }
    }
}

