/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.model;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import org.netbeans.modules.jshell.model.ConsoleModel;
import org.netbeans.modules.jshell.model.ConsoleSection;

public final class ConsoleEvent
extends EventObject {
    private final ConsoleSection theSection;
    private final List<ConsoleSection> affectedSections;
    private volatile Boolean input;
    private boolean start;

    public ConsoleEvent(ConsoleModel source, ConsoleSection section, boolean startStop) {
        this(source, section);
        this.start = startStop;
    }

    public ConsoleEvent(ConsoleModel source, ConsoleSection section) {
        super(source);
        this.theSection = section;
        this.affectedSections = null;
    }

    public ConsoleEvent(ConsoleModel source, List<ConsoleSection> sections) {
        super(source);
        this.affectedSections = sections;
        this.theSection = sections.isEmpty() ? null : sections.get(0);
    }

    public ConsoleSection getSection() {
        return this.theSection;
    }

    public List<ConsoleSection> getAffectedSections() {
        return this.affectedSections == null ? Collections.singletonList(this.theSection) : this.affectedSections;
    }

    @Override
    public ConsoleModel getSource() {
        return (ConsoleModel)super.getSource();
    }

    public boolean containsInput() {
        if (this.input != null) {
            return this.input;
        }
        for (ConsoleSection s : this.getAffectedSections()) {
            if (!s.getType().input) continue;
            this.input = true;
            return this.input;
        }
        this.input = false;
        return this.input;
    }

    public boolean isStart() {
        return this.start;
    }
}

