/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.WhileStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.AccidentalAssignmentCustomizer;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.CustomisableRule;
import org.netbeans.modules.php.editor.verification.HintRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class AccidentalAssignmentHint
extends HintRule
implements CustomisableRule {
    private static final String HINT_ID = "Accidental.Assignment.Hint";
    private static final String CHECK_ASSIGNMENTS_IN_SUB_STATEMENTS = "php.verification.check.assignments.in.sub.statements";
    private static final boolean CHECK_ASSIGNMENTS_IN_SUB_STATEMENTS_DEFAULT = false;
    private static final String CHECK_ASSIGNMENTS_IN_WHILE_STATEMENTS = "php.verification.check.assignments.in.while.statements";
    private static final boolean CHECK_ASSIGNMENTS_IN_WHILE_STATEMENTS_DEFAULT = false;
    private static final Logger LOGGER = Logger.getLogger(AccidentalAssignmentHint.class.getName());
    private Preferences preferences;

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject == null) {
            return;
        }
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        CheckVisitor checkVisitor = new CheckVisitor(fileObject, context.doc);
        phpParseResult.getProgram().accept(checkVisitor);
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        hints.addAll(checkVisitor.getHints());
    }

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.AccidentalAssignmentHintDesc();
    }

    public String getDisplayName() {
        return Bundle.AccidentalAssignmentHintDispName();
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    @Override
    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        AccidentalAssignmentCustomizer customizer = new AccidentalAssignmentCustomizer(preferences, this);
        this.setCheckAssignmentsInSubStatements(preferences, this.checkAssignmentsInSubStatements(preferences));
        this.setCheckAssignmentsInWhileStatements(preferences, this.checkAssignmentsInWhileStatements(preferences));
        return customizer;
    }

    public void setCheckAssignmentsInSubStatements(Preferences preferences, boolean isEnabled) {
        preferences.putBoolean(CHECK_ASSIGNMENTS_IN_SUB_STATEMENTS, isEnabled);
    }

    public boolean checkAssignmentsInSubStatements(Preferences preferences) {
        return preferences.getBoolean(CHECK_ASSIGNMENTS_IN_SUB_STATEMENTS, false);
    }

    public void setCheckAssignmentsInWhileStatements(Preferences preferences, boolean isEnabled) {
        preferences.putBoolean(CHECK_ASSIGNMENTS_IN_WHILE_STATEMENTS, isEnabled);
    }

    public boolean checkAssignmentsInWhileStatements(Preferences preferences) {
        return preferences.getBoolean(CHECK_ASSIGNMENTS_IN_WHILE_STATEMENTS, false);
    }

    private class IdenticalComparisonHintFix
    extends ComparisonHintFix {
        public IdenticalComparisonHintFix(Assignment assignment, BaseDocument doc) {
            super(assignment, doc);
        }

        @Override
        protected String getOperatorText() {
            return "===";
        }
    }

    private class EqualComparisonHintFix
    extends ComparisonHintFix {
        public EqualComparisonHintFix(Assignment assignment, BaseDocument doc) {
            super(assignment, doc);
        }

        @Override
        protected String getOperatorText() {
            return "==";
        }
    }

    private abstract class ComparisonHintFix
    implements HintFix {
        private final Assignment assignment;
        private final BaseDocument doc;

        public ComparisonHintFix(Assignment assignment, BaseDocument doc) {
            this.assignment = assignment;
            this.doc = doc;
        }

        public String getDescription() {
            return Bundle.ChangeAssignmentDisp(this.getCorrectedAssignmentText());
        }

        @SuppressWarnings(value={"DLS_DEAD_LOCAL_STORE"})
        private String getCorrectedAssignmentText() {
            StringBuilder sb = new StringBuilder();
            try {
                sb.append(this.getExpressionText(this.assignment.getLeftHandSide()));
                sb.append(" ").append(this.getOperatorText()).append(" ");
                sb.append(this.getExpressionText(this.assignment.getRightHandSide()));
                return sb.toString();
            }
            catch (BadLocationException ex) {
                LOGGER.log(Level.FINE, "Can't obtain corrected assignment text.", ex);
                return sb.toString();
            }
        }

        private String getExpressionText(Expression expression) throws BadLocationException {
            int start = expression.getStartOffset();
            int end = expression.getEndOffset();
            return this.doc.getText(start, end - start);
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.doc);
            OffsetRange offsetRange = this.getOffsetRange();
            edits.replace(offsetRange.getStart(), offsetRange.getLength(), this.getCorrectedAssignmentText(), true, 0);
            edits.apply();
        }

        private OffsetRange getOffsetRange() {
            int start = this.assignment.getStartOffset();
            int end = this.assignment.getEndOffset();
            return new OffsetRange(start, end);
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }

        protected abstract String getOperatorText();
    }

    private static class AssignmentVisitor
    extends DefaultVisitor {
        private final List<Assignment> accidentalAssignments = new ArrayList<Assignment>();

        private AssignmentVisitor() {
        }

        @Override
        public void visit(Assignment node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.accidentalAssignments.add(node);
            this.scan(node.getRightHandSide());
        }

        public List<Assignment> getAccidentalAssignments() {
            return Collections.unmodifiableList(this.accidentalAssignments);
        }
    }

    private class CheckVisitor
    extends DefaultVisitor {
        private final FileObject fileObject;
        private final List<Hint> hints = new ArrayList<Hint>();
        private final List<Assignment> accidentalAssignments = new ArrayList<Assignment>();
        private final BaseDocument doc;

        public CheckVisitor(FileObject fileObject, BaseDocument doc) {
            this.fileObject = fileObject;
            this.doc = doc;
        }

        public List<Hint> getHints() {
            for (Assignment assignment : this.accidentalAssignments) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return Collections.emptyList();
                }
                this.createHint(assignment);
            }
            return this.hints;
        }

        private void createHint(Assignment assignment) {
            OffsetRange offsetRange = new OffsetRange(assignment.getStartOffset(), assignment.getEndOffset());
            if (AccidentalAssignmentHint.this.showHint(offsetRange, this.doc)) {
                this.hints.add(new Hint((Rule)AccidentalAssignmentHint.this, Bundle.AccidentalAssignmentHintCustom(this.asText(assignment)), this.fileObject, offsetRange, this.createFixes(assignment), 500));
            }
        }

        private String asText(Assignment assignment) {
            String retval = "";
            try {
                int start = assignment.getStartOffset();
                int end = assignment.getEndOffset();
                retval = this.doc.getText(start, end - start);
            }
            catch (BadLocationException ex) {
                LOGGER.log(Level.FINE, "Can't obtain assignment text.", ex);
            }
            return retval;
        }

        private List<HintFix> createFixes(Assignment assignment) {
            ArrayList<HintFix> fixes = new ArrayList<HintFix>();
            fixes.add(new IdenticalComparisonHintFix(assignment, this.doc));
            fixes.add(new EqualComparisonHintFix(assignment, this.doc));
            return fixes;
        }

        private void processCondition(Expression node) {
            if (AccidentalAssignmentHint.this.checkAssignmentsInSubStatements(AccidentalAssignmentHint.this.preferences)) {
                this.processSubAssignments(node);
            } else if (node instanceof Assignment) {
                this.accidentalAssignments.add((Assignment)node);
            }
        }

        private void processSubAssignments(Expression node) {
            AssignmentVisitor assignmentVisitor = new AssignmentVisitor();
            node.accept(assignmentVisitor);
            this.accidentalAssignments.addAll(assignmentVisitor.getAccidentalAssignments());
        }

        @Override
        public void visit(DoStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (AccidentalAssignmentHint.this.checkAssignmentsInWhileStatements(AccidentalAssignmentHint.this.preferences)) {
                this.processCondition(node.getCondition());
            }
            this.scan(node.getBody());
        }

        @Override
        public void visit(IfStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.processCondition(node.getCondition());
            this.scan(node.getTrueStatement());
            this.scan(node.getFalseStatement());
        }

        @Override
        public void visit(ForStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            for (Expression condition : node.getConditions()) {
                this.processCondition(condition);
            }
            this.scan(node.getInitializers());
            this.scan(node.getUpdaters());
            this.scan(node.getBody());
        }

        @Override
        public void visit(WhileStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (AccidentalAssignmentHint.this.checkAssignmentsInWhileStatements(AccidentalAssignmentHint.this.preferences)) {
                this.processCondition(node.getCondition());
            }
            this.scan(node.getBody());
        }
    }
}

