/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.model.nodes.FormalParameterInfo;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.openide.util.Pair;

public class MethodDeclarationInfo
extends ASTNodeInfo<MethodDeclaration> {
    Map<String, List<Pair<QualifiedName, Boolean>>> paramDocTypes = Collections.emptyMap();
    private final boolean isFromInterface;

    MethodDeclarationInfo(Program program, MethodDeclaration methodDeclaration, boolean isFromInterface) {
        super(methodDeclaration);
        this.isFromInterface = isFromInterface;
        if (program != null) {
            this.paramDocTypes = VariousUtils.getParamTypesFromPHPDoc(program, methodDeclaration);
        }
    }

    public static MethodDeclarationInfo create(Program program, MethodDeclaration methodDeclaration, boolean isFromInterface) {
        return new MethodDeclarationInfo(program, methodDeclaration, isFromInterface);
    }

    public static MethodDeclarationInfo create(Program program, MethodDeclaration methodDeclaration, TypeScope typeScope) {
        return MethodDeclarationInfo.create(program, methodDeclaration, typeScope.isInterface());
    }

    public static MethodDeclarationInfo create(MethodDeclaration classDeclaration, TypeScope typeScope) {
        return new MethodDeclarationInfo(null, classDeclaration, typeScope.isInterface());
    }

    @Override
    public ASTNodeInfo.Kind getKind() {
        PhpModifiers modifiers = PhpModifiers.fromBitMask(((MethodDeclaration)this.getOriginalNode()).getModifier());
        return modifiers.isStatic() ? ASTNodeInfo.Kind.STATIC_METHOD : ASTNodeInfo.Kind.METHOD;
    }

    @Override
    public String getName() {
        MethodDeclaration methodDeclaration = (MethodDeclaration)this.getOriginalNode();
        return methodDeclaration.getFunction().getFunctionName().getName();
    }

    @Override
    public QualifiedName getQualifiedName() {
        return QualifiedName.createUnqualifiedName(this.getName());
    }

    @Override
    public OffsetRange getRange() {
        MethodDeclaration methodDeclaration = (MethodDeclaration)this.getOriginalNode();
        Identifier name = methodDeclaration.getFunction().getFunctionName();
        return new OffsetRange(name.getStartOffset(), name.getEndOffset());
    }

    public List<ParameterElement> getParameters() {
        ArrayList<ParameterElement> retval = new ArrayList<ParameterElement>();
        List<FormalParameter> formalParameters = ((MethodDeclaration)this.getOriginalNode()).getFunction().getFormalParameters();
        for (FormalParameter formalParameter : formalParameters) {
            FormalParameterInfo parameterInfo = FormalParameterInfo.create(formalParameter, this.paramDocTypes);
            retval.add(parameterInfo.toParameter());
        }
        return retval;
    }

    public PhpModifiers getAccessModifiers() {
        int realModifiers = ((MethodDeclaration)this.getOriginalNode()).getModifier();
        realModifiers = this.isFromInterface ? realModifiers | 0x400 | 1 : realModifiers;
        return PhpModifiers.fromBitMask(realModifiers);
    }
}

