/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Include;
import org.netbeans.modules.php.editor.parser.astnodes.ParenthesisExpression;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public final class NavUtils {
    private NavUtils() {
    }

    public static List<ASTNode> underCaret(ParserResult info, final int offset) {
        class Result
        extends Error {
            private final ArrayDeque<ASTNode> result;

            Result(ArrayDeque<ASTNode> result) {
                this.result = result;
            }

            @Override
            public Throwable fillInStackTrace() {
                return this;
            }
        }
        try {
            new DefaultVisitor(){
                private final ArrayDeque<ASTNode> s = new ArrayDeque();

                @Override
                public void scan(ASTNode node) {
                    if (node == null) {
                        return;
                    }
                    if (node.getStartOffset() <= offset && offset <= node.getEndOffset()) {
                        this.s.push(node);
                        super.scan(node);
                        throw new Result(this.s);
                    }
                }
            }.scan(Utils.getRoot(info));
        }
        catch (Result r) {
            ArrayList<ASTNode> list = new ArrayList<ASTNode>();
            Iterator iterator = r.result.descendingIterator();
            while (iterator.hasNext()) {
                list.add((ASTNode)iterator.next());
            }
            return list;
        }
        return Collections.emptyList();
    }

    public static boolean isQuoted(String value) {
        return !(value.length() < 2 || !value.startsWith("\"") && !value.startsWith("'") || !value.endsWith("\"") && !value.endsWith("'"));
    }

    public static String dequote(String value) {
        assert (NavUtils.isQuoted(value));
        return value.substring(1, value.length() - 1);
    }

    public static FileObject resolveInclude(ParserResult info, Include include) {
        Scalar s;
        Expression e = include.getExpression();
        if (e instanceof ParenthesisExpression) {
            e = ((ParenthesisExpression)e).getExpression();
        }
        if (e instanceof Scalar && Scalar.Type.STRING == (s = (Scalar)e).getScalarType()) {
            String fileName = s.getStringValue();
            fileName = fileName.length() >= 2 ? fileName.substring(1, fileName.length() - 1) : fileName;
            return NavUtils.resolveRelativeFile(info, fileName);
        }
        return null;
    }

    private static FileObject resolveRelativeFile(ParserResult info, String name) {
        while (true) {
            FileObject result;
            if ((result = PhpSourcePath.resolveFile((FileObject)info.getSnapshot().getSource().getFileObject().getParent(), (String)name)) != null) {
                return result;
            }
            int slash = name.indexOf(47);
            if (slash == -1) break;
            name = name.substring(slash + 1);
        }
        return null;
    }

    public static FileObject getFile(Document doc) {
        Object o = doc.getProperty("stream");
        if (o instanceof DataObject) {
            DataObject od = (DataObject)o;
            return od.getPrimaryFile();
        }
        return null;
    }
}

