/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.java.j2seplatform.api.J2SEPlatformCreator;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.Importer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class JavaPlatformSupport {
    private List<JavaPlatform> justCreatedPlatforms = new ArrayList<JavaPlatform>();
    private File defaultNetBeansPlatformFile = null;
    private static JavaPlatformSupport inst;

    private JavaPlatformSupport() {
        JavaPlatform defPlf = JavaPlatformManager.getDefault().getDefaultPlatform();
        Collection installFolder = defPlf.getInstallFolders();
        if (!installFolder.isEmpty()) {
            this.defaultNetBeansPlatformFile = FileUtil.toFile((FileObject)((FileObject)installFolder.toArray()[0]));
        }
    }

    public static synchronized JavaPlatformSupport getJavaPlatformSupport() {
        if (inst == null) {
            inst = new JavaPlatformSupport();
        }
        return inst;
    }

    private List<JavaPlatform> getAllPlatforms() {
        ArrayList<JavaPlatform> all = new ArrayList<JavaPlatform>(this.justCreatedPlatforms);
        all.addAll(Arrays.asList(JavaPlatformManager.getDefault().getInstalledPlatforms()));
        return all;
    }

    public JavaPlatform getJavaPlatform(EclipseProject eclProject, List<String> importProblems) {
        String eclPlfDir = eclProject.getJDKDirectory();
        if (eclPlfDir == null) {
            return null;
        }
        File eclPlfFile = FileUtil.normalizeFile((File)new File(eclPlfDir));
        if (this.defaultNetBeansPlatformFile != null && eclPlfFile.equals(this.defaultNetBeansPlatformFile)) {
            return null;
        }
        JavaPlatform nbPlf = null;
        for (JavaPlatform current : this.getAllPlatforms()) {
            File nbPlfDir;
            Collection instFolders = current.getInstallFolders();
            if (instFolders.isEmpty() || !(nbPlfDir = FileUtil.toFile((FileObject)((FileObject)instFolders.iterator().next()))).equals(eclPlfFile)) continue;
            nbPlf = current;
            break;
        }
        if (nbPlf != null) {
            return nbPlf;
        }
        FileObject fo = FileUtil.toFileObject((File)eclPlfFile);
        if (fo != null) {
            try {
                JavaPlatform plat = J2SEPlatformCreator.createJ2SEPlatform((FileObject)fo);
                JavaPlatform[] platforms = JavaPlatformManager.getDefault().getPlatforms(plat.getDisplayName(), null);
                if (platforms.length > 0) {
                    return platforms[0];
                }
                if (plat.findTool("javac") != null) {
                    this.justCreatedPlatforms.add(plat);
                    return plat;
                }
                importProblems.add(NbBundle.getMessage(Importer.class, (String)"MSG_JRECannotBeUsed", (Object)eclProject.getName()));
                return null;
            }
            catch (IOException ex) {
                importProblems.add("Cannot create J2SE platform for '" + eclPlfFile + "'. Default platform will be used instead.");
                return null;
            }
        }
        importProblems.add(NbBundle.getMessage(Importer.class, (String)"MSG_JDKDoesnExistUseDefault", (Object)eclProject.getName(), (Object)eclPlfFile.getAbsolutePath()));
        return null;
    }
}

