/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.gradle.api.internal.classloading.GroovySystemLoader;
import org.gradle.api.internal.classloading.GroovySystemLoaderFactory;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.cache.internal.DefaultCrossBuildInMemoryCacheFactory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.CachingClassLoader;
import org.gradle.internal.classloader.ClassLoaderFactory;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.MultiParentClassLoader;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.event.DefaultListenerManager;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.instantiation.DefaultInstantiatorFactory;
import org.gradle.internal.io.ClassLoaderObjectInputStream;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.serialize.ExceptionReplacingObjectInputStream;
import org.gradle.internal.serialize.ExceptionReplacingObjectOutputStream;
import org.gradle.util.GUtil;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.internal.AbstractWorker;
import org.gradle.workers.internal.ActionExecutionSpec;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.DefaultWorkerServer;
import org.gradle.workers.internal.Worker;
import org.gradle.workers.internal.WorkerFactory;

public class IsolatedClassloaderWorkerFactory
implements WorkerFactory {
    private final ClassLoaderFactory classLoaderFactory;
    private final BuildOperationExecutor buildOperationExecutor;
    private final GroovySystemLoaderFactory groovySystemLoaderFactory = new GroovySystemLoaderFactory();

    public IsolatedClassloaderWorkerFactory(ClassLoaderFactory classLoaderFactory, BuildOperationExecutor buildOperationExecutor) {
        this.classLoaderFactory = classLoaderFactory;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public Worker getWorker(final DaemonForkOptions forkOptions) {
        return new AbstractWorker(this.buildOperationExecutor){

            @Override
            public DefaultWorkResult execute(ActionExecutionSpec spec, BuildOperationRef parentBuildOperation) {
                return this.executeWrappedInBuildOperation(spec, parentBuildOperation, new AbstractWorker.Work(){

                    @Override
                    public DefaultWorkResult execute(ActionExecutionSpec spec) {
                        return IsolatedClassloaderWorkerFactory.this.executeInWorkerClassLoader(spec, forkOptions);
                    }
                });
            }
        };
    }

    @Override
    public IsolationMode getIsolationMode() {
        return IsolationMode.CLASSLOADER;
    }

    private DefaultWorkResult executeInWorkerClassLoader(ActionExecutionSpec spec, DaemonForkOptions forkOptions) {
        DefaultWorkResult defaultWorkResult;
        ClassLoader actionClasspathLoader = this.createActionClasspathLoader(forkOptions);
        GroovySystemLoader actionClasspathGroovy = this.groovySystemLoaderFactory.forClassLoader(actionClasspathLoader);
        ClassLoader workerClassLoader = this.createWorkerClassLoader(actionClasspathLoader, forkOptions.getSharedPackages(), spec.getClass());
        ClassLoader previousContextLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(workerClassLoader);
            Callable<?> worker = this.transferWorkerIntoWorkerClassloader(spec, workerClassLoader);
            Object result = worker.call();
            defaultWorkResult = this.transferResultFromWorkerClassLoader(result);
        }
        catch (Exception e) {
            try {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
            catch (Throwable throwable) {
                actionClasspathGroovy.shutdown();
                CompositeStoppable.stoppable((Object[])new Object[]{workerClassLoader, actionClasspathLoader}).stop();
                Thread.currentThread().setContextClassLoader(previousContextLoader);
                throw throwable;
            }
        }
        actionClasspathGroovy.shutdown();
        CompositeStoppable.stoppable((Object[])new Object[]{workerClassLoader, actionClasspathLoader}).stop();
        Thread.currentThread().setContextClassLoader(previousContextLoader);
        return defaultWorkResult;
    }

    private ClassLoader createActionClasspathLoader(DaemonForkOptions forkOptions) {
        return this.classLoaderFactory.createIsolatedClassLoader("worker-action-loader", DefaultClassPath.of(forkOptions.getClasspath()));
    }

    private ClassLoader createWorkerClassLoader(ClassLoader actionClasspathLoader, Iterable<String> sharedPackages, Class<?> actionClass) {
        FilteringClassLoader.Spec actionFilterSpec = new FilteringClassLoader.Spec();
        for (String packageName : sharedPackages) {
            actionFilterSpec.allowPackage(packageName);
        }
        ClassLoader actionFilteredClasspathLoader = this.classLoaderFactory.createFilteringClassLoader(actionClasspathLoader, actionFilterSpec);
        FilteringClassLoader.Spec gradleApiFilterSpec = new FilteringClassLoader.Spec();
        gradleApiFilterSpec.allowPackage("org.slf4j");
        gradleApiFilterSpec.allowClass(Logger.class);
        gradleApiFilterSpec.allowClass(LogLevel.class);
        gradleApiFilterSpec.allowPackage("org.gradle.internal.nativeintegration");
        gradleApiFilterSpec.allowPackage("org.gradle.internal.nativeplatform");
        gradleApiFilterSpec.allowPackage("net.rubygrapefruit.platform");
        ClassLoader gradleApiLoader = this.classLoaderFactory.createFilteringClassLoader(actionClass.getClassLoader(), gradleApiFilterSpec);
        CachingClassLoader actionAndGradleApiLoader = new CachingClassLoader((ClassLoader)new MultiParentClassLoader(new ClassLoader[]{gradleApiLoader, actionFilteredClasspathLoader}));
        return new VisitableURLClassLoader("worker-loader", (ClassLoader)actionAndGradleApiLoader, ClasspathUtil.getClasspath((ClassLoader)actionClass.getClassLoader()));
    }

    private Callable<?> transferWorkerIntoWorkerClassloader(ActionExecutionSpec spec, ClassLoader workerClassLoader) throws IOException, ClassNotFoundException {
        byte[] serializedWorker = GUtil.serialize((Object)new WorkerCallable(spec));
        ClassLoaderObjectInputStream ois = new ClassLoaderObjectInputStream((InputStream)new ByteArrayInputStream(serializedWorker), workerClassLoader);
        return (Callable)ois.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultWorkResult transferResultFromWorkerClassLoader(Object result) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream resultBytes = new ByteArrayOutputStream();
        ExceptionReplacingObjectOutputStream oos = new ExceptionReplacingObjectOutputStream((OutputStream)resultBytes);
        try {
            oos.writeObject(result);
        }
        finally {
            oos.close();
        }
        ExceptionReplacingObjectInputStream ois = new ExceptionReplacingObjectInputStream((InputStream)new ByteArrayInputStream(resultBytes.toByteArray()), this.getClass().getClassLoader());
        return (DefaultWorkResult)ois.readObject();
    }

    private static class WorkerCallable
    implements Callable<Object>,
    Serializable {
        private final ActionExecutionSpec spec;

        private WorkerCallable(ActionExecutionSpec spec) {
            this.spec = spec;
        }

        @Override
        public Object call() throws Exception {
            DefaultInstantiatorFactory instantiatorFactory = new DefaultInstantiatorFactory((CrossBuildInMemoryCacheFactory)new DefaultCrossBuildInMemoryCacheFactory((ListenerManager)new DefaultListenerManager()), Collections.emptyList());
            DefaultWorkerServer worker = new DefaultWorkerServer(instantiatorFactory.inject());
            return worker.execute(this.spec);
        }
    }
}

