/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.timeline;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.gephi.desktop.timeline.DrawerSettings;
import org.gephi.desktop.timeline.Sparkline;
import org.gephi.desktop.timeline.TickGraph;
import org.gephi.desktop.timeline.TimelineTooltip;
import org.gephi.timeline.api.TimelineChart;
import org.gephi.timeline.api.TimelineController;
import org.gephi.timeline.api.TimelineModel;
import org.gephi.timeline.api.TimelineModelEvent;
import org.openide.util.Lookup;

public class TimelineDrawer
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final Cursor CURSOR_DEFAULT = new Cursor(0);
    private static final Cursor CURSOR_LEFT_HOOK = new Cursor(11);
    private static final Cursor CURSOR_CENTRAL_HOOK = new Cursor(13);
    private static final Cursor CURSOR_RIGHT_HOOK = new Cursor(10);
    private static final int LOC_RESIZE_FROM = 1;
    private static final int LOC_RESIZE_TO = 2;
    private static final int LOC_RESIZE_CENTER = 3;
    private static final int LOC_RESIZE_UNKNOWN = -1;
    private final DrawerSettings settings = new DrawerSettings();
    private Integer latestMousePositionX = null;
    private int currentMousePositionX = 0;
    private boolean mouseInside = false;
    private TimelineModel model;
    private TimelineController controller;
    private final TickGraph tickGraph = new TickGraph();
    private final Sparkline sparkline = new Sparkline();
    private final TimelineTooltip tooltip = new TimelineTooltip();
    TimelineState currentState = TimelineState.IDLE;
    HighlightedComponent highlightedComponent = HighlightedComponent.NONE;

    public TimelineDrawer() {
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public void consumeEvent(TimelineModelEvent event) {
        switch (event.getEventType()) {
            case INTERVAL: {
                double[] data = (double[])event.getData();
                this.setInterval(data[0], data[1]);
                break;
            }
            case CUSTOM_BOUNDS: {
                double[] data2 = (double[])event.getData();
                this.setCustomBounds(data2[0], data2[1]);
                break;
            }
            case MIN_MAX: {
                double[] data3 = (double[])event.getData();
                this.setMinMax(data3[0], data3[1]);
                break;
            }
            case CHART: {
                this.setChart((TimelineChart)event.getData());
            }
        }
    }

    public void setModel(TimelineModel model) {
        this.controller = (TimelineController)Lookup.getDefault().lookup(TimelineController.class);
        this.model = model;
        if (model != null) {
            this.setMinMax(model.getMin(), model.getMax());
            if (model.hasCustomBounds()) {
                this.setCustomBounds(model.getCustomMin(), model.getCustomMax());
            }
            this.setInterval(model.getIntervalStart(), model.getIntervalEnd());
        } else {
            this.repaint();
        }
    }

    public void setChart(TimelineChart chart) {
        this.repaint();
    }

    public void setMinMax(double min, double max) {
        this.repaint();
    }

    public void setCustomBounds(double min, double max) {
        this.repaint();
    }

    public void setInterval(double from, double to) {
        this.repaint();
    }

    public int getPixelPosition(double val, double duration, double min, int width) {
        return (int)((val - min) * ((double)width / duration));
    }

    public double getReal(int pixel, double duration, double min, int width) {
        return (double)pixel * (duration / (double)width) + min;
    }

    private void initComponents() {
        this.setMinimumSize(new Dimension(300, 28));
        this.setLayout(new BorderLayout());
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getWidth();
        int height = this.getHeight();
        this.settings.update(width, height);
        Graphics2D g2d = (Graphics2D)g;
        int innerWidth = width - 1;
        int innerHeight = height - this.settings.tmMarginBottom - 2;
        int innerY = this.settings.tmMarginTop + 1;
        if (this.settings.background.top != null) {
            g2d.setColor(this.settings.background.top);
            g2d.fillRect(0, innerY, innerWidth, innerHeight);
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.model == null) {
            return;
        }
        double min = this.model.getCustomMin();
        double max = this.model.getCustomMax();
        double intervalStart = this.model.getIntervalStart();
        double intervalEnd = this.model.getIntervalEnd();
        int intervalStartPixel = Math.max(0, this.getPixelPosition(intervalStart, max - min, min, width));
        int intervalEndPixel = Math.min(width, this.getPixelPosition(intervalEnd, max - min, min, width));
        g2d.setRenderingHints(this.settings.renderingHints);
        g2d.drawImage((Image)this.tickGraph.getImage(this.model, innerWidth, innerHeight), 0, innerY, null);
        if (this.model.getChart() != null) {
            BufferedImage spImage = this.sparkline.getImage(this.model, innerWidth, innerHeight - this.settings.topChartMargin);
            g2d.drawImage((Image)spImage, 0, innerY + this.settings.topChartMargin, null);
        }
        int vhw = this.settings.selection.visibleHookWidth;
        int sw = intervalEndPixel - intervalStartPixel;
        if (this.highlightedComponent != HighlightedComponent.NONE) {
            g2d.setPaint(this.settings.selection.mouseOverPaint);
            switch (this.highlightedComponent) {
                case LEFT_HOOK: {
                    g2d.fillRect(intervalStartPixel, this.settings.tmMarginTop, vhw, height - this.settings.tmMarginBottom - 1);
                    g2d.setPaint(this.settings.selection.paint);
                    g2d.fillRect(intervalStartPixel + vhw, this.settings.tmMarginTop, sw - vhw, height - this.settings.tmMarginBottom - 1);
                    break;
                }
                case CENTER_HOOK: {
                    g2d.setPaint(this.settings.selection.paint);
                    g2d.fillRect(intervalStartPixel, this.settings.tmMarginTop, vhw, height - this.settings.tmMarginBottom - 1);
                    g2d.setPaint(this.settings.selection.mouseOverPaint);
                    g2d.fillRect(intervalStartPixel + vhw, this.settings.tmMarginTop, sw - vhw * 2, height - this.settings.tmMarginBottom - 1);
                    g2d.setPaint(this.settings.selection.paint);
                    g2d.fillRect(intervalEndPixel - vhw, this.settings.tmMarginTop, vhw, height - this.settings.tmMarginBottom - 1);
                    break;
                }
                case RIGHT_HOOK: {
                    g2d.setPaint(this.settings.selection.paint);
                    g2d.fillRect(intervalStartPixel, this.settings.tmMarginTop, sw - vhw, height - this.settings.tmMarginBottom - 1);
                    g2d.setPaint(this.settings.selection.mouseOverPaint);
                    g2d.fillRect(intervalEndPixel - vhw, this.settings.tmMarginTop, vhw, height - this.settings.tmMarginBottom - 1);
                }
            }
        } else {
            g2d.setPaint(this.settings.selection.paint);
            g2d.fillRect(intervalStartPixel, this.settings.tmMarginTop, sw, height - this.settings.tmMarginBottom - 1);
        }
        g2d.setColor(this.settings.defaultStrokeColor);
        g2d.drawRect(intervalStartPixel, this.settings.tmMarginTop, sw - 1, height - this.settings.tmMarginBottom - 1);
        double v = this.getReal(this.currentMousePositionX, max - min, min, width);
    }

    private boolean inRange(int x, int a, int b) {
        return a < x && x < b;
    }

    private int inPosition(int x, int r, int sf, int st) {
        boolean resizeFrom = this.inRange(x, sf - 1, sf + r + 1);
        boolean resizeTo = this.inRange(x, st - r - 1, st + 1);
        if (resizeFrom && resizeTo) {
            if (this.inRange(x, sf - 1, (sf + st) / 2)) {
                return 1;
            }
            if (this.inRange(x, (sf + st) / 2, st + 1)) {
                return 2;
            }
        }
        if (resizeFrom) {
            return 1;
        }
        if (this.inRange(x, sf + r, st - r)) {
            return 3;
        }
        if (resizeTo) {
            return 2;
        }
        return -1;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.latestMousePositionX = e.getX();
        this.currentMousePositionX = this.latestMousePositionX;
        if (e.getClickCount() == 2) {
            int x = e.getX();
            int r = this.settings.selection.visibleHookWidth + this.settings.selection.invisibleHookMargin;
            int width = this.getWidth();
            double min = this.model.getCustomMin();
            double max = this.model.getCustomMax();
            double intervalStart = this.model.getIntervalStart();
            double intervalEnd = this.model.getIntervalEnd();
            int sf = Math.max(0, this.getPixelPosition(intervalStart, max - min, min, width));
            int st = Math.min(width, this.getPixelPosition(intervalEnd, max - min, min, width));
            int position = this.inPosition(x, r, sf, st);
            switch (position) {
                case 1: {
                    this.controller.setInterval(min, intervalEnd);
                    break;
                }
                case 3: {
                    this.controller.setInterval(min, max);
                    break;
                }
                case 2: {
                    this.controller.setInterval(intervalStart, max);
                }
            }
            this.setInterval(this.model.getIntervalStart(), this.model.getIntervalEnd());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.model == null) {
            return;
        }
        int x = e.getX();
        this.latestMousePositionX = x;
        this.currentMousePositionX = this.latestMousePositionX;
        int r = this.settings.selection.visibleHookWidth + this.settings.selection.invisibleHookMargin;
        this.tooltip.stop();
        int width = this.getWidth();
        double min = this.model.getCustomMin();
        double max = this.model.getCustomMax();
        double intervalStart = this.model.getIntervalStart();
        double intervalEnd = this.model.getIntervalEnd();
        int sf = Math.max(0, this.getPixelPosition(intervalStart, max - min, min, width));
        int st = Math.min(width, this.getPixelPosition(intervalEnd, max - min, min, width));
        if (this.currentState == TimelineState.IDLE) {
            int position = this.inPosition(x, r, sf, st);
            switch (position) {
                case 1: {
                    this.highlightedComponent = HighlightedComponent.LEFT_HOOK;
                    this.currentState = TimelineState.RESIZE_FROM;
                    break;
                }
                case 3: {
                    this.highlightedComponent = HighlightedComponent.CENTER_HOOK;
                    this.currentState = TimelineState.MOVING;
                    break;
                }
                case 2: {
                    this.highlightedComponent = HighlightedComponent.RIGHT_HOOK;
                    this.currentState = TimelineState.RESIZE_TO;
                    break;
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.currentState == TimelineState.IDLE) {
            this.latestMousePositionX = e.getX();
            this.currentMousePositionX = this.latestMousePositionX;
        }
        this.mouseInside = true;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.currentState == TimelineState.IDLE) {
            this.highlightedComponent = HighlightedComponent.NONE;
            this.latestMousePositionX = e.getX();
            this.currentMousePositionX = this.latestMousePositionX;
        }
        this.mouseInside = false;
        this.tooltip.stop();
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.latestMousePositionX = evt.getX();
        this.currentMousePositionX = this.latestMousePositionX;
        this.currentState = TimelineState.IDLE;
        this.getParent().repaint();
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        Cursor newCursor;
        if (this.model == null) {
            return;
        }
        int x = this.currentMousePositionX = evt.getX();
        int width = this.getWidth();
        int r = this.settings.selection.visibleHookWidth;
        double min = this.model.getCustomMin();
        double max = this.model.getCustomMax();
        double intervalStart = this.model.getIntervalStart();
        double intervalEnd = this.model.getIntervalEnd();
        int sf = Math.max(0, this.getPixelPosition(intervalStart, max - min, min, width));
        int st = Math.min(width, this.getPixelPosition(intervalEnd, max - min, min, width));
        double pos = this.getReal(this.currentMousePositionX, max - min, min, width);
        this.tooltip.setModel(this.model);
        this.tooltip.start(pos, evt.getLocationOnScreen(), this);
        HighlightedComponent old = this.highlightedComponent;
        boolean a = false;
        int position = this.inPosition(x, r, sf, st);
        switch (position) {
            case 1: {
                newCursor = CURSOR_LEFT_HOOK;
                this.highlightedComponent = HighlightedComponent.LEFT_HOOK;
                break;
            }
            case 3: {
                this.highlightedComponent = HighlightedComponent.CENTER_HOOK;
                newCursor = CURSOR_CENTRAL_HOOK;
                break;
            }
            case 2: {
                this.highlightedComponent = HighlightedComponent.RIGHT_HOOK;
                newCursor = CURSOR_RIGHT_HOOK;
                break;
            }
            default: {
                this.highlightedComponent = HighlightedComponent.NONE;
                newCursor = CURSOR_DEFAULT;
            }
        }
        if (newCursor != this.getCursor()) {
            this.setCursor(newCursor);
        }
        if (this.highlightedComponent != old) {
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (this.model == null) {
            return;
        }
        int width = this.getWidth();
        double min = this.model.getCustomMin();
        double max = this.model.getCustomMax();
        double intervalStart = this.model.getIntervalStart();
        double intervalEnd = this.model.getIntervalEnd();
        int sf = Math.max(0, this.getPixelPosition(intervalStart, max - min, min, width));
        int st = Math.min(width, this.getPixelPosition(intervalEnd, max - min, min, width));
        this.currentMousePositionX = evt.getX();
        this.currentMousePositionX = Math.max(0, this.currentMousePositionX);
        int x = this.currentMousePositionX = Math.min(width, this.currentMousePositionX);
        this.tooltip.stop();
        int r = this.settings.selection.visibleHookWidth;
        if (this.currentState == TimelineState.IDLE) {
            int position = this.inPosition(x, r, sf, st);
            switch (position) {
                case 1: {
                    this.highlightedComponent = HighlightedComponent.LEFT_HOOK;
                    this.currentState = TimelineState.RESIZE_FROM;
                    break;
                }
                case 3: {
                    this.highlightedComponent = HighlightedComponent.CENTER_HOOK;
                    this.currentState = TimelineState.MOVING;
                    break;
                }
                case 2: {
                    this.highlightedComponent = HighlightedComponent.RIGHT_HOOK;
                    this.currentState = TimelineState.RESIZE_TO;
                    break;
                }
            }
        }
        int deltaPx = 0;
        if (this.latestMousePositionX != null) {
            deltaPx = x - this.latestMousePositionX;
        }
        this.latestMousePositionX = x;
        double deltaTimestamp = this.getReal(deltaPx, max - min, 0.0, width);
        double newFrom = intervalStart;
        double newTo = intervalEnd;
        switch (this.currentState) {
            case RESIZE_FROM: {
                newFrom += deltaTimestamp;
                break;
            }
            case RESIZE_TO: {
                newTo += deltaTimestamp;
                break;
            }
            case MOVING: {
                if (sf + deltaPx < 0) {
                    newTo -= newFrom;
                    newFrom = min;
                    break;
                }
                if (st + deltaPx >= width) {
                    newFrom = max - (newTo - newFrom);
                    newTo = max;
                    break;
                }
                newFrom += deltaTimestamp;
                newTo += deltaTimestamp;
            }
        }
        int s = this.settings.selection.minimalWidth;
        int sfNew = Math.max(0, this.getPixelPosition(newFrom, max - min, min, width));
        int stNew = Math.min(width, this.getPixelPosition(newTo, max - min, min, width));
        if (width != 0 && stNew - sfNew >= s && (newFrom = Math.max(newFrom, this.model.getCustomMin())) < (newTo = Math.min(newTo, this.model.getCustomMax()))) {
            this.controller.setInterval(newFrom, newTo);
        }
    }

    public static enum HighlightedComponent {
        NONE,
        LEFT_HOOK,
        RIGHT_HOOK,
        CENTER_HOOK;

    }

    public static enum TimelineState {
        IDLE,
        MOVING,
        RESIZE_FROM,
        RESIZE_TO;

    }
}

